/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.util.Objects;
import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowDressing;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ArrowConfiguration {
    private final ArrowBody body;
    private final ArrowDressing dressing1;
    private final ArrowDressing dressing2;
    private final ArrowDecoration decoration1;
    private final ArrowDecoration decoration2;
    private final HColor color;
    private final boolean isSelf;
    private final double thickness;
    private final boolean reverseDefine;
    private final int inclination;

    private ArrowConfiguration(ArrowBody body, ArrowDressing dressing1, ArrowDressing dressing2, ArrowDecoration decoration1, ArrowDecoration decoration2, HColor color, boolean isSelf, double thickness, boolean reverseDefine, int inclination) {
        this.reverseDefine = reverseDefine;
        this.thickness = thickness;
        this.body = Objects.requireNonNull(body);
        this.dressing1 = Objects.requireNonNull(dressing1);
        this.dressing2 = Objects.requireNonNull(dressing2);
        this.decoration1 = decoration1;
        this.decoration2 = decoration2;
        this.color = color;
        this.isSelf = isSelf;
        this.inclination = inclination;
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return this.body.name() + "(" + this.dressing1.name() + " " + (Object)((Object)this.decoration1) + ")(" + this.dressing2.name() + " " + (Object)((Object)this.decoration2) + ")" + this.isSelf + " " + this.color;
    }

    public static ArrowConfiguration withDirectionNormal() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create(), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null, false, 1.0, false, 0);
    }

    public static ArrowConfiguration withDirectionBoth() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null, false, 1.0, false, 0);
    }

    public static ArrowConfiguration withDirectionSelf(boolean reverseDefine) {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create(), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null, true, 1.0, reverseDefine, 0);
    }

    public static ArrowConfiguration withDirectionReverse() {
        return ArrowConfiguration.withDirectionNormal().reverse();
    }

    public ArrowConfiguration reverse() {
        return new ArrowConfiguration(this.body, this.dressing2, this.dressing1, this.decoration2, this.decoration1, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration self() {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, true, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration withBody(ArrowBody type) {
        return new ArrowConfiguration(type, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration withHead(ArrowHead head) {
        ArrowDressing newDressing1 = ArrowConfiguration.addHead(this.dressing1, head);
        ArrowDressing newDressing2 = ArrowConfiguration.addHead(this.dressing2, head);
        return new ArrowConfiguration(this.body, newDressing1, newDressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    private static ArrowDressing addHead(ArrowDressing dressing, ArrowHead head) {
        if (dressing.getHead() == ArrowHead.NONE) {
            return dressing;
        }
        return dressing.withHead(head);
    }

    public ArrowConfiguration withHead1(ArrowHead head) {
        return new ArrowConfiguration(this.body, this.dressing1.withHead(head), this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration withHead2(ArrowHead head) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2.withHead(head), this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration withPart(ArrowPart part) {
        if (this.dressing2.getHead() != ArrowHead.NONE) {
            return new ArrowConfiguration(this.body, this.dressing1, this.dressing2.withPart(part), this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
        }
        return new ArrowConfiguration(this.body, this.dressing1.withPart(part), this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration withDecoration1(ArrowDecoration decoration1) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration withDecoration2(ArrowDecoration decoration2) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration withColor(HColor color) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, color, this.isSelf, this.thickness, this.reverseDefine, this.inclination);
    }

    public final ArrowDecoration getDecoration1() {
        return this.decoration1;
    }

    public final ArrowDecoration getDecoration2() {
        return this.decoration2;
    }

    public final ArrowDirection getArrowDirection() {
        if (this.isSelf) {
            return ArrowDirection.SELF;
        }
        if (this.dressing1.getHead() == ArrowHead.NONE && this.dressing2.getHead() != ArrowHead.NONE) {
            return ArrowDirection.LEFT_TO_RIGHT_NORMAL;
        }
        if (this.dressing1.getHead() != ArrowHead.NONE && this.dressing2.getHead() == ArrowHead.NONE) {
            return ArrowDirection.RIGHT_TO_LEFT_REVERSE;
        }
        return ArrowDirection.BOTH_DIRECTION;
    }

    public boolean isSelfArrow() {
        return this.getArrowDirection() == ArrowDirection.SELF;
    }

    public boolean isDotted() {
        return this.body == ArrowBody.DOTTED;
    }

    public boolean isHidden() {
        return this.body == ArrowBody.HIDDEN;
    }

    public ArrowHead getHead() {
        if (this.dressing2 != null && this.dressing2.getHead() != ArrowHead.NONE) {
            return this.dressing2.getHead();
        }
        return this.dressing1.getHead();
    }

    public boolean isAsync() {
        return this.dressing1.getHead() == ArrowHead.ASYNC || this.dressing2.getHead() == ArrowHead.ASYNC;
    }

    public final ArrowPart getPart() {
        if (this.dressing2.getHead() != ArrowHead.NONE) {
            return this.dressing2.getPart();
        }
        return this.dressing1.getPart();
    }

    public HColor getColor() {
        return this.color;
    }

    public ArrowDressing getDressing1() {
        return this.dressing1;
    }

    public ArrowDressing getDressing2() {
        return this.dressing2;
    }

    public static UGraphic stroke(UGraphic ug, double dashVisible, double dashSpace, double thickness) {
        return ug.apply(new UStroke(dashVisible, dashSpace, thickness));
    }

    public UGraphic applyStroke(UGraphic ug) {
        if (this.isDotted()) {
            return ug.apply(new UStroke(2.0, 2.0, this.thickness));
        }
        return ug.apply(new UStroke(this.thickness));
    }

    public UGraphic applyThicknessOnly(UGraphic ug) {
        return ug.apply(new UStroke(this.thickness));
    }

    public ArrowConfiguration withThickness(double thickness) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, thickness, this.reverseDefine, this.inclination);
    }

    public ArrowConfiguration reverseDefine() {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, !this.reverseDefine, this.inclination);
    }

    public final boolean isReverseDefine() {
        return this.reverseDefine;
    }

    public ArrowConfiguration withInclination(int inclination) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness, this.reverseDefine, inclination);
    }

    public final int getInclination1() {
        if (this.dressing2.getHead() == ArrowHead.NONE) {
            return this.inclination;
        }
        return 0;
    }

    public final int getInclination2() {
        if (this.dressing1.getHead() == ArrowHead.NONE) {
            return this.inclination;
        }
        return 0;
    }
}

