/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.EnumMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageBranch
extends AbstractEntityImage {
    private static final int SIZE = 12;

    public EntityImageBranch(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    public StyleSignatureBasic getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor border = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor back = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        UStroke stroke = style.getStroke();
        double shadowing = style.value(PName.Shadowing).asDouble();
        diams.setDeltaShadow(shadowing);
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getCode());
        ug.startGroup(typeIDent);
        ug.apply(border).apply(back.bg()).apply(stroke).draw(diams);
        ug.closeGroup();
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }
}

