/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.klimt.UAntiAliasing;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverCenteredCharacterG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverDotPathG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverEllipseG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverImageG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverLineG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverPathG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverPixelG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverPolygonG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverTextAsPathG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverTextG2d;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.EnsureVisible;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPixel;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.url.Url;

public class UGraphicG2d
extends AbstractUGraphic<Graphics2D>
implements EnsureVisible {
    private BufferedImage bufferedImage;
    private final double dpiFactor;
    private final FileFormat format;
    private UAntiAliasing antiAliasing = UAntiAliasing.ANTI_ALIASING_ON;
    private List<Url> urls = new ArrayList<Url>();
    private Set<Url> allUrls = new HashSet<Url>();

    public final Set<Url> getAllUrlsEncountered() {
        return Collections.unmodifiableSet(this.allUrls);
    }

    @Override
    public UGraphic apply(UChange change) {
        UGraphicG2d copy = (UGraphicG2d)super.apply(change);
        if (change instanceof UAntiAliasing) {
            copy.antiAliasing = (UAntiAliasing)change;
        }
        return copy;
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        UGraphicG2d result = new UGraphicG2d(this);
        return result;
    }

    private UGraphicG2d(UGraphicG2d other) {
        super(other.getStringBounder());
        this.copy(other);
        this.dpiFactor = other.dpiFactor;
        this.bufferedImage = other.bufferedImage;
        this.urls = other.urls;
        this.allUrls = other.allUrls;
        this.antiAliasing = other.antiAliasing;
        this.format = other.format;
        this.register(this.dpiFactor);
    }

    public UGraphicG2d(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, Graphics2D g2d, double dpiFactor, FileFormat format) {
        super(stringBounder);
        this.copy(defaultBackground, colorMapper, g2d);
        this.format = format;
        this.dpiFactor = dpiFactor;
        if (dpiFactor != 1.0) {
            g2d.scale(dpiFactor, dpiFactor);
        }
        this.register(dpiFactor);
    }

    private void register(double dpiFactor) {
        this.registerDriver(URectangle.class, new DriverRectangleG2d(dpiFactor, this));
        if (dpiFactor != 1.0) {
            this.registerDriver(UText.class, new DriverTextAsPathG2d(this, this.getStringBounder()));
        } else {
            this.registerDriver(UText.class, new DriverTextG2d(this, this.getStringBounder()));
        }
        this.registerDriver(ULine.class, new DriverLineG2d(dpiFactor));
        this.registerDriver(UPixel.class, new DriverPixelG2d());
        this.registerDriver(UPolygon.class, new DriverPolygonG2d(dpiFactor, this));
        this.registerDriver(UEllipse.class, new DriverEllipseG2d(dpiFactor, this));
        this.ignoreShape(UImageSvg.class);
        this.registerDriver(UImage.class, new DriverImageG2d(dpiFactor, this));
        this.registerDriver(DotPath.class, new DriverDotPathG2d(this));
        this.registerDriver(UPath.class, new DriverPathG2d(dpiFactor));
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterG2d());
    }

    @Override
    protected void beforeDraw() {
        super.beforeDraw();
        this.applyClip();
        this.antiAliasing.apply((Graphics2D)this.getGraphicObject());
    }

    private void applyClip() {
        UClip uclip = this.getClip();
        if (uclip == null) {
            ((Graphics2D)this.getGraphicObject()).setClip(null);
        } else {
            Rectangle2D.Double clip = new Rectangle2D.Double(uclip.getX(), uclip.getY(), uclip.getWidth(), uclip.getHeight());
            ((Graphics2D)this.getGraphicObject()).setClip(clip);
        }
    }

    protected final double getDpiFactor() {
        return this.dpiFactor;
    }

    @Override
    public void startUrl(Url url) {
        Objects.requireNonNull(url);
        if (SecurityUtils.ignoreThisLink(url.getUrl())) {
            this.urls.add(null);
        } else {
            this.urls.add(url);
            this.allUrls.add(url);
        }
    }

    @Override
    public void closeUrl() {
        this.urls.remove(this.urls.size() - 1);
    }

    @Override
    public void ensureVisible(double x, double y) {
        for (Url u : this.urls) {
            if (u == null || this.getClip() != null && !this.getClip().isInside(x, y)) continue;
            u.ensureVisible(x, y);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public Graphics2D getGraphics2D() {
        return (Graphics2D)this.getGraphicObject();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        BufferedImage im = this.getBufferedImage();
        PngIO.write((RenderedImage)im, this.getColorMapper(), os, metadata, dpi);
    }

    @Override
    public double dpiFactor() {
        return this.dpiFactor;
    }
}

