/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandLinkActivity
extends SingleLineCommand2<ActivityDiagram> {
    public CommandLinkActivity() {
        super(CommandLinkActivity.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkActivity.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexOr("FIRST", new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([%pLN][%pLN_.]*)"), new RegexLeaf("BAR", "(?:==+)[%s]*([%pLN_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([%pLN_.]+))?"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp2(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, new RegexLeaf("ARROW_BODY1", "([-.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(\\*|left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-.]*)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("BRACKET", "\\[([^\\]*]+[^\\]]*)\\]")), RegexLeaf.spaceZeroOrMore(), new RegexOr("FIRST2", new RegexLeaf("STAR2", "(\\(\\*(top|\\d+)?\\))"), new RegexLeaf("OPENBRACKET2", "(\\{)"), new RegexLeaf("CODE2", "([%pLN][%pLN_.]*)"), new RegexLeaf("BAR2", "(?:==+)[%s]*([%pLN_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED2", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([%pLN][%pLN_.]*))?"), new RegexLeaf("QUOTED_INVISIBLE2", "(\\w.*?)")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("in"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTITION2", "([%g][^%g]+[%g]|\\S+)"))), RegexLeaf.spaceZeroOrMore(), ColorParser.exp3(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Direction direction;
        IEntity entity2;
        IEntity entity1 = CommandLinkActivity.getEntity(diagram, arg, true);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such activity");
        }
        if (arg.get("STEREOTYPE", 0) != null) {
            entity1.setStereotype(Stereotype.build(arg.get("STEREOTYPE", 0)));
        }
        if (arg.get("BACKCOLOR", 0) != null) {
            String s = arg.get("BACKCOLOR", 0);
            entity1.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        }
        if ((entity2 = CommandLinkActivity.getEntity(diagram, arg, false)) == null) {
            return CommandExecutionResult.error("No such activity");
        }
        if (arg.get("BACKCOLOR2", 0) != null) {
            String s = arg.get("BACKCOLOR2", 0);
            entity2.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        }
        if (arg.get("STEREOTYPE2", 0) != null) {
            entity2.setStereotype(Stereotype.build(arg.get("STEREOTYPE2", 0)));
        }
        Display linkLabel = Display.getWithNewlines(arg.get("BRACKET", 0));
        String arrowBody1 = CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0));
        String arrowBody2 = CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0));
        String arrowDirection = CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0));
        String arrow = StringUtils.manageArrowForCuca(arrowBody1 + arrowDirection + arrowBody2 + ">");
        int lenght = arrow.length() - 1;
        if (arrowDirection.contains("*")) {
            lenght = 2;
        }
        LinkType type = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        if ((arrowBody1 + arrowBody2).contains(".")) {
            type = type.goDotted();
        }
        LinkArg linkArg = LinkArg.build(linkLabel, lenght, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), entity1, entity2, type, linkArg);
        if (arrowDirection.contains("*")) {
            link.setConstraint(false);
        }
        if ((direction = StringUtils.getArrowDirection(arrowBody1 + arrowDirection + arrowBody2 + ">")) == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        if (arg.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url urlLink = urlBuilder.getUrl(arg.get("URL", 0));
            link.setUrl(urlLink);
        }
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    static IEntity getEntity(ActivityDiagram diagram, RegexResult arg, boolean start) {
        String idShort;
        String suf = start ? "" : "2";
        String openBracket2 = arg.get("OPENBRACKET" + suf, 0);
        if (openBracket2 != null) {
            return diagram.createInnerActivity();
        }
        if (arg.get("STAR" + suf, 0) != null) {
            String suppId = arg.get("STAR" + suf, 1);
            if (start) {
                return diagram.getStart();
            }
            return diagram.getEnd(suppId);
        }
        String partition = arg.get("PARTITION" + suf, 0);
        if (partition != null) {
            partition = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(partition);
        }
        if ((idShort = arg.get("CODE" + suf, 0)) != null) {
            if (partition != null) {
                Ident idNewLong = diagram.buildLeafIdent(partition);
                Code codeP = diagram.buildCode(partition);
                diagram.gotoGroup(idNewLong, codeP, Display.getWithNewlines(partition), GroupType.PACKAGE, diagram.getRootGroup(), NamespaceStrategy.SINGLE);
            }
            Ident ident = diagram.buildLeafIdent(idShort);
            Code code = diagram.buildCode(idShort);
            LeafType type = CommandLinkActivity.getTypeIfExisting(diagram, code);
            IEntity result = diagram.getOrCreate(ident, code, Display.getWithNewlines(code), type);
            if (partition != null) {
                diagram.endGroup();
            }
            return result;
        }
        String bar = arg.get("BAR" + suf, 0);
        if (bar != null) {
            Ident identBar = diagram.buildLeafIdent(bar);
            Code codeBar = diagram.buildCode(bar);
            return diagram.getOrCreate(identBar, codeBar, Display.getWithNewlines(bar), LeafType.SYNCHRO_BAR);
        }
        RegexPartialMatch quoted = arg.get("QUOTED" + suf);
        if (quoted.get(0) != null) {
            String quotedString;
            String string = quotedString = quoted.get(1) == null ? quoted.get(0) : quoted.get(1);
            if (partition != null) {
                Ident idNewLong = diagram.buildLeafIdent(partition);
                Code codeP = diagram.buildCode(partition);
                diagram.gotoGroup(idNewLong, codeP, Display.getWithNewlines(partition), GroupType.PACKAGE, diagram.getRootGroup(), NamespaceStrategy.SINGLE);
            }
            Ident quotedIdent = diagram.buildLeafIdent(quotedString);
            Code quotedCode = diagram.buildCode(quotedString);
            LeafType type = CommandLinkActivity.getTypeIfExisting(diagram, quotedCode);
            IEntity result = diagram.getOrCreate(quotedIdent, quotedCode, Display.getWithNewlines(quoted.get(0)), type);
            if (partition != null) {
                diagram.endGroup();
            }
            return result;
        }
        String quoteInvisibleString = arg.get("QUOTED_INVISIBLE" + suf, 0);
        if (quoteInvisibleString != null) {
            if (partition != null) {
                Ident idNewLong = diagram.buildLeafIdent(partition);
                Code codeP = diagram.buildCode(partition);
                diagram.gotoGroup(idNewLong, codeP, Display.getWithNewlines(partition), GroupType.PACKAGE, diagram.getRootGroup(), NamespaceStrategy.SINGLE);
            }
            Ident identInvisible = diagram.buildLeafIdent(quoteInvisibleString);
            Code quotedInvisible = diagram.buildCode(quoteInvisibleString);
            IEntity result = diagram.getOrCreate(identInvisible, quotedInvisible, Display.getWithNewlines(quotedInvisible), LeafType.ACTIVITY);
            if (partition != null) {
                diagram.endGroup();
            }
            return result;
        }
        String first = arg.get("FIRST" + suf, 0);
        if (first == null) {
            return diagram.getLastEntityConsulted();
        }
        return null;
    }

    private static LeafType getTypeIfExisting(ActivityDiagram system, Code code) {
        ILeaf ent;
        if (system.leafExist(code) && (ent = system.getLeaf(code)).getLeafType() == LeafType.BRANCH) {
            return LeafType.BRANCH;
        }
        return LeafType.ACTIVITY;
    }
}

