/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.text.RichText;
import net.sourceforge.plantuml.text.StyledString;
import net.sourceforge.plantuml.ugraphic.UFont;

public abstract class StringBounderRaw
implements StringBounder {
    @Override
    public final XDimension2D calculateDimension(UFont font, String text) {
        if (RichText.isRich(text)) {
            double width = 0.0;
            double height = 0.0;
            for (StyledString s : StyledString.build(text)) {
                UFont newFont = s.getStyle().mutateFont(font);
                XDimension2D rect = this.calculateDimensionInternal(newFont, s.getText());
                width += rect.getWidth();
                height = Math.max(height, rect.getHeight());
            }
            return new XDimension2D(width, height);
        }
        return this.calculateDimensionInternal(font, text);
    }

    protected abstract XDimension2D calculateDimensionInternal(UFont var1, String var2);

    @Override
    public double getDescent(UFont font, String text) {
        FontRenderContext frc = FileFormat.gg.getFontRenderContext();
        LineMetrics lineMetrics = font.getUnderlayingFont().getLineMetrics(text, frc);
        double descent = lineMetrics.getDescent();
        return descent;
    }
}

