/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class Arrow {
    private final XPoint2D p1;
    private final XPoint2D p2;

    public Arrow(XPoint2D p1, XPoint2D p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public void drawArrow(UGraphic ug) {
        ug = ug.apply(new UStroke());
        ULine p1p2 = new ULine(this.p1, this.p2);
        double dist = this.p1.distance(this.p2);
        double alpha = Math.atan2(p1p2.getDX(), p1p2.getDY());
        double factor = 0.4;
        double factor2 = 0.3;
        XPoint2D p3 = this.getPoint(this.p1, alpha + 1.5707963267948966, dist * 0.4);
        XPoint2D p4 = this.getPoint(this.p1, alpha - 1.5707963267948966, dist * 0.4);
        XPoint2D p11 = this.getPoint(this.p1, alpha, dist * 0.3);
        UPath path = new UPath();
        path.moveTo(p4);
        path.lineTo(p11);
        path.lineTo(p3);
        path.lineTo(this.p2);
        path.lineTo(p4);
        path.closePath();
        ug.draw(path);
    }

    private XPoint2D getPoint(XPoint2D center, double alpha, double len) {
        double x = center.getX() + len * Math.sin(alpha);
        double y = center.getY() + len * Math.cos(alpha);
        return new XPoint2D(x, y);
    }
}

