/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class CircleInterface2
extends AbstractTextBlock
implements TextBlock {
    private final double margin = 1.0;
    private final double radius = 8.0;
    private final HColor backgroundColor;
    private final HColor foregroundColor;
    private final double deltaShadow;

    public CircleInterface2(HColor backgroundColor, HColor foregroundColor, double deltaShadow) {
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.deltaShadow = deltaShadow;
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        double y = 0.0;
        ug = ug.apply(this.backgroundColor.bg()).apply(this.foregroundColor);
        UEllipse circle = new UEllipse(16.0, 16.0);
        circle.setDeltaShadow(this.deltaShadow);
        ug.apply(new UTranslate(x += 1.0, y += 1.0)).draw(circle);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(18.0, 18.0);
    }
}

