/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.wbs.ITF;
import net.sourceforge.plantuml.wbs.ITFComposed;
import net.sourceforge.plantuml.wbs.WBSTextBlock;
import net.sourceforge.plantuml.wbs.WElement;

class Fork
extends WBSTextBlock {
    private final TextBlock main;
    private final List<ITF> right = new ArrayList<ITF>();
    private final double delta1x = 20.0;
    private final double deltay = 40.0;

    public Fork(ISkinParam skinParam, WElement idea) {
        super(idea.withBackColor(skinParam), idea.getStyleBuilder(), idea.getLevel());
        if (idea.getLevel() != 0) {
            throw new IllegalArgumentException();
        }
        this.main = this.buildMain(idea);
        for (WElement child : idea.getChildren(Direction.RIGHT)) {
            this.right.add(ITFComposed.build2(skinParam, child));
        }
    }

    @Override
    public void drawU(UGraphic ug) {
        double posMain;
        double firstX;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D mainDim = this.main.calculateDimension(stringBounder);
        double y0 = mainDim.getHeight();
        double y1 = y0 + 20.0;
        double y2 = y0 + 40.0;
        double mainWidth = mainDim.getWidth();
        if (this.right.size() == 0) {
            this.main.drawU(ug);
            this.drawLine(ug, mainWidth / 2.0, y0, mainWidth / 2.0, y1);
            return;
        }
        double x = 0.0;
        double lastX = firstX = this.right.get(0).getT1(stringBounder).getX();
        for (ITF child : this.right) {
            lastX = x + child.getT1(stringBounder).getX();
            this.drawLine(ug, lastX, y1, lastX, y2);
            child.drawU(ug.apply(new UTranslate(x, y2)));
            x += child.calculateDimension(stringBounder).getWidth() + 20.0;
        }
        if (lastX > firstX) {
            this.drawLine(ug, firstX, y1, lastX, y1);
            posMain = firstX + (lastX - firstX - mainWidth) / 2.0;
        } else {
            assert (lastX == firstX);
            XDimension2D fullDim = this.calculateDimension(stringBounder);
            posMain = (fullDim.getWidth() - mainWidth) / 2.0;
            this.drawLine(ug, firstX, y1, posMain + mainWidth / 2.0, y1);
        }
        this.main.drawU(ug.apply(UTranslate.dx(posMain)));
        this.drawLine(ug, posMain + mainWidth / 2.0, y0, posMain + mainWidth / 2.0, y1);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (ITF child : this.right) {
            XDimension2D childDim = child.calculateDimension(stringBounder);
            height = Math.max(height, childDim.getHeight());
            width += childDim.getWidth();
        }
        XDimension2D mainDim = this.main.calculateDimension(stringBounder);
        height += mainDim.getHeight();
        width = Math.max(width, mainDim.getWidth());
        return new XDimension2D(width, height += 40.0);
    }
}

