/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.authentication.SecurityAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import net.sourceforge.plantuml.security.authentication.SecurityAuthorizeManager;
import net.sourceforge.plantuml.security.authentication.SecurityCredentials;
import net.sourceforge.plantuml.security.authentication.SecurityDefaultNoopAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.SecurityDefaultNoopAuthorizeManager;
import net.sourceforge.plantuml.security.authentication.basicauth.BasicAuthAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.basicauth.BasicAuthAuthorizeManager;
import net.sourceforge.plantuml.security.authentication.oauth.OAuth2AccessInterceptor;
import net.sourceforge.plantuml.security.authentication.oauth.OAuth2ClientAccessAuthorizeManager;
import net.sourceforge.plantuml.security.authentication.oauth.OAuth2ResourceOwnerAccessAuthorizeManager;
import net.sourceforge.plantuml.security.authentication.token.TokenAuthAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.token.TokenAuthAuthorizeManager;
import net.sourceforge.plantuml.utils.Log;

public class SecurityUtils {
    public static final String NO_CREDENTIALS = "<none>";
    public static final String PATHS_CLASSES = "java.class.path";
    public static final String PATHS_INCLUDES = "plantuml.include.path";
    public static final String ALLOWLIST_LOCAL_PATHS = "plantuml.allowlist.path";
    public static final String ALLOWLIST_URL = "plantuml.allowlist.url";
    public static final String PATHS_SECURITY = "plantuml.security.credentials.path";
    public static final String SECURITY_ALLOW_NONSSL_AUTH = "plantuml.security.allowNonSSLAuth";
    private static final SecurityAuthorizeManager PUBLIC_AUTH_MANAGER = new SecurityDefaultNoopAuthorizeManager();
    private static final SecurityAccessInterceptor PUBLIC_ACCESS_INTERCEPTOR = new SecurityDefaultNoopAccessInterceptor();
    private static final SecurityAuthorizeManager TOKEN_AUTH_MANAGER = new TokenAuthAuthorizeManager();
    private static final SecurityAccessInterceptor TOKEN_ACCESS_INTERCEPTOR = new TokenAuthAccessInterceptor();
    private static final SecurityAuthorizeManager BASICAUTH_AUTH_MANAGER = new BasicAuthAuthorizeManager();
    private static final SecurityAccessInterceptor BASICAUTH_ACCESS_INTERCEPTOR = new BasicAuthAccessInterceptor();
    private static final SecurityAuthorizeManager OAUTH2_CLIENT_AUTH_MANAGER = new OAuth2ClientAccessAuthorizeManager();
    private static final SecurityAuthorizeManager OAUTH2_RESOURCEOWNER_AUTH_MANAGER = new OAuth2ResourceOwnerAccessAuthorizeManager();
    private static final SecurityAccessInterceptor OAUTH2_ACCESS_INTERCEPTOR = new OAuth2AccessInterceptor();
    private static final Pattern SECURE_CHARS = Pattern.compile("^[a-zA-Z0-9\\-]+$");
    private static SecurityProfile current = null;

    public static boolean ignoreThisLink(String url) {
        return !SecurityUtils.allowJavascriptInLink() && SecurityUtils.isJavascriptLink(url);
    }

    public static synchronized BufferedImage readRasterImage(ImageIcon imageIcon) {
        Image tmpImage = imageIcon.getImage();
        if (imageIcon.getIconWidth() == -1) {
            return null;
        }
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        image.getGraphics().drawImage(tmpImage, 0, 0, null);
        tmpImage.flush();
        return image;
    }

    public static synchronized SecurityProfile getSecurityProfile() {
        if (current == null) {
            current = SecurityProfile.init();
        }
        return current;
    }

    private static boolean isJavascriptLink(String url) {
        return url.toLowerCase().replaceAll("[^a-z]", "").startsWith("javascript");
    }

    private static boolean allowJavascriptInLink() {
        String env = SecurityUtils.getenv("PLANTUML_ALLOW_JAVASCRIPT_IN_LINK");
        return "true".equalsIgnoreCase(env);
    }

    public static String getenv(String name) {
        String result = System.getProperty(name);
        if (StringUtils.isNotEmpty(result)) {
            return result;
        }
        result = System.getenv(name);
        if (StringUtils.isNotEmpty(result)) {
            return result;
        }
        String alternateName = name.replace(".", "_").toUpperCase();
        return System.getenv(alternateName);
    }

    public static boolean isNonSSLAuthenticationAllowed() {
        return Boolean.parseBoolean(SecurityUtils.getenv(SECURITY_ALLOW_NONSSL_AUTH));
    }

    public static List<SFile> getPath(String prop) {
        ArrayList<SFile> result = new ArrayList<SFile>();
        String paths = SecurityUtils.getenv(prop);
        if (paths == null) {
            return Collections.unmodifiableList(result);
        }
        paths = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(paths);
        StringTokenizer st = new StringTokenizer(paths, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            try {
                SFile f = new SFile(tmp).getCanonicalFile();
                if (!f.isDirectory()) continue;
                result.add(f);
            }
            catch (IOException e) {
                Log.info("Cannot access to " + tmp + ". " + e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean allowSvgText() {
        return true;
    }

    public static PrintWriter createPrintWriter(OutputStream os) {
        return new PrintWriter(os);
    }

    public static PrintWriter createPrintWriter(OutputStream os, boolean append) {
        return new PrintWriter(os, append);
    }

    public static PrintStream createPrintStream(OutputStream os) {
        return new PrintStream(os);
    }

    public static PrintStream createPrintStream(OutputStream os, boolean autoFlush, String charset) throws UnsupportedEncodingException {
        return new PrintStream(os, autoFlush, charset);
    }

    public static PrintStream createPrintStream(OutputStream os, boolean autoFlush, Charset charset) throws UnsupportedEncodingException {
        return new PrintStream(os, autoFlush, charset.name());
    }

    public static FileReader createFileReader(String path) throws FileNotFoundException {
        return new FileReader(path);
    }

    public static PrintWriter createPrintWriter(String path) throws FileNotFoundException {
        return new PrintWriter(path);
    }

    public static FileOutputStream createFileOutputStream(String path) throws FileNotFoundException {
        return new FileOutputStream(path);
    }

    public static SecurityAuthorizeManager getAuthenticationManager(SecurityCredentials credentialConfiguration) {
        if (credentialConfiguration == SecurityCredentials.NONE) {
            return PUBLIC_AUTH_MANAGER;
        }
        if ("tokenauth".equalsIgnoreCase(credentialConfiguration.getType())) {
            return TOKEN_AUTH_MANAGER;
        }
        if ("basicauth".equalsIgnoreCase(credentialConfiguration.getType())) {
            return BASICAUTH_AUTH_MANAGER;
        }
        if ("oauth2".equalsIgnoreCase(credentialConfiguration.getType())) {
            String grantType = credentialConfiguration.getPropertyStr("grantType");
            if ("client_credentials".equalsIgnoreCase(grantType)) {
                return OAUTH2_CLIENT_AUTH_MANAGER;
            }
            if ("password".equalsIgnoreCase(grantType)) {
                return OAUTH2_RESOURCEOWNER_AUTH_MANAGER;
            }
        }
        return PUBLIC_AUTH_MANAGER;
    }

    public static SecurityAccessInterceptor getAccessInterceptor(SecurityAuthentication authentication) {
        if (authentication != null) {
            String type = authentication.getType();
            if ("public".equals(type)) {
                return PUBLIC_ACCESS_INTERCEPTOR;
            }
            if ("tokenauth".equalsIgnoreCase(type)) {
                return TOKEN_ACCESS_INTERCEPTOR;
            }
            if ("basicauth".equalsIgnoreCase(type)) {
                return BASICAUTH_ACCESS_INTERCEPTOR;
            }
            if ("oauth2".equalsIgnoreCase(type)) {
                return OAUTH2_ACCESS_INTERCEPTOR;
            }
        }
        return PUBLIC_ACCESS_INTERCEPTOR;
    }

    public static boolean existsSecurityCredentials(String userToken) {
        SFile securityPath = SecurityUtils.getSecurityPath();
        if (securityPath != null) {
            File securityFilePath = securityPath.conv();
            File userCredentials = new File(securityFilePath, userToken + ".credential");
            return userCredentials.exists() && userCredentials.canRead() && !userCredentials.isDirectory() && userCredentials.length() > 2L;
        }
        return false;
    }

    public static SecurityCredentials loadSecurityCredentials(String userToken) {
        SFile securityPath;
        if (userToken != null && SecurityUtils.checkFileSystemSaveCharactersStrict(userToken) && !NO_CREDENTIALS.equals(userToken) && (securityPath = SecurityUtils.getSecurityPath()) != null) {
            File securityFilePath = securityPath.conv();
            File userCredentials = new File(securityFilePath, userToken + ".credential");
            JsonValue jsonValue = SecurityUtils.loadJson(userCredentials);
            return SecurityCredentials.fromJson(jsonValue);
        }
        return SecurityCredentials.NONE;
    }

    private static boolean checkFileSystemSaveCharactersStrict(String pathNameToken) {
        return StringUtils.isNotEmpty(pathNameToken) && SECURE_CHARS.matcher(pathNameToken).matches() && pathNameToken.length() <= 64;
    }

    public static SFile getSecurityPath() {
        SFile secureSFile;
        File securityFolder;
        List<SFile> paths = SecurityUtils.getPath(PATHS_SECURITY);
        if (!paths.isEmpty() && (securityFolder = (secureSFile = paths.get(0)).conv()).exists() && securityFolder.isDirectory()) {
            return secureSFile;
        }
        return null;
    }

    private static JsonValue loadJson(File jsonFile) {
        if (jsonFile.exists() && jsonFile.canRead() && jsonFile.length() > 2L) {
            JsonValue jsonValue;
            BufferedReader r = new BufferedReader(new FileReader(jsonFile));
            try {
                jsonValue = Json.parse(r);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)r).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logme.error(e);
                }
            }
            ((Reader)r).close();
            return jsonValue;
        }
        return Json.object();
    }
}

