/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.klimt.UBackground;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicNo;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XLine2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.utils.ObjectUtils;

public class CollisionDetector
extends UGraphicNo {
    private final Context context;

    @Override
    public UGraphic apply(UChange change) {
        return new CollisionDetector(this, change);
    }

    private static CollisionDetector create(StringBounder stringBounder) {
        return new CollisionDetector(stringBounder, new UTranslate(), new Context());
    }

    private CollisionDetector(StringBounder stringBounder, UTranslate translate, Context context) {
        super(stringBounder, translate);
        this.context = context;
    }

    private CollisionDetector(CollisionDetector other, UChange change) {
        super(other.getStringBounder(), change instanceof UTranslate ? other.getTranslate().compose((UTranslate)change) : other.getTranslate());
        if (!ObjectUtils.instanceOfAny(change, UBackground.class, HColor.class, UStroke.class, UTranslate.class)) {
            throw new UnsupportedOperationException(change.getClass().toString());
        }
        this.context = other.context;
    }

    private static boolean collisionCheck(MinMax rect, XLine2D hline) {
        if (hline.getY1() != hline.getY2()) {
            throw new IllegalArgumentException();
        }
        if (hline.getY1() < rect.getMinY()) {
            return false;
        }
        if (hline.getY1() > rect.getMaxY()) {
            return false;
        }
        double x1 = Math.min(hline.getX1(), hline.getX2());
        double x2 = Math.max(hline.getX1(), hline.getX2());
        if (x2 < rect.getMinX()) {
            return false;
        }
        return !(x1 > rect.getMaxX());
    }

    public void draw(UShape shape) {
        if (shape instanceof UPolygon) {
            this.drawPolygone((UPolygon)shape);
        } else if (shape instanceof URectangle) {
            this.drawRectangle((URectangle)shape);
        } else if (shape instanceof Snake) {
            this.drawSnake((Snake)shape);
        }
    }

    private void drawSnake(Snake shape) {
        if (this.context.manageSnakes) {
            this.context.snakes.add(shape.translate(this.getTranslate()));
        }
    }

    private void drawRectangle(URectangle shape) {
        this.context.rectangles.add(shape.getMinMax().translate(this.getTranslate()));
    }

    private void drawPolygone(UPolygon shape) {
        this.context.rectangles.add(shape.getMinMax().translate(this.getTranslate()));
    }

    public void drawDebug(UGraphic ug) {
        this.context.drawDebug(ug);
    }

    public final void setManageSnakes(boolean manageSnakes) {
        this.context.manageSnakes = manageSnakes;
    }

    static class Context {
        private final List<MinMax> rectangles = new ArrayList<MinMax>();
        private final List<Snake> snakes = new ArrayList<Snake>();
        private boolean manageSnakes;

        Context() {
        }

        public void drawDebug(UGraphic ug) {
            for (MinMax minmax : this.rectangles) {
                if (!this.collision(minmax)) continue;
                minmax.drawGray(ug);
            }
            HColor color = HColors.BLACK;
            ug = ug.apply(color).apply(new UStroke(5.0));
            for (Snake snake : this.snakes) {
                for (XLine2D line : snake.getHorizontalLines()) {
                    if (!this.collision(line)) continue;
                    this.drawLine(ug, line);
                }
            }
        }

        private void drawLine(UGraphic ug, XLine2D line) {
            ug = ug.apply(new UTranslate(line.getX1(), line.getY1()));
            ug.draw(new ULine(line.getX2() - line.getX1(), line.getY2() - line.getY1()));
        }

        private boolean collision(XLine2D hline) {
            for (MinMax r : this.rectangles) {
                if (!CollisionDetector.collisionCheck(r, hline)) continue;
                return true;
            }
            return false;
        }

        private boolean collision(MinMax r) {
            for (Snake snake : this.snakes) {
                for (XLine2D hline : snake.getHorizontalLines()) {
                    if (!CollisionDetector.collisionCheck(r, hline)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

