/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.SvgAttributes;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleSvgAttributeChange
implements Command {
    public static final String fontPattern = "\\<text[\\s:]+([^>]+)/?\\>";
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<text[\\s:]+([^>]+)/?\\>(.*?)\\</text\\>)");
    private static final Pattern2 patternEol = MyPattern.cmpile("^(\\<text[\\s:]+([^>]+)/?\\>(.*))$");
    private final Pattern2 mypattern;

    @Override
    public String startingChars() {
        return "<";
    }

    public static Command create() {
        return new CommandCreoleSvgAttributeChange(pattern);
    }

    public static Command createEol() {
        return new CommandCreoleSvgAttributeChange(patternEol);
    }

    private CommandCreoleSvgAttributeChange(Pattern2 p) {
        this.mypattern = p;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        FontConfiguration fc1;
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc2 = fc1 = stripe.getActualFontConfiguration();
        if (m.group(2) != null) {
            fc2 = fc2.changeAttributes(new SvgAttributes(m.group(2)));
        }
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

