/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.project.GArrows;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.Direction;

public class GanttArrow
implements UDrawable {
    private final TimeScale timeScale;
    private final Direction atStart;
    private final TaskInstant source;
    private final Direction atEnd;
    private final TaskInstant dest;
    private final HColorSet colorSet;
    private final Style style;
    private final ToTaskDraw toTaskDraw;
    private final StyleBuilder styleBuilder;

    public GanttArrow(HColorSet colorSet, Style style, TimeScale timeScale, TaskInstant source, TaskInstant dest, ToTaskDraw toTaskDraw, StyleBuilder styleBuilder) {
        this.styleBuilder = styleBuilder;
        this.toTaskDraw = toTaskDraw;
        this.style = style;
        this.colorSet = colorSet;
        this.timeScale = timeScale;
        this.source = source;
        this.dest = dest;
        if (source.getAttribute() == TaskAttribute.END && dest.getAttribute() == TaskAttribute.START) {
            this.atStart = source.sameRowAs(dest) ? Direction.LEFT : Direction.DOWN;
            this.atEnd = Direction.RIGHT;
        } else if (source.getAttribute() == TaskAttribute.END && dest.getAttribute() == TaskAttribute.END) {
            this.atStart = Direction.RIGHT;
            this.atEnd = Direction.LEFT;
        } else if (source.getAttribute() == TaskAttribute.START && dest.getAttribute() == TaskAttribute.START) {
            this.atStart = Direction.LEFT;
            this.atEnd = Direction.RIGHT;
        } else if (source.getAttribute() == TaskAttribute.START && dest.getAttribute() == TaskAttribute.END) {
            this.atStart = source.sameRowAs(dest) ? Direction.RIGHT : Direction.DOWN;
            this.atEnd = Direction.LEFT;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private TaskDraw getSource() {
        if (this.source.getMoment() instanceof Task) {
            return this.toTaskDraw.getTaskDraw((Task)this.source.getMoment());
        }
        return null;
    }

    private TaskDraw getDestination() {
        if (this.dest.getMoment() instanceof Task) {
            return this.toTaskDraw.getTaskDraw((Task)this.dest.getMoment());
        }
        return null;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = this.style.applyStrokeAndLineColor(ug, this.colorSet);
        TaskDraw start = this.getSource();
        TaskDraw end = this.getDestination();
        if (start == null || end == null) {
            return;
        }
        double x1 = this.getX(this.source.getAttribute(), start, this.atStart);
        StringBounder stringBounder = ug.getStringBounder();
        double y1 = start.getY(stringBounder, this.atStart);
        double x2 = this.getX(this.dest.getAttribute(), end, this.atEnd.getInv());
        double y2 = end.getY(stringBounder, this.atEnd);
        if (this.atStart == Direction.DOWN && y2 < y1) {
            y1 = start.getY(stringBounder, this.atStart.getInv());
        }
        double minimalWidth = 8.0;
        if (this.atStart == Direction.DOWN && this.atEnd == Direction.RIGHT) {
            if (x2 > x1) {
                if (x2 - x1 < 8.0) {
                    x1 = x2 - 8.0;
                }
                this.drawLine(ug, x1, y1, x1, y2, x2, y2);
            } else {
                x1 = this.getX(this.source.getAttribute(), start, Direction.RIGHT);
                y1 = start.getY(stringBounder, Direction.RIGHT);
                double y1b = end.getY(stringBounder).getCurrentValue();
                this.drawLine(ug, x1, y1, x1 + 6.0, y1, x1 + 6.0, y1b, x2 - 8.0, y1b, x2 - 8.0, y2, x2, y2);
            }
        } else if (this.atStart == Direction.RIGHT && this.atEnd == Direction.LEFT) {
            double xmax = Math.max(x1, x2) + 8.0;
            this.drawLine(ug, x1, y1, xmax, y1, xmax, y2, x2, y2);
        } else if (this.atStart == Direction.LEFT && this.atEnd == Direction.RIGHT) {
            double xmin = Math.min(x1, x2) - 8.0;
            this.drawLine(ug, x1, y1, xmin, y1, xmin, y2, x2, y2);
        } else if (this.atStart == Direction.DOWN && this.atEnd == Direction.LEFT) {
            this.drawLine(ug, x1, y1, x1, y2, x2, y2);
        } else {
            throw new IllegalArgumentException();
        }
        ug = ug.apply(new UStroke(1.5)).apply(this.style.value(PName.LineColor).asColor(this.colorSet).bg());
        GArrows arrows = new GArrows();
        ug.apply(new UTranslate(x2, y2)).draw(arrows.asTo(this.atEnd));
    }

    private void drawLine(UGraphic ug, double ... coord) {
        for (int i = 0; i < coord.length - 2; i += 2) {
            double x1 = coord[i];
            double y1 = coord[i + 1];
            double x2 = coord[i + 2];
            double y2 = coord[i + 3];
            ug.apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
        }
    }

    private StyleSignatureBasic getStyleSignatureTask() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.task);
    }

    private double getX(TaskAttribute taskAttribute, TaskDraw task, Direction direction) {
        if (direction == Direction.LEFT) {
            return task.getX1(taskAttribute) - 1.0;
        }
        if (direction == Direction.RIGHT) {
            return task.getX2(taskAttribute) + 1.0;
        }
        return (task.getX1(taskAttribute) + task.getX2(taskAttribute)) / 2.0;
    }
}

