/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public abstract class TimeHeader {
    private final TimeScale timeScale;
    private final Style closedStyle;
    private final Style timelineStyle;
    private final HColorSet colorSet;
    protected final Day min;
    protected final Day max;

    protected final double Y_POS_ROW16() {
        return 16.0;
    }

    protected final double Y_POS_ROW28() {
        return 28.0;
    }

    public TimeHeader(Style timelineStyle, Style closedStyle, Day min, Day max, TimeScale timeScale, HColorSet colorSet) {
        this.timeScale = timeScale;
        this.min = min;
        this.max = max;
        this.closedStyle = Objects.requireNonNull(closedStyle);
        this.timelineStyle = Objects.requireNonNull(timelineStyle);
        this.colorSet = colorSet;
    }

    protected final HColor closedBackgroundColor() {
        return this.closedStyle.value(PName.BackGroundColor).asColor(this.colorSet);
    }

    protected final HColor closedFontColor() {
        return this.closedStyle.value(PName.FontColor).asColor(this.colorSet);
    }

    protected final HColor openFontColor() {
        return this.timelineStyle.value(PName.FontColor).asColor(this.colorSet);
    }

    protected final HColor getBarColor() {
        return this.timelineStyle.value(PName.LineColor).asColor(this.colorSet);
    }

    public abstract double getTimeHeaderHeight();

    public abstract double getTimeFooterHeight();

    public abstract void drawTimeHeader(UGraphic var1, double var2);

    public abstract void drawTimeFooter(UGraphic var1);

    public abstract double getFullHeaderHeight();

    protected final void drawHline(UGraphic ug, double y) {
        double xmin = this.getTimeScale().getStartingPosition(this.min);
        double xmax = this.getTimeScale().getEndingPosition(this.max);
        ULine hline = ULine.hline(xmax - xmin);
        ug.apply(this.getBarColor()).apply(UTranslate.dy(y)).draw(hline);
    }

    protected final void drawVbar(UGraphic ug, double x, double y1, double y2, boolean bold) {
        ULine vbar = ULine.vline(y2 - y1);
        ug = bold ? this.goBold(ug) : ug.apply(this.getBarColor());
        ug.apply(new UTranslate(x, y1)).draw(vbar);
    }

    protected final FontConfiguration getFontConfiguration(int size, boolean bold, HColor color) {
        UFont font = UFont.serif(size);
        if (bold) {
            font = font.bold();
        }
        return FontConfiguration.create(font, color, color, null);
    }

    public final TimeScale getTimeScale() {
        return this.timeScale;
    }

    protected final TextBlock getTextBlock(String text, int size, boolean bold, HColor color) {
        return Display.getWithNewlines(text).create(this.getFontConfiguration(size, bold, color), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    protected final void printCentered(UGraphic ug, TextBlock text, double start, double end) {
        double width = text.calculateDimension(ug.getStringBounder()).getWidth();
        double available = end - start;
        double diff = Math.max(0.0, available - width);
        text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
    }

    protected final void printCentered(UGraphic ug, boolean hideIfTooBig, double start, double end, TextBlock ... texts) {
        double available = end - start;
        for (int i = texts.length - 1; i >= 0; --i) {
            TextBlock text = texts[i];
            double width = text.calculateDimension(ug.getStringBounder()).getWidth();
            if ((i != 0 || hideIfTooBig) && !(width <= available)) continue;
            double diff = Math.max(0.0, available - width);
            text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
            return;
        }
    }

    protected final void drawRectangle(UGraphic ug, double height, double x1, double x2) {
        if (height == 0.0) {
            return;
        }
        ug = ug.apply(HColors.none());
        ug = ug.apply(new UTranslate(x1, this.getFullHeaderHeight()));
        ug.draw(new URectangle(x2 - x1, height));
    }

    protected final UGraphic goBold(UGraphic ug) {
        return ug.apply(HColors.BLACK).apply(new UStroke(2.0));
    }
}

