/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.AbstractShadowable;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseGroupingElse
extends AbstractTextualComponent {
    private final HColor groupBorder;
    private final HColor backgroundColor;
    private final double roundCorner;
    private final boolean teoz;

    public ComponentRoseGroupingElse(boolean teoz, Style style, CharSequence comment, ISkinSimple spriteContainer) {
        super(style, LineBreakStrategy.NONE, 5, 5, 1, spriteContainer, comment == null ? null : "[" + comment + "]");
        this.teoz = teoz;
        this.roundCorner = style.value(PName.RoundCorner).asInt(false);
        this.groupBorder = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        this.backgroundColor = teoz ? HColors.transparent() : style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        AbstractShadowable rect;
        if (this.backgroundColor.isTransparent()) {
            return;
        }
        XDimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(HColors.none()).apply(this.backgroundColor.bg());
        double width = dimensionToUse.getWidth();
        double height = dimensionToUse.getHeight();
        if (this.roundCorner == 0.0) {
            rect = new URectangle(width, height);
        } else {
            UPath path = new UPath();
            path.moveTo(0.0, 0.0);
            path.lineTo(width, 0.0);
            path.lineTo(width, height - this.roundCorner / 2.0);
            path.arcTo(this.roundCorner / 2.0, this.roundCorner / 2.0, 0.0, 0.0, 1.0, width - this.roundCorner / 2.0, height);
            path.lineTo(this.roundCorner / 2.0, height);
            path.arcTo(this.roundCorner / 2.0, this.roundCorner / 2.0, 0.0, 0.0, 1.0, 0.0, height - this.roundCorner / 2.0);
            path.lineTo(0.0, 0.0);
            rect = path;
        }
        ug.draw(rect);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        ug = ArrowConfiguration.stroke(ug, 2.0, 2.0, 1.0).apply(this.groupBorder);
        ug.apply(UTranslate.dy(1.0)).draw(ULine.hline(dimensionToUse.getWidth()));
        ug = ug.apply(new UStroke());
        if (this.teoz) {
            this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY() + 2)));
        } else {
            this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        if (this.teoz) {
            return this.getTextHeight(stringBounder) + 16.0;
        }
        return this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

