/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UBackground;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.svek.extremity.Extremity;

abstract class ExtremityExtendsLike
extends Extremity {
    private static final double XLEN = -19.0;
    private static final double HALF_WIDTH = 7.0;
    private final UPolygon trig;
    private final UBackground back;
    private final XPoint2D contact;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    private static void addTrigPoint(UPolygon up, double x, double y, double angle, XPoint2D porig) {
        Point p = new Point(x, y);
        p.rotate(angle);
        p.translate(porig);
        p.add(up);
    }

    private ExtremityExtendsLike(XPoint2D porig, double angle, HColor backgroundColor) {
        this.back = backgroundColor.bg();
        this.contact = new XPoint2D(porig.getX(), porig.getY());
        angle = this.manageround(angle);
        this.trig = new UPolygon();
        this.trig.addPoint(porig);
        ExtremityExtendsLike.addTrigPoint(this.trig, -19.0, -7.0, angle, porig);
        ExtremityExtendsLike.addTrigPoint(this.trig, -19.0, 7.0, angle, porig);
        this.trig.addPoint(porig);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(this.back).draw(this.trig);
    }

    private static class Point {
        public double x;
        public double y;

        public void rotate(double theta) {
            double ct = Math.cos(theta);
            double st = -Math.sin(theta);
            double nx = this.x * ct - this.y * st;
            this.y = -this.x * st - this.y * ct;
            this.x = nx;
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public UTranslate getPos(XPoint2D pt) {
            return new UTranslate(this.x + pt.getX(), this.y + pt.getY());
        }

        public void translate(XPoint2D pt) {
            this.x += pt.getX();
            this.y += pt.getY();
        }

        public void add(UPolygon p) {
            p.addPoint(this.x, this.y);
        }
    }

    static class DefinedBy
    extends ExtremityExtendsLike {
        private static final double XSUFFIX = -24.7;
        private static final double DOTHSIZE = 2.0;
        private final UTranslate pos1;
        private final UTranslate pos2;
        private final UEllipse dot;

        private static UTranslate getDotPos(double x, double y, double angle, double size, XPoint2D porig) {
            Point p = new Point(x, y);
            p.rotate(angle);
            p.x -= size;
            p.y -= size;
            return p.getPos(porig);
        }

        public DefinedBy(XPoint2D porig, double angle, HColor backgroundColor) {
            super(porig, angle, backgroundColor);
            double w = 5.0;
            this.pos1 = DefinedBy.getDotPos(-24.7, -w, angle, 2.0, porig);
            this.pos2 = DefinedBy.getDotPos(-24.7, w, angle, 2.0, porig);
            double s = 4.0;
            this.dot = new UEllipse(s, s);
        }

        @Override
        public void drawU(UGraphic ug) {
            super.drawU(ug);
            if (ug.getParam().getColor() != null) {
                ug = ug.apply(ug.getParam().getColor().bg());
            }
            ug.apply(this.pos1).draw(this.dot);
            ug.apply(this.pos2).draw(this.dot);
        }
    }

    static class Redefines
    extends ExtremityExtendsLike {
        private static final double XSUFFIX = -22.8;
        private final UStroke barStroke = new UStroke(2.0);
        private final UTranslate pos;
        private final ULine bar;

        public Redefines(XPoint2D porig, double angle, HColor backgroundColor) {
            super(porig, angle, backgroundColor);
            Point p1 = new Point(-22.8, -7.0);
            Point p2 = new Point(-22.8, 7.0);
            p1.rotate(angle);
            p2.rotate(angle);
            this.bar = new ULine(p2.x - p1.x, p2.y - p1.y);
            this.pos = p1.getPos(porig);
        }

        @Override
        public void drawU(UGraphic ug) {
            super.drawU(ug);
            ug.apply(this.barStroke).apply(this.pos).draw(this.bar);
        }
    }
}

