/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class SingletonClassReturningNewInstanceRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        boolean violation = false;
        String localVarName = null;
        String returnVariableName = null;
        if (node.getResultType().isVoid()) {
            return super.visit(node, data);
        }
        if ("getInstance".equals(node.getName())) {
            List rsl = node.findDescendantsOfType(ASTReturnStatement.class);
            if (rsl.isEmpty()) {
                return super.visit(node, data);
            }
            for (ASTReturnStatement rs : rsl) {
                List pel = rs.findDescendantsOfType(ASTPrimaryExpression.class);
                ASTPrimaryExpression ape = (ASTPrimaryExpression)pel.get(0);
                if (ape.getFirstDescendantOfType(ASTAllocationExpression.class) == null) continue;
                violation = true;
                break;
            }
            List astBlockStatements = node.findDescendantsOfType(ASTBlockStatement.class);
            returnVariableName = this.getReturnVariableName(node);
            if (!astBlockStatements.isEmpty()) {
                for (ASTBlockStatement blockStatement : astBlockStatements) {
                    List lVarList;
                    if (!blockStatement.hasDescendantOfType(ASTLocalVariableDeclaration.class) || (lVarList = blockStatement.findDescendantsOfType(ASTLocalVariableDeclaration.class)).isEmpty()) continue;
                    block2: for (ASTLocalVariableDeclaration localVar : lVarList) {
                        for (ASTVariableDeclaratorId id : localVar) {
                            localVarName = id.getVariableName();
                            if (returnVariableName == null || !returnVariableName.equals(localVarName)) continue;
                            violation = true;
                            continue block2;
                        }
                    }
                }
            }
        }
        if (violation) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }

    private String getReturnVariableName(ASTMethodDeclaration node) {
        List rsl = node.findDescendantsOfType(ASTReturnStatement.class);
        ASTReturnStatement rs = (ASTReturnStatement)rsl.get(0);
        List pel = rs.findDescendantsOfType(ASTPrimaryExpression.class);
        ASTPrimaryExpression ape = (ASTPrimaryExpression)pel.get(0);
        Node lastChild = ape.getChild(0);
        String returnVariableName = null;
        if (lastChild instanceof ASTPrimaryPrefix) {
            returnVariableName = this.getNameFromPrimaryPrefix((ASTPrimaryPrefix)lastChild);
        }
        return returnVariableName;
    }

    private String getNameFromPrimaryPrefix(ASTPrimaryPrefix pp) {
        if (pp.getNumChildren() == 1 && pp.getChild(0) instanceof ASTName) {
            return ((ASTName)pp.getChild(0)).getImage();
        }
        return null;
    }
}

