/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.SharingType;
import apex.jorje.semantic.ast.modifier.SharingTypeCalculator;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class SystemModeEmit
implements Emit {
    private SharingType type;
    private Emit body;
    private boolean emit;
    private boolean setupTestLimits;
    private boolean webServiceInvocation;

    private SystemModeEmit() {
    }

    public static SystemModeEmit emitter() {
        return new SystemModeEmit();
    }

    private Emit getFinallyEmitter(int originalValuePosition) {
        return emitter -> {
            emitter.emitVar(Locations.NONE, 25, originalValuePosition);
            emitter.emit(Locations.NONE, SystemEmitMethods.POP_SYSTEM_MODE_INHERIT);
        };
    }

    @Override
    public void emit(Emitter emitter) {
        assert (this.type != null) : "type not set";
        assert (this.body != null) : "body not set";
        if (this.setupTestLimits) {
            emitter.emit(Locations.NONE, SystemEmitMethods.SETUP_TEST_LIMITS);
        }
        if (this.emit) {
            emitter.push(Locations.NONE, this.type.name());
            AsmMethod pushSystemMode = this.webServiceInvocation ? SystemEmitMethods.PUSH_SYSTEM_MODE_INHERIT_GLOBAL_WEBSERVICE : SystemEmitMethods.PUSH_SYSTEM_MODE_INHERIT;
            emitter.emit(Locations.NONE, pushSystemMode);
            int originalValuePosition = emitter.getMethodStack().peek().getLocalVariables().add();
            emitter.emitVar(Locations.NONE, 58, originalValuePosition);
            emitter.getTryCatchFinallyStack().push(this.getFinallyEmitter(originalValuePosition));
            emitter.getTryCatchFinallyStack().startTryBlock();
        }
        this.body.emit(emitter);
        if (this.emit) {
            emitter.getTryCatchFinallyStack().endBlock();
            emitter.getTryCatchFinallyStack().pop(Emit.NOOP);
        }
    }

    public SystemModeEmit withType(SharingType type) {
        assert (this.type == null) : "type already set";
        this.emit = true;
        this.type = type;
        return this;
    }

    public SystemModeEmit withType(TypeInfo type) {
        assert (this.type == null) : "type already set";
        this.type = SharingTypeCalculator.get().resolve(type);
        this.emit = this.type != SharingType.INHERIT;
        return this;
    }

    public SystemModeEmit withBody(Emit body) {
        assert (this.body == null) : "body already set";
        this.body = body;
        return this;
    }

    public SystemModeEmit withBody(Statement body) {
        return this.withBody(body::emit);
    }

    public SystemModeEmit withSetupTestLimits(boolean setupTestLimits) {
        this.setupTestLimits = setupTestLimits;
        return this;
    }

    public SystemModeEmit withWebServiceInvocation(boolean webServiceInvocation) {
        this.webServiceInvocation = webServiceInvocation;
        return this;
    }
}

