/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.common.base.Result;
import apex.common.base.VoidResult;
import apex.common.collect.MoreCollections;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.MoreMaps;
import java.util.Collection;
import java.util.Map;

public class MultipleFieldTable
implements FieldTable {
    private final Map<String, FieldInfo> fields = MoreMaps.newCaseInsensitiveMap();
    private final Map<String, FieldInfo> staticFields = MoreMaps.newCaseInsensitiveMap();
    private boolean resolved = false;

    @Override
    public Result<Void> add(FieldInfo field) {
        Map<String, FieldInfo> table;
        assert (!this.resolved) : "can't add fields after field table is resolved";
        boolean isStatic = field.getModifiers().has(ModifierTypeInfos.STATIC);
        Map<String, FieldInfo> map = table = isStatic ? this.staticFields : this.fields;
        if (!isStatic && this.staticFields.containsKey(field.getName()) || table.containsKey(field.getName())) {
            return VoidResult.error(I18nSupport.getLabel("duplicate.field", field.getName()));
        }
        table.put(field.getName(), field);
        return VoidResult.of();
    }

    @Override
    public FieldInfo get(SymbolResolver symbols, TypeInfo referencingType, String name, FieldTable.LookupMode mode) {
        assert (this.resolved) : "can't get fields until field table is resolved";
        if (mode.areStaticsFirst()) {
            FieldInfo field = this.staticFields.get(name);
            return field;
        }
        FieldInfo field = this.fields.get(name);
        return field != null ? field : this.staticFields.get(name);
    }

    @Override
    public FieldTable resolve() {
        this.resolved = true;
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public Collection<FieldInfo> all() {
        return MoreCollections.concatCollections(this.fields.values(), this.staticFields.values());
    }
}

