/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXException;

public class IdentityTransformerHandler
extends ReceivingContentHandler
implements TransformerHandler {
    private Result result;
    private String systemId;
    private Controller controller;

    protected IdentityTransformerHandler(Controller controller) {
        this.controller = controller;
        this.setPipelineConfiguration(controller.makePipelineConfiguration());
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String url) {
        this.systemId = url;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void startDocument() throws SAXException {
        if (this.result == null) {
            this.result = new StreamResult(System.out);
        }
        try {
            Properties props = this.controller.getOutputProperties();
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            Configuration config = this.getConfiguration();
            SerializerFactory sf = config.getSerializerFactory();
            Receiver out = sf.getReceiver(this.result, pipe, props);
            this.setPipelineConfiguration(pipe);
            int stripSpace = config.getStripsWhiteSpace();
            if (stripSpace == 2) {
                AllElementStripper s = new AllElementStripper();
                s.setStripAll();
                s.setPipelineConfiguration(pipe);
                s.setUnderlyingReceiver(out);
                out = s;
            }
            this.setReceiver(out);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
        super.startDocument();
    }
}

