/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;

class IndexLocation
implements Location {
    private final int startIndex;
    private final int endIndex;
    private final int line;
    private final int column;

    IndexLocation(int startIndex, int endIndex, int line, int column) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.line = line;
        this.column = column;
    }

    public int hashCode() {
        return ObjectHash.hash(this.line, this.column, this.startIndex, this.endIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return this.startIndex == location.getStartIndex() && this.endIndex == location.getEndIndex() && this.line == location.getLine() && this.column == location.getColumn();
    }

    public String toString() {
        return "(" + this.line + ", " + this.column + ", " + this.startIndex + ", " + this.endIndex + ")";
    }

    @Override
    public Location getLoc() {
        return this;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }
}

