/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.AssignmentOp;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.PolymorphicTypes;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.I18nSupport;

public class AssignmentExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    private final Location loc;
    private final AssignmentOp op;

    public AssignmentExpression(AstNode definingNode, Expr.AssignmentExpr expr) {
        super(definingNode);
        this.left = AstNodes.get().createStore(this, expr.left);
        this.right = AssignmentExpression.createAssignment(this, expr);
        this.loc = Locations.from(expr);
        this.op = expr.op;
    }

    private static Expression createAssignment(AssignmentExpression definingNode, Expr.AssignmentExpr expr) {
        if (expr.op == null) {
            return Expression.INVALID;
        }
        if (expr.op == AssignmentOp.EQUALS) {
            return AstNodes.get().create((AstNode)definingNode, expr.right);
        }
        return new BinaryExpression(definingNode, Locations.from(expr.left), AstNodes.get().create((AstNode)definingNode, expr.left), expr.op.getBinaryOp(), AstNodes.get().create((AstNode)definingNode, expr.right));
    }

    private TypeConversion.Conversion convert(Emitter emitter) {
        return ExpressionUtil.isArrayStoreExpression(this.left) && this.left.getType().getBasicType() != BasicType.SOBJECT ? TypeConversion.Conversion.CAST : TypeConversion.emit(this.loc, emitter, this.right.getType(), this.getType());
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.right.validate(symbols, scope);
        this.left.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.right, this.left)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (PolymorphicTypes.isAssignable(this.getDefiningType(), this.right, this.left.getType())) {
            this.setType(this.left.getType());
        } else {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("illegal.assignment", this.right.getType(), this.left.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.right.emit(emitter);
        if (this.convert(emitter).emitCheckCast()) {
            emitter.emitType(this.loc, 192, TypeEraser.eraseBytecodeName(this.getType()));
        }
        if (!this.isTopLevel()) {
            emitter.emit(this.loc, 89);
        }
        this.left.emit(emitter);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public AssignmentOp getOp() {
        return this.op;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }
}

