/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.common.base.MoreStrings;
import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ArgumentTypeInfoConverter {
    private static final TypeInfoVisitor.Default<TypeInfo> CONVERT = new TypeInfoVisitor.Default<TypeInfo>(){

        @Override
        protected TypeInfo _default(TypeInfo type) {
            return type;
        }

        @Override
        public TypeInfo visit(GenericTypeInfo type) {
            ArrayList<TypeInfo> transformedArgumentTypes = new ArrayList<TypeInfo>();
            for (TypeInfo argumentType : type.getTypeArguments()) {
                transformedArgumentTypes.add(ArgumentTypeInfoConverter.convertType(argumentType));
            }
            return GenericTypeInfoFactory.create((TypeInfo)type, transformedArgumentTypes);
        }

        @Override
        public TypeInfo visit(ArgumentTypeInfo type) {
            return TypeInfos.OBJECT;
        }
    };
    private static final TypeInfoVisitor<Void> CHECK_ARGUMENT_TYPE_INFO = new TypeInfoVisitor.Default<Void>(){

        @Override
        protected Void _default(TypeInfo type) {
            throw new IllegalArgumentException("The placeholder type must only contain " + ArgumentTypeInfo.class.getSimpleName() + " but found a type of class: " + type.getClass().getSimpleName());
        }

        @Override
        public Void visit(ArgumentTypeInfo type) {
            return null;
        }
    };

    public static List<Parameter> convertParameters(List<Parameter> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            builder.add(Parameter.builder().setDefiningType(parameter.getDefiningType()).setType(ArgumentTypeInfoConverter.convertType(parameter.getType())).setName(parameter.getName()).setModifiers(parameter.getModifierInfo()).build());
        }
        return builder.build();
    }

    public static List<Parameter> convertParameters(Map<Equivalence.Wrapper<TypeInfo>, TypeInfo> oldTypeToNewType, List<Parameter> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            builder.add(Parameter.builder().setDefiningType(parameter.getDefiningType()).setType(ArgumentTypeInfoConverter.convertType(oldTypeToNewType, parameter.getType())).setName(parameter.getName()).setModifiers(parameter.getModifierInfo()).build());
        }
        return builder.build();
    }

    public static TypeInfo convertType(Map<Equivalence.Wrapper<TypeInfo>, TypeInfo> oldTypeToNewType, TypeInfo rootUnReifiedType) {
        return ArgumentTypeInfoConverter.convertTypeWithPeelingIfNecessary(oldTypeToNewType, rootUnReifiedType, Optional.empty());
    }

    public static TypeInfo convertTypeWithPeelingIfNecessary(final Map<Equivalence.Wrapper<TypeInfo>, TypeInfo> oldTypeToNewType, TypeInfo rootUnReifiedType, final Optional<TypeInfo> targetType) {
        return rootUnReifiedType.accept(new TypeInfoVisitor.Default<TypeInfo>(){

            private boolean isQueryResultRootOrTargetType(GenericTypeInfo rootUnreifiedType, Optional<TypeInfo> targetType2) {
                boolean isTargetTypeQueryResultList = targetType2.map(x -> GenericTypeInfoUtil.asGenericType(x).isQueryResultList()).orElse(false);
                return (rootUnreifiedType.isQueryResultList() || isTargetTypeQueryResultList) && CollectionTypeInfoUtil.isList(rootUnreifiedType) && !TypeInfoEquivalence.isEquivalent(rootUnreifiedType, WrapperTypeInfos.SYSTEM_LIST_ITERATOR);
            }

            @Override
            protected TypeInfo _default(TypeInfo type) {
                return type;
            }

            @Override
            public TypeInfo visit(GenericTypeInfo type) {
                if (this.isQueryResultRootOrTargetType(type, targetType)) {
                    return GenericTypeInfoFactory.createQueryResultList(ArgumentTypeInfoConverter.convertType(oldTypeToNewType, MoreIterables.getOnlyElement(type.getTypeArguments())));
                }
                ArrayList<TypeInfo> transformedArgumentTypes = new ArrayList<TypeInfo>(type.getTypeArguments().size());
                for (TypeInfo argumentType : type.getTypeArguments()) {
                    transformedArgumentTypes.add(ArgumentTypeInfoConverter.convertType(oldTypeToNewType, argumentType));
                }
                return GenericTypeInfoFactory.create((TypeInfo)type, transformedArgumentTypes);
            }

            @Override
            public TypeInfo visit(ArgumentTypeInfo type) {
                if (oldTypeToNewType.containsKey(type.getEquivalenceWrapper())) {
                    return (TypeInfo)oldTypeToNewType.get(type.getEquivalenceWrapper());
                }
                throw new IllegalArgumentException("Could not convert type " + type + ". No Mapping found. Known types are: " + TypeInfoEquivalence.unwrapAll(oldTypeToNewType.keySet()).stream().map(TypeInfo.TO_APEX_NAME).collect(MoreStrings.ON_COMMA_AND_SPACE_ENCLOSING_CURLY_BRACES));
            }
        });
    }

    public static TypeInfo convertType(TypeInfo type) {
        return type.accept(CONVERT);
    }

    public static Map<Equivalence.Wrapper<TypeInfo>, TypeInfo> getResolutionMap(GenericTypeInfo targetType, TypeInfo rootUnreifiedType) {
        ImmutableMap.Builder<Equivalence.Wrapper<TypeInfo>, TypeInfo> builder = ImmutableMap.builder();
        HashSet<Equivalence.Wrapper<TypeInfo>> duplicates = new HashSet<Equivalence.Wrapper<TypeInfo>>();
        for (Pair<TypeInfo, TypeInfo> pair : EqualPairIterator.iterable(rootUnreifiedType.getTypeArguments(), targetType.getTypeArguments())) {
            TypeInfo argumentType = pair.getLeft();
            argumentType.accept(CHECK_ARGUMENT_TYPE_INFO);
            Equivalence.Wrapper<TypeInfo> wrapperType = argumentType.getEquivalenceWrapper();
            if (!duplicates.add(wrapperType)) continue;
            builder.put(wrapperType, pair.getRight());
        }
        return builder.build();
    }
}

