/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.internal.util.AssertionUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import org.apache.commons.lang3.StringUtils;

public class LanguageVersionDiscoverer {
    private Map<Language, LanguageVersion> languageToLanguageVersion = new HashMap<Language, LanguageVersion>();
    private LanguageVersion forcedVersion;

    public LanguageVersionDiscoverer() {
        this(null);
    }

    public LanguageVersionDiscoverer(LanguageVersion forcedVersion) {
        this.forcedVersion = forcedVersion;
    }

    public LanguageVersion setDefaultLanguageVersion(LanguageVersion languageVersion) {
        AssertionUtil.requireParamNotNull("languageVersion", languageVersion);
        LanguageVersion currentLanguageVersion = this.languageToLanguageVersion.put(languageVersion.getLanguage(), languageVersion);
        if (currentLanguageVersion == null) {
            currentLanguageVersion = languageVersion.getLanguage().getDefaultVersion();
        }
        return currentLanguageVersion;
    }

    public LanguageVersion getDefaultLanguageVersion(Language language) {
        Objects.requireNonNull(language);
        LanguageVersion languageVersion = this.languageToLanguageVersion.get(language);
        if (languageVersion == null) {
            languageVersion = language.getDefaultVersion();
        }
        return languageVersion;
    }

    public LanguageVersion getDefaultLanguageVersionForFile(File sourceFile) {
        return this.getDefaultLanguageVersionForFile(sourceFile.getName());
    }

    public LanguageVersion getDefaultLanguageVersionForFile(String fileName) {
        List<Language> languages = this.getLanguagesForFile(fileName);
        LanguageVersion languageVersion = null;
        if (!languages.isEmpty()) {
            languageVersion = this.getDefaultLanguageVersion(languages.get(0));
        }
        return languageVersion;
    }

    public LanguageVersion getForcedVersion() {
        return this.forcedVersion;
    }

    public void setForcedVersion(LanguageVersion forceLanguageVersion) {
        this.forcedVersion = forceLanguageVersion;
    }

    public List<Language> getLanguagesForFile(File sourceFile) {
        return this.getLanguagesForFile(sourceFile.getName());
    }

    public List<Language> getLanguagesForFile(String fileName) {
        String extension = this.getExtension(fileName);
        return LanguageRegistry.findByExtension(extension);
    }

    private String getExtension(String fileName) {
        return StringUtils.substringAfterLast((String)fileName, (String)".");
    }
}

