/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.constraints;

import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.properties.constraints.PropertyConstraint;
import org.apache.commons.lang3.StringUtils;

@Experimental
final class ConstraintFactory {
    private ConstraintFactory() {
    }

    @Experimental
    public static <U> PropertyConstraint<U> fromPredicate(final Predicate<? super U> pred, final String constraintDescription) {
        return new PropertyConstraint<U>(){

            @Override
            public boolean test(U value) {
                return pred.test(value);
            }

            @Override
            public String validate(U value) {
                return pred.test(value) ? null : "Constraint violated on property value '" + value + "' (" + constraintDescription + ")";
            }

            @Override
            public String getConstraintDescription() {
                return StringUtils.capitalize((String)constraintDescription);
            }

            @Override
            public PropertyConstraint<Iterable<? extends U>> toCollectionConstraint() {
                final 1 thisValidator = this;
                return ConstraintFactory.fromPredicate(new Predicate<Iterable<? extends U>>(){

                    @Override
                    public boolean test(Iterable<? extends U> us) {
                        for (Object u : us) {
                            if (thisValidator.test(u)) continue;
                            return false;
                        }
                        return true;
                    }
                }, "Components " + StringUtils.uncapitalize((String)thisValidator.getConstraintDescription()));
            }
        };
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

