/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;

public class RuleSet {
    private List rules = new ArrayList();
    private String name = "";
    private String description = "";
    private Language language;

    public int size() {
        return this.rules.size();
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new RuntimeException("Null Rule reference added to a RuleSet; that's a bug somewhere in PMD");
        }
        this.rules.add(rule);
    }

    public Collection getRules() {
        return this.rules;
    }

    public boolean usesDFA() {
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (!r.usesDFA()) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        Rule rule = null;
        Iterator i = this.rules.iterator();
        while (i.hasNext() && rule == null) {
            Rule r = (Rule)i.next();
            if (!r.getName().equals(ruleName)) continue;
            rule = r;
        }
        return rule;
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.rules.addAll(this.rules.size(), ruleSet.getRules());
    }

    public void apply(List acuList, RuleContext ctx) {
        Iterator rs = this.rules.iterator();
        while (rs.hasNext()) {
            Rule rule = (Rule)rs.next();
            rule.apply(acuList, ctx);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RuleSet)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RuleSet ruleSet = (RuleSet)o;
        return this.getName().equals(ruleSet.getName()) && ((Object)this.getRules()).equals(ruleSet.getRules());
    }

    public int hashCode() {
        return this.getName().hashCode() + 13 * ((Object)this.getRules()).hashCode();
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean usesTypeResolution() {
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (!r.usesTypeResolution()) continue;
            return true;
        }
        return false;
    }
}

