/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Map;
import net.sourceforge.pmd.properties.AbstractPMDProperty;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;

public class EnumeratedProperty
extends AbstractPMDProperty {
    private Object[][] choiceTuples;
    private Map choicesByLabel;
    private Map labelsByChoice;

    public EnumeratedProperty(String theName, String theDescription, Object[][] theChoices, float theUIOrder) {
        this(theName, theDescription, theChoices, theUIOrder, 1);
    }

    public EnumeratedProperty(String theName, String theDescription, Object[][] theChoices, float theUIOrder, int maxValues) {
        super(theName, theDescription, theChoices[0][1], theUIOrder);
        this.choiceTuples = theChoices;
        this.choicesByLabel = CollectionUtil.mapFrom(theChoices);
        this.labelsByChoice = CollectionUtil.invertedMapFrom(this.choicesByLabel);
        this.maxValueCount(maxValues);
    }

    public Class type() {
        return Object.class;
    }

    public Object[][] choices() {
        return this.choiceTuples;
    }

    private String nonLegalValueMsgFor(Object value) {
        return "" + value + " is not a legal value";
    }

    public String errorFor(Object value) {
        if (this.maxValueCount() == 1) {
            return this.labelsByChoice.containsKey(value) ? null : this.nonLegalValueMsgFor(value);
        }
        Object[] values = (Object[])value;
        for (int i = 0; i < values.length; ++i) {
            if (this.labelsByChoice.containsKey(values[i])) continue;
            return this.nonLegalValueMsgFor(values[i]);
        }
        return null;
    }

    private Object choiceFrom(String label) {
        Object result = this.choicesByLabel.get(label);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(label);
    }

    public Object valueFrom(String value) throws IllegalArgumentException {
        if (this.maxValueCount() == 1) {
            return this.choiceFrom(value);
        }
        String[] strValues = StringUtil.substringsOf(value, this.multiValueDelimiter);
        Object[] values = new Object[strValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.choiceFrom(strValues[i]);
        }
        return values;
    }

    public String asDelimitedString(Object value) {
        if (this.maxValueCount() == 1) {
            return (String)this.labelsByChoice.get(value);
        }
        Object[] choices = (Object[])value;
        StringBuffer sb = new StringBuffer();
        sb.append(this.labelsByChoice.get(choices[0]));
        for (int i = 1; i < choices.length; ++i) {
            sb.append(this.multiValueDelimiter);
            sb.append(this.labelsByChoice.get(choices[i]));
        }
        return sb.toString();
    }
}

