/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.pathfinder.CurrentPath;
import net.sourceforge.pmd.dfa.pathfinder.DAAPathFinder;
import net.sourceforge.pmd.dfa.pathfinder.Executable;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;

public class UselessAssignment
extends AbstractRule
implements Executable {
    private RuleContext rc;

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.rc = (RuleContext)data;
        DAAPathFinder a = new DAAPathFinder((IDataFlowNode)node.getDataFlowNode().getFlow().get(0), this);
        a.run();
        return data;
    }

    public void execute(CurrentPath path) {
        HashMap<String, Usage> hash = new HashMap<String, Usage>();
        Iterator i = path.iterator();
        while (i.hasNext()) {
            IDataFlowNode inode = (IDataFlowNode)i.next();
            if (inode.getVariableAccess() == null) continue;
            for (int j = 0; j < inode.getVariableAccess().size(); ++j) {
                Usage u;
                VariableAccess va = (VariableAccess)inode.getVariableAccess().get(j);
                Object o = hash.get(va.getVariableName());
                if (o != null) {
                    u = (Usage)o;
                    if (va.isDefinition() && va.accessTypeMatches(u.accessType)) {
                        this.addViolation((Object)this.rc, u.node.getSimpleNode(), va.getVariableName());
                    }
                }
                u = new Usage(va.getAccessType(), inode);
                hash.put(va.getVariableName(), u);
            }
        }
    }

    private static class Usage {
        public int accessType;
        public IDataFlowNode node;

        public Usage(int accessType, IDataFlowNode node) {
            this.accessType = accessType;
            this.node = node;
        }

        public String toString() {
            return "accessType = " + this.accessType + ", line = " + this.node.getLine();
        }
    }
}

