/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.schematron.reader;

import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.State;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.schematron.reader.SElementState;
import com.sun.msv.schematron.reader.SGrammarState;
import com.sun.msv.schematron.reader.SRootMergedGrammarState;
import com.sun.msv.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class SRELAXNGReader
extends RELAXNGReader {
    public static final String SchematronURI = "http://www.ascc.net/xml/schematron";
    public static final String RNG_PLUS_SCHEMATRON_URI = "http://relaxng.org/ns/structure/1.0+http://www.ascc.net/xml/schematron";
    final NamespaceSupport schematronNs = new NamespaceSupport();
    public static final String ERR_INVALID_XPATH = "SRELAXNGReader.InvalidXPath";

    public static TREXGrammar parse(String grammarURL, SAXParserFactory factory, GrammarReaderController controller) {
        SRELAXNGReader reader = new SRELAXNGReader(controller, factory);
        reader.parse(grammarURL);
        return reader.getResult();
    }

    public static TREXGrammar parse(InputSource grammar, SAXParserFactory factory, GrammarReaderController controller) {
        SRELAXNGReader reader = new SRELAXNGReader(controller, factory);
        reader.parse(grammar);
        return reader.getResult();
    }

    public SRELAXNGReader(GrammarReaderController controller, SAXParserFactory parserFactory) {
        this(controller, parserFactory, new ExpressionPool());
    }

    public SRELAXNGReader(GrammarReaderController controller, SAXParserFactory parserFactory, ExpressionPool pool) {
        super(controller, parserFactory, new SStateFactory(), pool);
    }

    protected boolean isGrammarElement(StartTagInfo tag) {
        if (tag.namespaceURI.equals(SchematronURI)) {
            return !tag.localName.equals("ns");
        }
        return super.isGrammarElement(tag);
    }

    public void startElement(String nsUri, String localName, String qname, Attributes atts) throws SAXException {
        if (nsUri.equals(SchematronURI) && localName.equals("ns")) {
            String prefix = atts.getValue("prefix");
            String uri = atts.getValue("uri");
            if (prefix == null) {
                this.reportError("GrammarReader.MissingAttribute", (Object)"prefix", (Object)"ns");
            } else if (uri == null) {
                this.reportError("GrammarReader.MissingAttribute", (Object)"uri", (Object)"ns");
            } else {
                this.schematronNs.declarePrefix(prefix, uri);
            }
        } else {
            this.schematronNs.pushContext();
        }
        super.startElement(nsUri, localName, qname, atts);
    }

    public void endElement(String nsUri, String localName, String qname) throws SAXException {
        super.endElement(nsUri, localName, qname);
        if (!nsUri.equals(SchematronURI) || !localName.equals("ns")) {
            this.schematronNs.popContext();
        }
    }

    protected String localizeMessage(String propertyName, Object[] args) {
        String format;
        try {
            format = ResourceBundle.getBundle("com.sun.msv.schematron.reader.Messages").getString(propertyName);
        }
        catch (Exception e) {
            return super.localizeMessage(propertyName, args);
        }
        return MessageFormat.format(format, args);
    }

    private static class SStateFactory
    extends RELAXNGReader.StateFactory {
        private SStateFactory() {
        }

        public State element(State parent, StartTagInfo tag) {
            return new SElementState();
        }

        public State grammar(State parent, StartTagInfo tag) {
            return new SGrammarState();
        }

        public State includedGrammar() {
            return new SRootMergedGrammarState();
        }
    }
}

