/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.schematron.verifier;

import com.sun.msv.schematron.grammar.SAction;
import com.sun.msv.schematron.grammar.SActions;
import com.sun.msv.schematron.grammar.SElementExp;
import com.sun.msv.schematron.grammar.SRule;
import com.sun.msv.schematron.util.DOMBuilder;
import com.sun.msv.schematron.verifier.Loc;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.IVerifier;
import com.sun.msv.verifier.ValidityViolation;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.VerifierFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.crimson.tree.ElementNode2;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPathContext;
import org.relaxng.datatype.Datatype;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class RelmesVerifier
implements IVerifier {
    private final VerifierFilter core;
    private boolean schematronValid;

    public RelmesVerifier(IVerifier core) throws ParserConfigurationException {
        this.core = new VerifierFilter(core);
        this.core.setContentHandler(new SchematronVerifier());
    }

    public RelmesVerifier(DocumentDeclaration docDecl, ErrorHandler handler) throws ParserConfigurationException {
        this(new Verifier(docDecl, handler));
    }

    public void setPanicMode(boolean v) {
        this.core.setPanicMode(v);
    }

    public boolean isValid() {
        return this.schematronValid && this.core.isValid();
    }

    public Object getCurrentElementType() {
        return this.core.getCurrentElementType();
    }

    public Datatype[] getLastCharacterType() {
        return this.core.getLastCharacterType();
    }

    public final Locator getLocator() {
        return this.core.getLocator();
    }

    public final ErrorHandler getErrorHandler() {
        return this.core.getErrorHandler();
    }

    public final void setErrorHandler(ErrorHandler handler) {
        this.core.setErrorHandler(handler);
    }

    public void setDocumentLocator(Locator locator) {
        this.core.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.core.startDocument();
    }

    public void endDocument() throws SAXException {
        this.core.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.core.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.core.endPrefixMapping(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.core.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.core.endElement(namespaceURI, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.core.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.core.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.core.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.core.skippedEntity(name);
    }

    class SchematronVerifier
    extends DOMBuilder {
        private final Map idMap = new HashMap();
        XPathContext xctxt = new XPathContext();
        private final Map locationMap = new HashMap();
        private final Map checks = new HashMap();
        private final Stack effectiveRules = new Stack();

        SchematronVerifier() throws ParserConfigurationException {
        }

        public void startElement(String ns, String local, String qname, Attributes atts) throws SAXException {
            super.startElement(ns, local, qname, atts);
            this.locationMap.put(this.parent, new Loc(RelmesVerifier.this.getLocator()));
            Object o = RelmesVerifier.this.getCurrentElementType();
            if (o instanceof SElementExp) {
                this.checks.put(this.parent, o);
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!"ID".equals(atts.getType(i))) continue;
                try {
                    ((CoreDocumentImpl)this.dom).putIdentifier(atts.getValue(i), (Element)this.parent);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    ((ElementNode2)this.parent).setIdAttributeName(atts.getQName(i));
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.checks.clear();
            this.locationMap.clear();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            RelmesVerifier.this.schematronValid = true;
            try {
                this.testNode(this.dom);
            }
            catch (TransformerException e) {
                RelmesVerifier.this.getErrorHandler().error(new ValidityViolation(null, "XPath error:" + e.getMessage(), null));
                RelmesVerifier.this.schematronValid = false;
            }
        }

        private void testNode(Node node) throws SAXException, TransformerException {
            SElementExp exp = (SElementExp)this.checks.get(node);
            int numRulesAdded = 0;
            if (exp != null) {
                for (int i = 0; i < exp.rules.length; ++i) {
                    if (this.effectiveRules.contains(exp.rules)) continue;
                    this.effectiveRules.push(exp.rules[i]);
                    ++numRulesAdded;
                }
                this.testActions(exp.actions, node);
            }
            int len = this.effectiveRules.size();
            for (int i = 0; i < len; ++i) {
                this.testRule((SRule)this.effectiveRules.get(i), node);
            }
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                NamedNodeMap atts = e.getAttributes();
                len = atts.getLength();
                for (int i = 0; i < len; ++i) {
                    this.testNode(atts.item(i));
                }
            }
            NodeList children = node.getChildNodes();
            len = children.getLength();
            for (int i = 0; i < len; ++i) {
                this.testNode(children.item(i));
            }
            while (numRulesAdded > 0) {
                this.effectiveRules.pop();
                --numRulesAdded;
            }
        }

        private void testRule(SRule rule, Node node) throws SAXException, TransformerException {
            if (!rule.matches(this.xctxt, node)) {
                return;
            }
            this.testActions(rule, node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testActions(SActions actions, Node node) throws SAXException, TransformerException {
            PrefixResolverDefault resolver = new PrefixResolverDefault(node);
            SActions sActions = actions;
            synchronized (sActions) {
                int i;
                for (i = 0; i < actions.asserts.length; ++i) {
                    if (actions.asserts[i].xpath.execute(this.xctxt, node, (PrefixResolver)resolver).bool()) continue;
                    this.reportError(node, actions.asserts[i]);
                }
                for (i = 0; i < actions.reports.length; ++i) {
                    if (!actions.reports[i].xpath.execute(this.xctxt, node, (PrefixResolver)resolver).bool()) continue;
                    this.reportError(node, actions.reports[i]);
                }
            }
        }

        private void reportError(Node node, SAction action) throws SAXException {
            Loc loc = (Loc)this.locationMap.get(node);
            if (loc == null) {
                if (node instanceof Attr) {
                    this.reportError(((Attr)node).getOwnerElement(), action);
                    return;
                }
                if (node.getParentNode() != null) {
                    this.reportError(node.getParentNode(), action);
                    return;
                }
            }
            LocatorImpl src = new LocatorImpl();
            if (loc != null) {
                src.setLineNumber(loc.line);
                src.setColumnNumber(loc.col);
            }
            src.setSystemId(RelmesVerifier.this.getLocator().getSystemId());
            src.setPublicId(RelmesVerifier.this.getLocator().getPublicId());
            RelmesVerifier.this.schematronValid = false;
            RelmesVerifier.this.getErrorHandler().error(new ValidityViolation(src, action.document, null));
        }
    }
}

