/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;

public class TypeHierarchy
implements Serializable {
    private Map<ItemTypePair, Integer> map;
    protected Configuration config;
    public static final int SAME_TYPE = 0;
    public static final int SUBSUMES = 1;
    public static final int SUBSUMED_BY = 2;
    public static final int OVERLAPS = 3;
    public static final int DISJOINT = 4;

    public TypeHierarchy(Configuration config) {
        this.config = config;
        this.map = new ConcurrentHashMap<ItemTypePair, Integer>();
    }

    public Sequence applyFunctionConversionRules(Sequence value, SequenceType requiredType, RoleLocator role, SourceLocator locator) throws XPathException {
        ItemType suppliedItemType = SequenceTool.getItemType(value, this);
        SequenceIterator iterator = value.iterate();
        final ItemType requiredItemType = requiredType.getPrimaryType();
        if (iterator instanceof EmptyIterator) {
            return EmptySequence.getInstance();
        }
        if (requiredItemType.isPlainType()) {
            if (!suppliedItemType.isPlainType()) {
                iterator = Atomizer.getAtomizingIterator(iterator, false);
                suppliedItemType = suppliedItemType.getAtomizedItemType();
            }
            if (this.relationship(suppliedItemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
                ItemMappingFunction converter;
                boolean nsSensitive = ((SimpleType)((Object)requiredItemType)).isNamespaceSensitive();
                if (nsSensitive) {
                    converter = new ItemMappingFunction(){

                        public Item mapItem(Item item) throws XPathException {
                            if (item instanceof UntypedAtomicValue) {
                                ValidationFailure vf = new ValidationFailure("Implicit conversion of untypedAtomic value to " + requiredItemType.toString() + " is not allowed");
                                vf.setErrorCode("XPTY0117");
                                throw vf.makeException();
                            }
                            return item;
                        }
                    };
                } else if (((SimpleType)((Object)requiredItemType)).isUnionType()) {
                    final ConversionRules rules = this.config.getConversionRules();
                    converter = new ItemMappingFunction(){

                        public Item mapItem(Item item) throws XPathException {
                            if (item instanceof UntypedAtomicValue) {
                                try {
                                    return ((SimpleType)((Object)requiredItemType)).getTypedValue(item.getStringValueCS(), null, rules).head();
                                }
                                catch (ValidationException ve) {
                                    ve.setErrorCode("XPTY0004");
                                    throw ve;
                                }
                            }
                            return item;
                        }
                    };
                } else {
                    converter = new ItemMappingFunction(){

                        public Item mapItem(Item item) throws XPathException {
                            if (item instanceof UntypedAtomicValue) {
                                AtomicValue val = Converter.convert((UntypedAtomicValue)item, (AtomicType)requiredItemType, TypeHierarchy.this.config.getConversionRules());
                                if (val instanceof ValidationFailure) {
                                    ValidationFailure vex = (ValidationFailure)((Object)val);
                                    throw vex.makeException();
                                }
                                return val;
                            }
                            return item;
                        }
                    };
                }
                iterator = new ItemMappingIterator(iterator, converter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.DOUBLE)) {
                ItemMappingFunction<AtomicValue, DoubleValue> promoter = new ItemMappingFunction<AtomicValue, DoubleValue>(){

                    @Override
                    public DoubleValue mapItem(AtomicValue item) throws XPathException {
                        if (item instanceof NumericValue) {
                            return (DoubleValue)Converter.convert(item, BuiltInAtomicType.DOUBLE, TypeHierarchy.this.config.getConversionRules()).asAtomic();
                        }
                        throw new XPathException("Cannot promote non-numeric value to xs:double", "XPTY0004");
                    }
                };
                iterator = new ItemMappingIterator<AtomicValue, DoubleValue>(iterator, promoter, true);
            } else if (requiredItemType.equals(BuiltInAtomicType.FLOAT)) {
                ItemMappingFunction<AtomicValue, FloatValue> promoter = new ItemMappingFunction<AtomicValue, FloatValue>(){

                    @Override
                    public FloatValue mapItem(AtomicValue item) throws XPathException {
                        if (item instanceof DoubleValue) {
                            throw new XPathException("Cannot promote xs:double value to xs:float", "XPTY0004");
                        }
                        if (item instanceof NumericValue) {
                            return (FloatValue)Converter.convert(item, BuiltInAtomicType.FLOAT, TypeHierarchy.this.config.getConversionRules()).asAtomic();
                        }
                        throw new XPathException("Cannot promote non-numeric value to xs:float", "XPTY0004");
                    }
                };
                iterator = new ItemMappingIterator<AtomicValue, FloatValue>(iterator, promoter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.STRING) && this.relationship(suppliedItemType, BuiltInAtomicType.ANY_URI) != 4) {
                ItemMappingFunction promoter = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof AnyURIValue) {
                            return new StringValue(item.getStringValueCS());
                        }
                        return item;
                    }
                };
                iterator = new ItemMappingIterator(iterator, promoter, true);
            }
        }
        iterator = this.applyFunctionCoercion(iterator, suppliedItemType, requiredItemType, role, locator);
        int relation = this.relationship(suppliedItemType, requiredItemType);
        if (relation != 0 && relation != 2) {
            ItemTypeCheckingFunction itemChecker = new ItemTypeCheckingFunction(requiredItemType, role, locator, this.config);
            iterator = new ItemMappingIterator(iterator, itemChecker, true);
        }
        if (requiredType.getCardinality() != 57344) {
            iterator = new CardinalityCheckingIterator(iterator, requiredType.getCardinality(), role, locator);
        }
        return SequenceTool.toLazySequence(iterator);
    }

    protected SequenceIterator applyFunctionCoercion(SequenceIterator iterator, ItemType suppliedItemType, ItemType requiredItemType, RoleLocator role, SourceLocator locator) {
        return iterator;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isSubType(ItemType subtype, ItemType supertype) {
        int relation = this.relationship(subtype, supertype);
        return relation == 0 || relation == 2;
    }

    public int relationship(ItemType t1, ItemType t2) {
        if (t1 == null) {
            throw new NullPointerException();
        }
        if (t1.equals(t2)) {
            return 0;
        }
        ItemTypePair pair = new ItemTypePair(t1, t2);
        Integer result = this.map.get(pair);
        if (result == null) {
            result = this.computeRelationship(t1, t2);
            this.map.put(pair, result);
        }
        return result;
    }

    private int computeRelationship(ItemType t1, ItemType t2) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 instanceof AnyItemType) {
            if (t2 instanceof AnyItemType) {
                return 0;
            }
            return 1;
        }
        if (t2 instanceof AnyItemType) {
            return 2;
        }
        if (t1 == ErrorType.getInstance()) {
            return 2;
        }
        if (t2 == ErrorType.getInstance()) {
            return 1;
        }
        if (t1.isPlainType()) {
            if (t2 instanceof NodeTest || t2 instanceof FunctionItemType || t2 instanceof ExternalObjectType) {
                return 4;
            }
            if (t2 instanceof ExternalObjectType) {
                if (((AtomicType)t1).getFingerprint() == 632) {
                    return 1;
                }
                return 4;
            }
            if (t1 == BuiltInAtomicType.ANY_ATOMIC && t2.isPlainType()) {
                return 1;
            }
            if (t2 == BuiltInAtomicType.ANY_ATOMIC) {
                return 2;
            }
            if (t1 instanceof AtomicType && t2 instanceof AtomicType) {
                if (((AtomicType)t1).getFingerprint() == ((AtomicType)t2).getFingerprint()) {
                    return 0;
                }
                ItemType t = t2;
                while (t.isPlainType()) {
                    if (((AtomicType)t1).getFingerprint() == ((AtomicType)t).getFingerprint()) {
                        return 1;
                    }
                    t = t.getSuperType(this);
                }
                t = t1;
                while (t.isPlainType()) {
                    if (((AtomicType)t).getFingerprint() == ((AtomicType)t2).getFingerprint()) {
                        return 2;
                    }
                    t = t.getSuperType(this);
                }
                return 4;
            }
            if (!t1.isAtomicType() && t2 instanceof PlainType) {
                int rel;
                boolean foundSupertype;
                Set<PlainType> s1 = ((PlainType)t1).getPlainMemberTypes();
                Set<PlainType> s2 = ((PlainType)t2).getPlainMemberTypes();
                boolean gt = s1.containsAll(s2);
                boolean lt = s2.containsAll(s1);
                if (gt && lt) {
                    return 0;
                }
                if (gt) {
                    return 1;
                }
                if (lt) {
                    return 2;
                }
                boolean allSubsumed = true;
                boolean foundOverlap = false;
                for (PlainType a1 : s1) {
                    foundSupertype = false;
                    for (PlainType a2 : s2) {
                        rel = this.relationship(a1, a2);
                        if (rel == 2 || rel == 0) {
                            foundSupertype = true;
                            break;
                        }
                        if (rel != 1 && rel != 3) continue;
                        foundOverlap = true;
                    }
                    if (foundSupertype) continue;
                    allSubsumed = false;
                    break;
                }
                if (allSubsumed) {
                    return 2;
                }
                allSubsumed = true;
                for (PlainType a2 : s2) {
                    foundSupertype = false;
                    for (PlainType a1 : s1) {
                        rel = this.relationship(a1, a2);
                        if (rel == 1 || rel == 0) {
                            foundSupertype = true;
                            break;
                        }
                        if (rel != 2 && rel != 3) continue;
                        foundOverlap = true;
                    }
                    if (foundSupertype) continue;
                    allSubsumed = false;
                    break;
                }
                if (allSubsumed) {
                    return 1;
                }
                if (foundOverlap) {
                    return 3;
                }
                return 4;
            }
            if (t1 instanceof AtomicType) {
                int r = this.relationship(t2, t1);
                return TypeHierarchy.inverseRelationship(r);
            }
            throw new IllegalStateException();
        }
        if (t1 instanceof NodeTest) {
            int m2;
            if (t2.isPlainType() || t2 instanceof FunctionItemType || t2 instanceof ExternalObjectType) {
                return 4;
            }
            if (t1 instanceof AnyNodeTest) {
                if (t2 instanceof AnyNodeTest) {
                    return 0;
                }
                return 1;
            }
            if (t2 instanceof AnyNodeTest) {
                return 2;
            }
            int m1 = ((NodeTest)t1).getNodeKindMask();
            if ((m1 & (m2 = ((NodeTest)t2).getNodeKindMask())) == 0) {
                return 4;
            }
            int nodeKindRelationship = m1 == m2 ? 0 : ((m1 & m2) == m1 ? 2 : ((m1 & m2) == m2 ? 1 : 3));
            IntSet n1 = ((NodeTest)t1).getRequiredNodeNames();
            IntSet n2 = ((NodeTest)t2).getRequiredNodeNames();
            int nodeNameRelationship = n1 == null ? (n2 == null ? 0 : 1) : (n2 == null ? 2 : (n1.containsAll(n2) ? (n1.size() == n2.size() ? 0 : 1) : (n2.containsAll(n1) ? 2 : (IntHashSet.containsSome(n1, n2) ? 3 : 4))));
            int contentRelationship = this.computeContentRelationship(t1, t2, n1, n2);
            if (nodeKindRelationship == 0 && nodeNameRelationship == 0 && contentRelationship == 0) {
                return 0;
            }
            if (!(nodeKindRelationship != 0 && nodeKindRelationship != 1 || nodeNameRelationship != 0 && nodeNameRelationship != 1 || contentRelationship != 0 && contentRelationship != 1)) {
                return 1;
            }
            if (!(nodeKindRelationship != 0 && nodeKindRelationship != 2 || nodeNameRelationship != 0 && nodeNameRelationship != 2 || contentRelationship != 0 && contentRelationship != 2)) {
                return 2;
            }
            if (nodeKindRelationship == 4 || nodeNameRelationship == 4 || contentRelationship == 4) {
                return 4;
            }
            return 3;
        }
        if (t1 instanceof ExternalObjectType) {
            if (t2 instanceof ExternalObjectType) {
                return ((ExternalObjectType)t1).getRelationship((ExternalObjectType)t2);
            }
            return 4;
        }
        if (t2 instanceof FunctionItemType) {
            return ((FunctionItemType)t1).relationship((FunctionItemType)t2, this);
        }
        return 4;
    }

    protected int computeContentRelationship(ItemType t1, ItemType t2, IntSet n1, IntSet n2) {
        return 0;
    }

    private static int inverseRelationship(int relation) {
        switch (relation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public ItemType getGenericFunctionItemType() {
        return AnyItemType.getInstance();
    }

    public boolean isIdCode(int typeCode) {
        if ((typeCode &= 0xFFFFF) == 560) {
            return true;
        }
        if (typeCode < 1024) {
            return false;
        }
        SchemaType type = this.config.getSchemaType(typeCode);
        if (type == null) {
            return false;
        }
        return type.isIdType();
    }

    public boolean isIdrefsCode(int typeCode) {
        if ((typeCode &= 0xFFFFF) == 561 || typeCode == 562) {
            return true;
        }
        if (typeCode < 1024) {
            return false;
        }
        SchemaType type = this.config.getSchemaType(typeCode);
        if (type == null) {
            return false;
        }
        return type.isIdRefType();
    }

    private static class ItemTypePair
    implements Serializable {
        ItemType s;
        ItemType t;

        public ItemTypePair(ItemType s, ItemType t) {
            this.s = s;
            this.t = t;
        }

        public int hashCode() {
            return this.s.hashCode() ^ this.t.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemTypePair) {
                ItemTypePair pair = (ItemTypePair)obj;
                return this.s.equals(pair.s) && this.t.equals(pair.t);
            }
            return false;
        }
    }
}

