<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fc="http://www.saxonica.com/ns/doc/functions"
    version="2.0">
    
 
    

    <xsl:function name="fc:path-prefix" as="xs:string">
        <xsl:param name="node" as="element()"/>
        <xsl:sequence
            select="if ($node/(/table)) then '../' (: generated feature keys :)
                    else if ($node/ancestor::subpage) then '../../'
                    else if ($node/ancestor::page) then '../'
                    else ''"
        />
    </xsl:function>

    <xsl:template match="node()|@*" mode="f">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*" mode="f"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="fc:*" mode="f">
        <xsl:element name="{local-name()}">
            <xsl:apply-templates select="node()|@*" mode="f"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="fc:summary" mode="f">
        <p><xsl:apply-templates mode="f"/></p>
    </xsl:template>

    <xsl:template match="a|fc:a" mode="f">
        <xsl:choose>
            <xsl:when test="substring(@href, 1, 5) = ('file:','http:')">
                <xsl:copy-of select="."/>
            </xsl:when>
            <xsl:otherwise>
                <span class="link" data-href="{@href}">
                    <xsl:apply-templates select="node()" mode="secondary"/>
                </span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="code[@java]|fc:code[@java]" mode="f">
        <xsl:variable name="link" select="translate(@java, '.', '/')"/>
        <xsl:variable name="file"
            select="if (contains($link, '#')) 
                    then concat(substring-before($link, '#'), '.html#', substring-after($link, '#'))
                    else concat($link, '.html')"/>

        <a class="bodylink" href="{fc:path-prefix(.)}javadoc/{$file}">
            <code>
                <xsl:apply-templates/>
            </code>
        </a>
    </xsl:template>

    <xsl:template match="code[pre]|fc:code[pre]" mode="f">
        <code>
            <xsl:apply-templates select="pre/*"/>
        </code>
    </xsl:template>

    <xsl:template match="code|fc:code" mode="f">
        <code>
            <xsl:apply-templates/>
        </code>
    </xsl:template>

    <xsl:template match="pre|fc:pre" mode="f">
        <div class="codeblock">
            <xsl:next-match/>
        </div>
    </xsl:template>

    <xsl:template match="example|fc:example" priority="2" mode="f">
        <samp>
            <xsl:apply-templates/>
        </samp>
    </xsl:template>

    <xsl:template match="box|fc:box" priority="2" mode="f">
        <div class="boxed">
            <xsl:apply-templates/>
        </div>
    </xsl:template>

    <xsl:template match="fc:status-ok" mode="f">
        <xsl:if test="../fc:name[@namespace='http://www.w3.org/2005/xpath-functions']">
           <h3 class="subtitle">Notes on the Saxon implementation</h3>
           <p>The function is fully implemented according to the W3C specifications.</p>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template match="fc:status" mode="f">
        <h3 class="subtitle">Notes on the Saxon implementation</h3>
        <xsl:apply-templates mode="f"/>
    </xsl:template>

    <xsl:template match="fc:notes" mode="f">
        <p>
            <b>Note:</b>
            <xsl:apply-templates mode="f"/>
        </p>
    </xsl:template>
    
    <xsl:template match="fc:see-also" mode="f">
        <xsl:variable name="prefix" select="fc:usual-prefix(@namespace)"/>
        <p><span class="link" data-href="/functions/{$prefix}/{@name}"><xsl:value-of select="concat($prefix, ':', @name)"/>()</span></p>
    </xsl:template>

</xsl:transform>
