/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.FixedConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.AbstractModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    static final String[] DEPENDENCY_REGULAR_ATTRIBUTES = new String[]{"org", "name", "branch", "branchConstraint", "rev", "revConstraint", "force", "transitive", "changing", "conf"};
    private static final XmlModuleDescriptorParser INSTANCE = new XmlModuleDescriptorParser();

    public static XmlModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    protected XmlModuleDescriptorParser() {
    }

    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL xmlURL, Resource res, boolean validate) throws ParseException, IOException {
        Parser parser = this.newParser(ivySettings);
        parser.setValidate(validate);
        parser.setResource(res);
        parser.setInput(xmlURL);
        parser.parse();
        return parser.getModuleDescriptor();
    }

    protected Parser newParser(ParserSettings ivySettings) {
        return new Parser(this, ivySettings);
    }

    public boolean accept(Resource res) {
        return true;
    }

    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws IOException, ParseException {
        try {
            Namespace ns = null;
            if (md instanceof DefaultModuleDescriptor) {
                DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
                ns = dmd.getNamespace();
            }
            XmlModuleDescriptorUpdater.update(is, res, destFile, new UpdateOptions().setSettings(IvyContext.getContext().getSettings()).setStatus(md.getStatus()).setRevision(md.getResolvedModuleRevisionId().getRevision()).setPubdate(md.getResolvedPublicationDate()).setUpdateBranch(false).setNamespace(ns));
        }
        catch (SAXException e) {
            ParseException ex = new ParseException("exception occurred while parsing " + res, 0);
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        return "ivy parser";
    }

    public static class Parser
    extends AbstractModuleDescriptorParser.AbstractParser {
        protected static final List ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3", "1.4", "2.0", "2.1", "2.2");
        private ParserSettings settings;
        private boolean validate = true;
        private URL descriptorURL;
        private InputStream descriptorInput;
        private int state = 0;
        private PatternMatcher defaultMatcher;
        private DefaultDependencyDescriptor dd;
        private ConfigurationAware confAware;
        private MDArtifact artifact;
        private String conf;
        private boolean artifactsDeclared = false;
        private StringBuffer buffer;
        private String descriptorVersion;
        private String[] publicationsDefaultConf;

        public Parser(ModuleDescriptorParser parser, ParserSettings ivySettings) {
            super(parser);
            this.settings = ivySettings;
        }

        public void setInput(URL descriptorURL) {
            this.descriptorURL = descriptorURL;
        }

        public void setValidate(boolean validate) {
            this.validate = validate;
        }

        public void parse() throws ParseException, IOException {
            try {
                URL schemaURL;
                URL uRL = schemaURL = this.validate ? this.getSchemaURL() : null;
                if (this.descriptorURL != null) {
                    XMLHelper.parse(this.descriptorURL, schemaURL, this);
                } else {
                    XMLHelper.parse(this.descriptorInput, schemaURL, (DefaultHandler)this, null);
                }
                this.checkConfigurations();
                this.replaceConfigurationWildcards();
                this.getMd().setModuleArtifact(DefaultArtifact.newIvyArtifact(this.getMd().getResolvedModuleRevisionId(), this.getMd().getPublicationDate()));
                if (!this.artifactsDeclared) {
                    String[] confs = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.getMd().addArtifact(confs[i], new MDArtifact(this.getMd(), this.getMd().getModuleRevisionId().getName(), "jar", "jar"));
                    }
                }
                this.getMd().check();
            }
            catch (ParserConfigurationException ex) {
                IllegalStateException ise = new IllegalStateException(ex.getMessage() + " in " + this.descriptorURL);
                ise.initCause(ex);
                throw ise;
            }
            catch (Exception ex) {
                this.checkErrors();
                ParseException pe = new ParseException(ex.getMessage() + " in " + this.descriptorURL, 0);
                pe.initCause(ex);
                throw pe;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if (this.state == 11) {
                    this.getBuffer().append("<").append(qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.getBuffer().append(" ");
                        this.getBuffer().append(attributes.getQName(i));
                        this.getBuffer().append("=\"");
                        this.getBuffer().append(attributes.getValue(i));
                        this.getBuffer().append("\"");
                    }
                    this.getBuffer().append(">");
                    return;
                }
                if ("ivy-module".equals(qName)) {
                    this.ivyModuleStarted(attributes);
                } else if ("info".equals(qName)) {
                    this.infoStarted(attributes);
                } else if (this.state == 1 && "extends".equals(qName)) {
                    this.extendsStarted(attributes);
                } else if (this.state == 1 && "license".equals(qName)) {
                    this.getMd().addLicense(new License(this.settings.substitute(attributes.getValue("name")), this.settings.substitute(attributes.getValue("url"))));
                } else if (this.state == 1 && "description".equals(qName)) {
                    this.getMd().setHomePage(this.settings.substitute(attributes.getValue("homepage")));
                    this.state = 11;
                    this.buffer = new StringBuffer();
                } else if (!(this.state == 1 && "ivyauthor".equals(qName) || this.state == 1 && "repository".equals(qName))) {
                    if (this.state == 1 && this.isOtherNamespace(qName)) {
                        this.buffer = new StringBuffer();
                        this.state = 12;
                    } else if ("configurations".equals(qName)) {
                        this.configurationStarted(attributes);
                    } else if ("publications".equals(qName)) {
                        this.publicationsStarted(attributes);
                    } else if ("dependencies".equals(qName)) {
                        this.dependenciesStarted(attributes);
                    } else if ("conflicts".equals(qName)) {
                        if (!this.descriptorVersion.startsWith("1.")) {
                            Message.deprecated("using conflicts section is deprecated: please use hints section instead. Ivy file URL: " + this.descriptorURL);
                        }
                        this.state = 8;
                        this.checkConfigurations();
                    } else if ("artifact".equals(qName)) {
                        this.artifactStarted(qName, attributes);
                    } else if ("include".equals(qName) && this.state == 4) {
                        this.addIncludeRule(qName, attributes);
                    } else if ("exclude".equals(qName) && this.state == 4) {
                        this.addExcludeRule(qName, attributes);
                    } else if ("exclude".equals(qName) && this.state == 10) {
                        this.state = 9;
                        this.parseRule(qName, attributes);
                        this.getMd().addExcludeRule((ExcludeRule)((Object)this.confAware));
                    } else if ("dependency".equals(qName)) {
                        this.dependencyStarted(attributes);
                    } else if ("conf".equals(qName)) {
                        this.confStarted(attributes);
                    } else if ("mapped".equals(qName)) {
                        this.dd.addDependencyConfiguration(this.conf, this.settings.substitute(attributes.getValue("name")));
                    } else if ("conflict".equals(qName) && this.state == 10 || "manager".equals(qName) && this.state == 8) {
                        this.managerStarted(attributes, this.state == 8 ? "name" : "manager");
                    } else if ("override".equals(qName) && this.state == 10) {
                        this.mediationOverrideStarted(attributes);
                    } else if ("include".equals(qName) && this.state == 2) {
                        this.includeConfStarted(attributes);
                    } else if (this.validate && this.state != 12 && this.state != 11) {
                        this.addError("unknown tag " + qName);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                SAXException sax = new SAXException("Problem occurred while parsing ivy file: " + ex.getMessage(), ex);
                sax.initCause(ex);
                throw sax;
            }
        }

        protected String getDefaultParentLocation() {
            return "../ivy.xml";
        }

        protected void extendsStarted(Attributes attributes) throws ParseException {
            String parentOrganisation = attributes.getValue("organisation");
            String parentModule = attributes.getValue("module");
            String parentRevision = attributes.getValue("revision");
            String location = attributes.getValue("location") != null ? attributes.getValue("location") : this.getDefaultParentLocation();
            ModuleDescriptor parent = null;
            String extendType = attributes.getValue("extendType") != null ? attributes.getValue("extendType").toLowerCase() : "all";
            List<String> extendTypes = Arrays.asList(extendType.split(","));
            try {
                Message.debug("Trying to parse included ivy file :" + location);
                parent = this.parseOtherIvyFileOnFileSystem(location);
                ModuleId expected = new ModuleId(parentOrganisation, parentModule);
                ModuleId pid = parent.getModuleRevisionId().getModuleId();
                if (!expected.equals(pid)) {
                    Message.verbose("Ignoring parent Ivy file " + location + "; expected " + expected + " but found " + pid);
                    parent = null;
                }
            }
            catch (ParseException e) {
                Message.warn("Unable to parse included ivy file " + location + ": " + e.getMessage());
            }
            catch (IOException e) {
                Message.warn("Unable to parse included ivy file " + location + ": " + e.getMessage());
            }
            if (parent == null) {
                try {
                    Message.debug("Trying to parse included ivy file by asking repository for module :" + parentOrganisation + "#" + parentModule + ";" + parentRevision);
                    parent = this.parseOtherIvyFile(parentOrganisation, parentModule, parentRevision);
                }
                catch (ParseException e) {
                    Message.warn("Unable to parse included ivy file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision);
                }
            }
            if (parent == null) {
                throw new ParseException("Unable to parse included ivy file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision, 0);
            }
            ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
            File ivyFileInCache = cacheManager.getResolvedIvyFileInCache(parent.getResolvedModuleRevisionId());
            if (parent.getResource() != null && !parent.getResource().getName().equals(ivyFileInCache.toURI().toString())) {
                try {
                    parent.toIvyFile(ivyFileInCache);
                }
                catch (ParseException e) {
                    throw new ParseException("Unable to create cache file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision + " Reason:" + e.getLocalizedMessage(), 0);
                }
                catch (IOException e) {
                    throw new ParseException("Unable to create cache file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision + " Reason :" + e.getLocalizedMessage(), 0);
                }
            }
            DefaultExtendsDescriptor ed = new DefaultExtendsDescriptor(parent.getModuleRevisionId(), parent.getResolvedModuleRevisionId(), attributes.getValue("location"), extendTypes.toArray(new String[extendTypes.size()]));
            this.getMd().addInheritedDescriptor(ed);
            this.mergeWithOtherModuleDescriptor(extendTypes, parent);
        }

        protected void mergeWithOtherModuleDescriptor(List extendTypes, ModuleDescriptor parent) {
            if (extendTypes.contains("all")) {
                this.mergeAll(parent);
            } else {
                if (extendTypes.contains("info")) {
                    this.mergeInfo(parent);
                }
                if (extendTypes.contains("configurations")) {
                    this.mergeConfigurations(parent.getModuleRevisionId(), parent.getConfigurations());
                }
                if (extendTypes.contains("dependencies")) {
                    this.mergeDependencies(parent.getDependencies());
                }
                if (extendTypes.contains("description")) {
                    this.mergeDescription(parent.getDescription());
                }
            }
        }

        protected void mergeAll(ModuleDescriptor parent) {
            ModuleRevisionId sourceMrid = parent.getModuleRevisionId();
            this.mergeInfo(parent);
            this.mergeConfigurations(sourceMrid, parent.getConfigurations());
            this.mergeDependencies(parent.getDependencies());
            this.mergeDescription(parent.getDescription());
        }

        protected void mergeInfo(ModuleDescriptor parent) {
            ModuleRevisionId parentMrid = parent.getModuleRevisionId();
            DefaultModuleDescriptor descriptor = this.getMd();
            ModuleRevisionId currentMrid = descriptor.getModuleRevisionId();
            ModuleRevisionId mergedMrid = ModuleRevisionId.newInstance(Parser.mergeValue(parentMrid.getOrganisation(), currentMrid.getOrganisation()), currentMrid.getName(), Parser.mergeValue(parentMrid.getBranch(), currentMrid.getBranch()), Parser.mergeValue(parentMrid.getRevision(), currentMrid.getRevision()), Parser.mergeValues(parentMrid.getQualifiedExtraAttributes(), currentMrid.getQualifiedExtraAttributes()));
            descriptor.setModuleRevisionId(mergedMrid);
            descriptor.setResolvedModuleRevisionId(mergedMrid);
            descriptor.setStatus(Parser.mergeValue(parent.getStatus(), descriptor.getStatus()));
            if (descriptor.getNamespace() == null && parent instanceof DefaultModuleDescriptor) {
                Namespace parentNamespace = ((DefaultModuleDescriptor)parent).getNamespace();
                descriptor.setNamespace(parentNamespace);
            }
        }

        private static String mergeValue(String inherited, String override) {
            return override == null ? inherited : override;
        }

        private static Map mergeValues(Map inherited, Map overrides) {
            LinkedHashMap dup = new LinkedHashMap(inherited.size() + overrides.size());
            dup.putAll(inherited);
            dup.putAll(overrides);
            return dup;
        }

        protected void mergeConfigurations(ModuleRevisionId sourceMrid, Configuration[] configurations) {
            DefaultModuleDescriptor md = this.getMd();
            for (int i = 0; i < configurations.length; ++i) {
                Configuration configuration = configurations[i];
                Message.debug("Merging configuration with: " + configuration.getName());
                md.addConfiguration(new Configuration(configuration, sourceMrid));
            }
        }

        protected void mergeDependencies(DependencyDescriptor[] dependencies) {
            DefaultModuleDescriptor md = this.getMd();
            for (int i = 0; i < dependencies.length; ++i) {
                DependencyDescriptor dependencyDescriptor = dependencies[i];
                Message.debug("Merging dependency with: " + dependencyDescriptor.getDependencyRevisionId().toString());
                md.addDependency(dependencyDescriptor);
            }
        }

        protected void mergeDescription(String description) {
            String current = this.getMd().getDescription();
            if (current == null || current.trim().length() == 0) {
                this.getMd().setDescription(description);
            }
        }

        protected ModuleDescriptor parseOtherIvyFileOnFileSystem(String location) throws ParseException, IOException {
            URL url = null;
            ModuleDescriptor parent = null;
            url = this.getSettings().getRelativeUrlResolver().getURL(this.descriptorURL, location);
            Message.debug("Trying to load included ivy file from " + url.toString());
            URLResource res = new URLResource(url);
            ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(res);
            parent = parser.parseDescriptor(this.getSettings(), url, this.isValidate());
            return parent;
        }

        protected ModuleDescriptor parseOtherIvyFile(String parentOrganisation, String parentModule, String parentRevision) throws ParseException {
            DependencyResolver resolver;
            ModuleId parentModuleId = new ModuleId(parentOrganisation, parentModule);
            ModuleRevisionId parentMrid = new ModuleRevisionId(parentModuleId, parentRevision);
            File cacheFile = this.settings.getResolutionCacheManager().getResolvedIvyFileInCache(ModuleRevisionId.newInstance(parentMrid, Ivy.getWorkingRevision()));
            if (cacheFile.exists() && cacheFile.length() > 0L) {
                try {
                    Message.debug("Trying to load included ivy file from cache");
                    URL parentUrl = cacheFile.toURI().toURL();
                    ModuleDescriptor md = this.parseOtherIvyFileOnFileSystem(parentUrl.toString());
                    return md;
                }
                catch (IOException e) {
                    Message.error(e.getLocalizedMessage());
                }
            }
            DependencyDescriptor dd = new DefaultDependencyDescriptor(parentMrid, true);
            ResolveData data = IvyContext.getContext().getResolveData();
            if (data == null) {
                ResolveEngine engine = IvyContext.getContext().getIvy().getResolveEngine();
                ResolveOptions options = new ResolveOptions();
                options.setDownload(false);
                data = new ResolveData(engine, options);
            }
            if ((resolver = this.getSettings().getResolver(parentMrid)) == null) {
                return null;
            }
            ResolvedModuleRevision otherModule = resolver.getDependency(dd = NameSpaceHelper.toSystem(dd, this.getSettings().getContextNamespace()), data);
            if (otherModule == null) {
                throw new ParseException("Unable to find " + parentMrid.toString(), 0);
            }
            return otherModule.getDescriptor();
        }

        protected void publicationsStarted(Attributes attributes) {
            this.state = 3;
            this.artifactsDeclared = true;
            this.checkConfigurations();
            String defaultConf = this.settings.substitute(attributes.getValue("defaultconf"));
            if (defaultConf != null) {
                this.setPublicationsDefaultConf(defaultConf);
            }
        }

        protected void setPublicationsDefaultConf(String defaultConf) {
            this.publicationsDefaultConf = defaultConf == null ? null : defaultConf.split(",");
        }

        protected boolean isOtherNamespace(String qName) {
            return qName.indexOf(58) != -1;
        }

        protected void managerStarted(Attributes attributes, String string) {
            PatternMatcher patternMatcher;
            ConflictManager conflictManager;
            Object object;
            String string2 = this.settings.substitute(attributes.getValue("org"));
            string2 = string2 == null ? "*" : string2;
            String string3 = this.settings.substitute(attributes.getValue("module"));
            string3 = string3 == null ? "*" : string3;
            String string4 = this.settings.substitute(attributes.getValue(string));
            String string5 = this.settings.substitute(attributes.getValue("rev"));
            if (string5 != null) {
                object = string5.split(",");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    object[i] = object[i].trim();
                }
                conflictManager = new FixedConflictManager((String[])object);
            } else if (string4 != null) {
                conflictManager = this.settings.getConflictManager(string4);
                if (conflictManager == null) {
                    this.addError("unknown conflict manager: " + string4);
                    return;
                }
            } else {
                this.addError("bad conflict manager: no manager nor rev");
                return;
            }
            object = this.settings.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher2 = patternMatcher = object == null ? this.defaultMatcher : this.settings.getMatcher((String)object);
            if (patternMatcher == null) {
                this.addError("unknown matcher: " + (String)object);
                return;
            }
            this.getMd().addConflictManager(new ModuleId(string2, string3), patternMatcher, conflictManager);
        }

        protected void mediationOverrideStarted(Attributes attributes) {
            PatternMatcher patternMatcher;
            String string = this.settings.substitute(attributes.getValue("org"));
            string = string == null ? "*" : string;
            String string2 = this.settings.substitute(attributes.getValue("module"));
            string2 = string2 == null ? "*" : string2;
            String string3 = this.settings.substitute(attributes.getValue("rev"));
            String string4 = this.settings.substitute(attributes.getValue("branch"));
            String string5 = this.settings.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher2 = patternMatcher = string5 == null ? this.defaultMatcher : this.settings.getMatcher(string5);
            if (patternMatcher == null) {
                this.addError("unknown matcher: " + string5);
                return;
            }
            this.getMd().addDependencyDescriptorMediator(new ModuleId(string, string2), patternMatcher, new OverrideDependencyDescriptorMediator(string4, string3));
        }

        protected void includeConfStarted(Attributes attributes) throws SAXException, IOException, ParserConfigurationException, ParseException {
            URL uRL = this.settings.getRelativeUrlResolver().getURL(this.descriptorURL, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
            if (uRL == null) {
                throw new SAXException("include tag must have a file or an url attribute");
            }
            Parser parser = new Parser(this.getModuleDescriptorParser(), this.settings);
            parser.setInput(uRL);
            parser.setMd(new DefaultModuleDescriptor(this.getModuleDescriptorParser(), new URLResource(uRL)));
            XMLHelper.parse(uRL, null, parser);
            Configuration[] configurationArray = parser.getModuleDescriptor().getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                this.getMd().addConfiguration(configurationArray[i]);
            }
            if (parser.getDefaultConfMapping() != null) {
                Message.debug("setting default conf mapping from imported configurations file: " + parser.getDefaultConfMapping());
                this.setDefaultConfMapping(parser.getDefaultConfMapping());
            }
            if (parser.getDefaultConf() != null) {
                Message.debug("setting default conf from imported configurations file: " + parser.getDefaultConf());
                this.setDefaultConf(parser.getDefaultConf());
            }
            if (parser.getMd().isMappingOverride()) {
                Message.debug("enabling mapping-override from imported configurations file");
                this.getMd().setMappingOverride(true);
            }
        }

        protected void confStarted(Attributes attributes) {
            String string = this.settings.substitute(attributes.getValue("name"));
            switch (this.state) {
                case 2: {
                    String string2 = this.settings.substitute(attributes.getValue("visibility"));
                    String string3 = this.settings.substitute(attributes.getValue("extends"));
                    String string4 = attributes.getValue("transitive");
                    boolean bl = string4 == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
                    String string5 = attributes.getValue("deprecated");
                    Configuration configuration = new Configuration(string, Configuration.Visibility.getVisibility(string2 == null ? "public" : string2), this.settings.substitute(attributes.getValue("description")), string3 == null ? null : string3.split(","), bl, string5);
                    ExtendableItemHelper.fillExtraAttributes(this.settings, configuration, attributes, new String[]{"name", "visibility", "extends", "transitive", "description", "deprecated"});
                    this.getMd().addConfiguration(configuration);
                    break;
                }
                case 3: {
                    if ("*".equals(string)) {
                        String[] stringArray = this.getMd().getConfigurationsNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.artifact.addConfiguration(stringArray[i]);
                            this.getMd().addArtifact(stringArray[i], this.artifact);
                        }
                        break;
                    }
                    this.artifact.addConfiguration(string);
                    this.getMd().addArtifact(string, this.artifact);
                    break;
                }
                case 4: {
                    this.conf = string;
                    String string6 = this.settings.substitute(attributes.getValue("mapped"));
                    if (string6 == null) break;
                    String[] stringArray = string6.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.dd.addDependencyConfiguration(string, stringArray[i].trim());
                    }
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.addConfiguration(string);
                    break;
                }
                default: {
                    if (!this.validate) break;
                    this.addError("conf tag found in invalid tag: " + this.state);
                }
            }
        }

        protected void dependencyStarted(Attributes attributes) {
            this.state = 4;
            String string = this.settings.substitute(attributes.getValue("org"));
            if (string == null) {
                string = this.getMd().getModuleRevisionId().getOrganisation();
            }
            boolean bl = Boolean.valueOf(this.settings.substitute(attributes.getValue("force")));
            boolean bl2 = Boolean.valueOf(this.settings.substitute(attributes.getValue("changing")));
            String string2 = this.settings.substitute(attributes.getValue("transitive"));
            boolean bl3 = string2 == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
            String string3 = this.settings.substitute(attributes.getValue("name"));
            String string4 = this.settings.substitute(attributes.getValue("branch"));
            String string5 = this.settings.substitute(attributes.getValue("branchConstraint"));
            String string6 = this.settings.substitute(attributes.getValue("rev"));
            String string7 = this.settings.substitute(attributes.getValue("revConstraint"));
            Map map = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string, string3, string4, string6, map);
            ModuleRevisionId moduleRevisionId2 = null;
            moduleRevisionId2 = string7 == null && string5 == null ? ModuleRevisionId.newInstance(string, string3, string4, string6, map, false) : (string5 == null ? ModuleRevisionId.newInstance(string, string3, null, string7, map, false) : ModuleRevisionId.newInstance(string, string3, string5, string7, map));
            this.dd = new DefaultDependencyDescriptor(this.getMd(), moduleRevisionId, moduleRevisionId2, bl, bl2, bl3);
            this.getMd().addDependency(this.dd);
            String string8 = this.settings.substitute(attributes.getValue("conf"));
            if (string8 != null && string8.length() > 0) {
                this.parseDepsConfs(string8, this.dd);
            }
        }

        protected void artifactStarted(String string, Attributes attributes) throws MalformedURLException {
            if (this.state == 3) {
                String string2 = this.settings.substitute(attributes.getValue("name"));
                string2 = string2 == null ? this.getMd().getModuleRevisionId().getName() : string2;
                String string3 = this.settings.substitute(attributes.getValue("type"));
                string3 = string3 == null ? "jar" : string3;
                String string4 = this.settings.substitute(attributes.getValue("ext"));
                string4 = string4 != null ? string4 : string3;
                String string5 = this.settings.substitute(attributes.getValue("url"));
                this.artifact = new MDArtifact(this.getMd(), string2, string3, string4, string5 == null ? null : new URL(string5), ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"ext", "type", "name", "conf"}));
                String string6 = this.settings.substitute(attributes.getValue("conf"));
                if (string6 != null && string6.length() > 0) {
                    String[] stringArray = "*".equals(string6) ? this.getMd().getConfigurationsNames() : string6.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.artifact.addConfiguration(stringArray[i].trim());
                        this.getMd().addArtifact(stringArray[i].trim(), this.artifact);
                    }
                }
            } else if (this.state == 4) {
                this.addDependencyArtifacts(string, attributes);
            } else if (this.validate) {
                this.addError("artifact tag found in invalid tag: " + this.state);
            }
        }

        protected void dependenciesStarted(Attributes attributes) {
            String string;
            this.state = 10;
            String string2 = this.settings.substitute(attributes.getValue("defaultconf"));
            if (string2 != null) {
                this.setDefaultConf(string2);
            }
            if ((string2 = this.settings.substitute(attributes.getValue("defaultconfmapping"))) != null) {
                this.setDefaultConfMapping(string2);
            }
            if ((string = this.settings.substitute(attributes.getValue("confmappingoverride"))) != null) {
                this.getMd().setMappingOverride(Boolean.valueOf(string));
            }
            this.checkConfigurations();
        }

        protected void configurationStarted(Attributes attributes) {
            this.state = 2;
            this.setDefaultConfMapping(this.settings.substitute(attributes.getValue("defaultconfmapping")));
            this.setDefaultConf(this.settings.substitute(attributes.getValue("defaultconf")));
            this.getMd().setMappingOverride(Boolean.valueOf(this.settings.substitute(attributes.getValue("confmappingoverride"))));
        }

        protected void infoStarted(Attributes attributes) {
            Object object;
            this.state = 1;
            String string = this.settings.substitute(attributes.getValue("organisation"));
            String string2 = this.settings.substitute(attributes.getValue("module"));
            String string3 = this.settings.substitute(attributes.getValue("revision"));
            String string4 = this.settings.substitute(attributes.getValue("branch"));
            this.getMd().setModuleRevisionId(ModuleRevisionId.newInstance(string, string2, string4, string3, ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"organisation", "module", "revision", "status", "publication", "branch", "namespace", "default", "resolver"})));
            String string5 = this.settings.substitute(attributes.getValue("namespace"));
            if (string5 != null) {
                object = this.settings.getNamespace(string5);
                if (object == null) {
                    Message.warn("namespace not found for " + this.getMd().getModuleRevisionId() + ": " + string5);
                } else {
                    this.getMd().setNamespace((Namespace)object);
                }
            }
            object = this.settings.substitute(attributes.getValue("status"));
            this.getMd().setStatus((String)(object == null ? this.settings.getStatusManager().getDefaultStatus() : object));
            this.getMd().setDefault(Boolean.valueOf(this.settings.substitute(attributes.getValue("default"))));
            String string6 = this.settings.substitute(attributes.getValue("publication"));
            if (string6 != null && string6.length() > 0) {
                try {
                    this.getMd().setPublicationDate(Ivy.DATE_FORMAT.parse(string6));
                }
                catch (ParseException parseException) {
                    this.addError("invalid publication date format: " + string6);
                    this.getMd().setPublicationDate(this.getDefaultPubDate());
                }
            } else {
                this.getMd().setPublicationDate(this.getDefaultPubDate());
            }
        }

        protected void ivyModuleStarted(Attributes attributes) throws SAXException {
            this.descriptorVersion = attributes.getValue("version");
            int n = ALLOWED_VERSIONS.indexOf(this.descriptorVersion);
            if (n == -1) {
                this.addError("invalid version " + this.descriptorVersion);
                throw new SAXException("invalid version " + this.descriptorVersion);
            }
            if (n >= ALLOWED_VERSIONS.indexOf("1.3")) {
                Message.debug("post 1.3 ivy file: using exact as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exact");
            } else {
                Message.debug("pre 1.3 ivy file: using exactOrRegexp as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exactOrRegexp");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).startsWith("xmlns:")) continue;
                this.getMd().addExtraAttributeNamespace(attributes.getQName(i).substring("xmlns:".length()), attributes.getValue(i));
            }
        }

        protected void addDependencyArtifacts(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 5;
            this.parseRule(tag, attributes);
        }

        protected void addIncludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 6;
            this.parseRule(tag, attributes);
        }

        protected void addExcludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 7;
            this.parseRule(tag, attributes);
        }

        protected void parseRule(String string, Attributes attributes) throws MalformedURLException {
            Map map;
            ArtifactId artifactId;
            String string2;
            Object object;
            Object object2;
            String string3;
            String string4;
            String string5 = this.settings.substitute(attributes.getValue("name"));
            if (string5 == null && (string5 = this.settings.substitute(attributes.getValue("artifact"))) == null) {
                String string6 = string5 = "artifact".equals(string) ? this.dd.getDependencyId().getName() : "*";
            }
            if ((string4 = this.settings.substitute(attributes.getValue("type"))) == null) {
                string4 = "artifact".equals(string) ? "jar" : "*";
            }
            String string7 = string3 = (string3 = this.settings.substitute(attributes.getValue("ext"))) != null ? string3 : string4;
            if (this.state == 5) {
                object2 = this.settings.substitute(attributes.getValue("url"));
                object = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"name", "type", "ext", "url", "conf"});
                this.confAware = new DefaultDependencyArtifactDescriptor(this.dd, string5, string4, string3, object2 == null ? null : new URL((String)object2), (Map)object);
            } else if (this.state == 6) {
                object2 = this.getPatternMatcher(attributes.getValue("matcher"));
                object = this.settings.substitute(attributes.getValue("org"));
                object = object == null ? "*" : object;
                string2 = this.settings.substitute(attributes.getValue("module"));
                string2 = string2 == null ? "*" : string2;
                artifactId = new ArtifactId(new ModuleId((String)object, string2), string5, string4, string3);
                map = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultIncludeRule(artifactId, (PatternMatcher)object2, map);
            } else {
                object2 = this.getPatternMatcher(attributes.getValue("matcher"));
                object = this.settings.substitute(attributes.getValue("org"));
                object = object == null ? "*" : object;
                string2 = this.settings.substitute(attributes.getValue("module"));
                string2 = string2 == null ? "*" : string2;
                artifactId = new ArtifactId(new ModuleId((String)object, string2), string5, string4, string3);
                map = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultExcludeRule(artifactId, (PatternMatcher)object2, map);
            }
            object2 = this.settings.substitute(attributes.getValue("conf"));
            if (object2 != null && ((String)object2).length() > 0) {
                object = "*".equals(object2) ? this.getMd().getConfigurationsNames() : ((String)object2).split(",");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    this.addConfiguration(object[i].trim());
                }
            }
        }

        protected void addConfiguration(String c) {
            this.confAware.addConfiguration(c);
            if (this.state != 9) {
                if (this.confAware instanceof DependencyArtifactDescriptor) {
                    this.dd.addDependencyArtifact(c, (DependencyArtifactDescriptor)((Object)this.confAware));
                } else if (this.confAware instanceof IncludeRule) {
                    this.dd.addIncludeRule(c, (IncludeRule)((Object)this.confAware));
                } else if (this.confAware instanceof ExcludeRule) {
                    this.dd.addExcludeRule(c, (ExcludeRule)((Object)this.confAware));
                }
            }
        }

        protected PatternMatcher getPatternMatcher(String string) {
            PatternMatcher patternMatcher;
            String string2 = this.settings.substitute(string);
            PatternMatcher patternMatcher2 = patternMatcher = string2 == null ? this.defaultMatcher : this.settings.getMatcher(string2);
            if (patternMatcher == null) {
                throw new IllegalArgumentException("unknown matcher " + string2);
            }
            return patternMatcher;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.state == 3 && "artifact".equals(string3) && this.artifact.getConfigurations().length == 0) {
                String[] stringArray = this.publicationsDefaultConf == null ? this.getMd().getConfigurationsNames() : this.publicationsDefaultConf;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.artifact.addConfiguration(stringArray[i].trim());
                    this.getMd().addArtifact(stringArray[i].trim(), this.artifact);
                }
            } else if ("configurations".equals(string3)) {
                this.checkConfigurations();
            } else if (this.state == 5 && "artifact".equals(string3) || this.state == 6 && "include".equals(string3) || this.state == 7 && "exclude".equals(string3)) {
                this.state = 4;
                if (this.confAware.getConfigurations().length == 0) {
                    String[] stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.addConfiguration(stringArray[i]);
                    }
                }
                this.confAware = null;
            } else if ("exclude".equals(string3) && this.state == 9) {
                if (this.confAware.getConfigurations().length == 0) {
                    String[] stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.addConfiguration(stringArray[i]);
                    }
                }
                this.confAware = null;
                this.state = 10;
            } else if ("dependency".equals(string3) && this.state == 4) {
                if (this.dd.getModuleConfigurations().length == 0) {
                    this.parseDepsConfs(this.getDefaultConf(), this.dd);
                }
                this.state = 10;
            } else if ("dependencies".equals(string3) && this.state == 10) {
                this.state = 0;
            } else if (this.state == 1 && "info".equals(string3)) {
                this.state = 0;
            } else if (this.state == 11 && "description".equals(string3)) {
                this.getMd().setDescription(this.buffer == null ? "" : this.buffer.toString().trim());
                this.buffer = null;
                this.state = 1;
            } else if (this.state == 12) {
                this.getMd().addExtraInfo(string3, this.buffer == null ? "" : this.buffer.toString());
                this.buffer = null;
                this.state = 1;
            } else if (this.state == 11) {
                if (this.buffer.toString().endsWith("<" + string3 + ">")) {
                    this.buffer.deleteCharAt(this.buffer.length() - 1);
                    this.buffer.append("/>");
                } else {
                    this.buffer.append("</" + string3 + ">");
                }
            }
        }

        protected void checkConfigurations() {
            if (this.getMd().getConfigurations().length == 0) {
                this.getMd().addConfiguration(new Configuration("default"));
            }
        }

        protected void replaceConfigurationWildcards() {
            Configuration[] configs = this.getMd().getConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                configs[i].replaceWildcards(this.getMd());
            }
        }

        protected ParserSettings getSettings() {
            return this.settings;
        }

        protected StringBuffer getBuffer() {
            return this.buffer;
        }

        protected boolean isValidate() {
            return this.validate;
        }

        protected URL getSchemaURL() {
            return this.getClass().getResource("ivy.xsd");
        }
    }
}

