/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import slothLib.NLP.IMorphologicalAnalyzer;
import slothLib.NLP.MeCabResult;
import slothLib.SlothLib;
import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;

public class MeCab
implements IMorphologicalAnalyzer {
    private static final String mecabPathPropKey = "slothLib.NLP.MeCab.meCabPath";
    private static final String mecabRcPathPropKey = "slothLib.NLP.MeCab.meCabRcPath";
    private static final String mecabEncodingPropKey = "slothLib.NLP.MeCab.meCabEncoding";
    private static final String MECAB_PATH_DEFAULT = "/usr/local/bin/mecab";
    private static final String MECAB_RCPATH_DEFAULT = "/usr/local/etc/mecabrc";
    private static final String MECAB_ENCODING_DEFAULT = "EUC_JP";
    private String meCabPath;
    private String meCabRcPath;

    static {
        SlothLib.init();
    }

    public MeCab() throws SlothLibException {
        this.setMeCabPath(MeCab._getMeCabPath());
        this.setMeCabRcPath(MeCab._getMeCabRcPath());
    }

    public MeCab(String meCabPath, String meCabRcPath) throws SlothLibException {
        this.setMeCabPath(meCabPath);
        this.setMeCabRcPath(meCabRcPath);
    }

    public String getMeCabPath() {
        return this.meCabPath;
    }

    public String getMeCabRcPath() {
        return this.meCabRcPath;
    }

    private void setMeCabPath(String path) throws SlothLibException {
        if (!PortUtil.fileExists(path)) {
            throw new SlothLibException("mecab\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + path);
        }
        this.meCabPath = path;
    }

    private void setMeCabRcPath(String path) throws SlothLibException {
        if (path == null || !PortUtil.fileExists(path)) {
            throw new SlothLibException("mecabrc\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + path);
        }
        this.meCabRcPath = path;
    }

    @Override
    public MeCabResult doAnalyze(String text) throws SlothLibException {
        try {
            if (text == null) {
                throw new IllegalArgumentException("text\u5f15\u6570\u304cnull\u3067\u3059\u3002");
            }
            String tempFilePath = File.createTempFile("SlothLib.NLP.MeCab.doAnalyze.", ".tmp").getPath();
            String[] splitText = text.split("\\n");
            PrintWriter sw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFilePath), MeCab.getMeCabEncoding()));
            String[] stringArray = splitText;
            int n = splitText.length;
            int n2 = 0;
            while (n2 < n) {
                String input = stringArray[n2];
                String inputTrim = input.trim();
                if (!PortUtil.isNullOrEmpty(inputTrim)) {
                    sw.println(inputTrim);
                }
                ++n2;
            }
            sw.flush();
            sw.close();
            String parsedText = this.parseFile(tempFilePath);
            PortUtil.fileDelete(tempFilePath);
            return new MeCabResult(parsedText);
        }
        catch (IOException e) {
            throw new SlothLibException(e);
        }
    }

    private String parseFile(String tempFilePath) throws SlothLibException {
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(this.getMeCabPath());
            if (this.getMeCabRcPath() != null) {
                cmds.add("-r");
                cmds.add(this.getMeCabRcPath());
            }
            cmds.add(tempFilePath);
            ProcessBuilder pb = new ProcessBuilder(cmds);
            Process p = pb.start();
            String output = PortUtil.readFully(p.getInputStream(), MeCab.getMeCabEncoding());
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            int ec = p.exitValue();
            if (ec != 0) {
                throw new SlothLibException("mecab\u306e\u5b9f\u884c\u6642\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u3053\u308a\u307e\u3057\u305f\u3002" + ec + "\n" + output);
            }
            return output;
        }
        catch (IOException e) {
            throw new SlothLibException(e);
        }
    }

    public static String _getMeCabPath() {
        return System.getProperty(mecabPathPropKey, MECAB_PATH_DEFAULT);
    }

    public static String _getMeCabRcPath() {
        return System.getProperty(mecabRcPathPropKey, MECAB_RCPATH_DEFAULT);
    }

    public static String getMeCabEncoding() {
        return System.getProperty(mecabEncodingPropKey, MECAB_ENCODING_DEFAULT);
    }
}

