/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.util.ArrayList;
import java.util.List;
import slothLib.NLP.IMorpheme;
import slothLib.NLP.IMorphemeFilter;
import slothLib.NLP.IMorphemeToStringFilter;
import slothLib.NLP.IStringFilter;

public class MorphemeFilterList {
    private List<IMorphemeFilter> morphemeFilterList;
    private IMorphemeToStringFilter morphemeToStringFilter;
    private List<IStringFilter> stringFilterList;

    public MorphemeFilterList() {
        this.morphemeFilterList = new ArrayList<IMorphemeFilter>();
        this.morphemeToStringFilter = null;
        this.stringFilterList = new ArrayList<IStringFilter>();
    }

    public MorphemeFilterList(Iterable<IMorphemeFilter> morphemeFilters) {
        this.morphemeFilterList = MorphemeFilterList.createArrayList(morphemeFilters);
        this.morphemeToStringFilter = null;
        this.stringFilterList = new ArrayList<IStringFilter>();
    }

    public MorphemeFilterList(IMorphemeToStringFilter morphemeToStringFilter) {
        this.morphemeFilterList = new ArrayList<IMorphemeFilter>();
        this.morphemeToStringFilter = morphemeToStringFilter;
        this.stringFilterList = new ArrayList<IStringFilter>();
    }

    public MorphemeFilterList(Iterable<IStringFilter> stringFilters, Object dummy) {
        this.morphemeFilterList = new ArrayList<IMorphemeFilter>();
        this.morphemeToStringFilter = null;
        this.stringFilterList = MorphemeFilterList.createArrayList(stringFilters);
    }

    public MorphemeFilterList(Iterable<IMorphemeFilter> morphemeFilters, IMorphemeToStringFilter morphemeToStringFilter, Iterable<IStringFilter> stringFilters) {
        this.morphemeFilterList = MorphemeFilterList.createArrayList(morphemeFilters);
        this.morphemeToStringFilter = morphemeToStringFilter;
        this.stringFilterList = MorphemeFilterList.createArrayList(stringFilters);
    }

    public boolean hasMorphemeToStringFilter() {
        return this.morphemeToStringFilter != null;
    }

    public void add(IMorphemeFilter morphemeFilter) {
        this.morphemeFilterList.add(morphemeFilter);
    }

    public void add(IMorphemeToStringFilter morphemeToStringFilter) {
        this.morphemeToStringFilter = morphemeToStringFilter;
    }

    public void add(IStringFilter StringFilter2) {
        this.stringFilterList.add(StringFilter2);
    }

    public IMorpheme doMorphemeFilter(IMorpheme morpheme) {
        IMorpheme resultMorpheme = morpheme;
        for (IMorphemeFilter filter : this.morphemeFilterList) {
            resultMorpheme = filter.doFilter(resultMorpheme);
            if (resultMorpheme != null) continue;
            return null;
        }
        return resultMorpheme;
    }

    public IMorpheme[] doMorphemeFilter(Iterable<IMorpheme> morphemes) {
        IMorpheme[] resultMorphemes = MorphemeFilterList.createArrayList(morphemes).toArray(new IMorpheme[0]);
        for (IMorphemeFilter filter : this.morphemeFilterList) {
            resultMorphemes = filter.doFilter(resultMorphemes);
        }
        return resultMorphemes;
    }

    public String doStringFilter(String str) {
        String resultString = str;
        for (IStringFilter filter : this.stringFilterList) {
            resultString = filter.doFilter(resultString);
            if (resultString != null) continue;
            return null;
        }
        return resultString;
    }

    public String[] doStringFilter(Iterable<String> strings) {
        String[] resultStrings = MorphemeFilterList.createArrayList(strings).toArray(new String[0]);
        return this.doStringFilter(resultStrings);
    }

    public String[] doStringFilter(String[] resultStrings) {
        for (IStringFilter filter : this.stringFilterList) {
            resultStrings = filter.doFilter(resultStrings);
        }
        return resultStrings;
    }

    public String doMorphemeToStringFilter(IMorpheme morpheme) {
        if (this.morphemeToStringFilter == null) {
            throw new RuntimeException("IMorphemeToStringFilter\u304c\u3042\u308a\u307e\u305b\u3093");
        }
        if ((morpheme = this.doMorphemeFilter(morpheme)) == null) {
            return null;
        }
        String str = this.morphemeToStringFilter.doFilter(morpheme);
        if (str == null) {
            return null;
        }
        return this.doStringFilter(str);
    }

    public String[] doMorphemeToStringFilter(Iterable<IMorpheme> morphemes) {
        if (this.morphemeToStringFilter == null) {
            throw new RuntimeException("IMorphemeToStringFilter\u304c\u3042\u308a\u307e\u305b\u3093");
        }
        IMorpheme[] tmpMorphemes = this.doMorphemeFilter(morphemes);
        String[] strings = this.morphemeToStringFilter.doFilter(tmpMorphemes);
        return this.doStringFilter(strings);
    }

    IMorpheme iMorphemeFilter_doFilter(IMorpheme morpheme) {
        return this.doMorphemeFilter(morpheme);
    }

    IMorpheme[] IMorphemeFilter_doFilter(Iterable<IMorpheme> morphemes) {
        return this.doMorphemeFilter(morphemes);
    }

    public String iStringFilter_doFilter(String str) {
        return this.doStringFilter(str);
    }

    public String[] iStringFilter_doFilter(Iterable<String> strings) {
        return this.doStringFilter(strings);
    }

    String iMorphemeToStringFilter_doFilter(IMorpheme morpheme) {
        return this.doMorphemeToStringFilter(morpheme);
    }

    String[] iMorphemeToStringFilter_doFilter(Iterable<IMorpheme> morphemes) {
        return this.doMorphemeToStringFilter(morphemes);
    }

    static <T> ArrayList<T> createArrayList(Iterable<T> src) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T t : src) {
            tmp.add(t);
        }
        return tmp;
    }
}

