/*
 * Decompiled with CFR 0.152.
 */
package slothLib.io;

import java.util.ArrayList;
import java.util.List;
import slothLib.SlothLib;
import slothLib.SlothLibException;
import slothLib.io.GenericContentReader;
import slothLib.io.IContentReader;
import slothLib.io.TextReader;
import slothLib.portUtil.PortUtil;

public class MultiReader
implements IContentReader {
    private List<IContentReader> readers = new ArrayList<IContentReader>();
    private static String XDOC2TXT_TAG;
    private static String XDOC2TXT_DEFAULT;
    private static String PDFTOTEXTREADER_TAG;
    private static String PDFTOTEXT_DEFAULT;
    private static String W3M_PROP_TAG;
    private static String W3M_DEFAULT;
    private static String WVTEXT_PROP_TAG;
    private static String WVTEXT_DEFAULT;
    private static String XLHTML_PROP_TAG;
    private static String XLHTML_DEFAULT;
    private static String PPTHTML_PROP_TAG;
    private static String PPTHTML_DEFAULT;

    static {
        SlothLib.init();
        XDOC2TXT_TAG = "slothlib.xdoc2txt.path";
        XDOC2TXT_DEFAULT = "C:\\Program Files\\xdoc2txt\\xdoc2txt.exe";
        PDFTOTEXTREADER_TAG = "slothlib.pdftotext.path";
        PDFTOTEXT_DEFAULT = "/usr/bin/pdftotext";
        W3M_PROP_TAG = "slothlib.w3m.path";
        W3M_DEFAULT = "/usr/bin/w3m";
        WVTEXT_PROP_TAG = "slothlib.wvText.path";
        WVTEXT_DEFAULT = "/usr/bin/wvText";
        XLHTML_PROP_TAG = "slothlib.xlhtml.path";
        XLHTML_DEFAULT = "/usr/bin/xlhtml";
        PPTHTML_PROP_TAG = "slothlib.ppthtml.path";
        PPTHTML_DEFAULT = "/usr/bin/ppthtml";
    }

    public MultiReader() throws SlothLibException {
        this.readers.add(new TextReader());
        IContentReader reader = MultiReader.createXdoc2TxtReader();
        if (reader != null) {
            this.readers.add(reader);
        }
        if ((reader = MultiReader.createPdfReader()) != null) {
            this.readers.add(reader);
        }
        if ((reader = MultiReader.createHtmlReader()) != null) {
            this.readers.add(reader);
        }
        if ((reader = MultiReader.createDocReader()) != null) {
            this.readers.add(reader);
        }
        if ((reader = MultiReader.createXlsReader()) != null) {
            this.readers.add(reader);
        }
        if ((reader = MultiReader.createPptReader()) != null) {
            this.readers.add(reader);
        }
    }

    @Override
    public String read(String filePath) throws SlothLibException {
        if (!PortUtil.fileExists(filePath)) {
            throw new SlothLibException("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        String fileExt = filePath.substring(filePath.lastIndexOf(".")).toLowerCase();
        for (IContentReader reader : this.readers) {
            if (!reader.isReadable(fileExt)) continue;
            return reader.read(filePath);
        }
        throw new SlothLibException(String.valueOf(fileExt) + "cannot be handled with MultiReader");
    }

    @Override
    public boolean isReadable(String extension) {
        for (IContentReader reader : this.readers) {
            if (!reader.isReadable(extension)) continue;
            return true;
        }
        return false;
    }

    private static IContentReader createXdoc2TxtReader() {
        GenericContentReader reader = new GenericContentReader(".pdf", ".html", ".htm", ".doc", ".xls", ".ppt");
        String cmd = System.getProperty(XDOC2TXT_TAG, XDOC2TXT_DEFAULT);
        if (!PortUtil.fileExists(cmd)) {
            return null;
        }
        reader.addCommand(cmd, "__FILE__", "-");
        reader.setFileterMode(false);
        return reader;
    }

    private static IContentReader createPdfReader() {
        GenericContentReader reader = new GenericContentReader(".pdf");
        String cmd = System.getProperty(PDFTOTEXTREADER_TAG, PDFTOTEXT_DEFAULT);
        if (!PortUtil.fileExists(cmd)) {
            return null;
        }
        reader.addCommand(cmd, "__FILE__", "-");
        reader.setFileterMode(false);
        return reader;
    }

    private static IContentReader createHtmlReader() {
        GenericContentReader reader = new GenericContentReader(".html", ".htm");
        String cmd = System.getProperty(W3M_PROP_TAG, W3M_DEFAULT);
        if (!PortUtil.fileExists(cmd)) {
            return null;
        }
        reader.addCommand(cmd, "-T", "text/html", "-dump", "__FILE__");
        reader.setFileterMode(false);
        return reader;
    }

    private static IContentReader createDocReader() {
        GenericContentReader reader = new GenericContentReader(".doc");
        String cmd = System.getProperty(WVTEXT_PROP_TAG, WVTEXT_DEFAULT);
        if (!PortUtil.fileExists(cmd)) {
            return null;
        }
        reader.addCommand(cmd, "__FILE__", "__OUTPUT__");
        reader.setFileterMode(false);
        return reader;
    }

    private static IContentReader createXlsReader() {
        GenericContentReader reader = new GenericContentReader(".xls");
        String cmd = System.getProperty(XLHTML_PROP_TAG, XLHTML_DEFAULT);
        if (!PortUtil.fileExists(cmd)) {
            return null;
        }
        String cmd2 = System.getProperty(W3M_PROP_TAG, W3M_DEFAULT);
        if (!PortUtil.fileExists(cmd2)) {
            return null;
        }
        reader.addCommand(cmd, "__FILE__");
        reader.addCommand(cmd2, "-T", "text/html", "-dump");
        reader.setFileterMode(false);
        return reader;
    }

    private static IContentReader createPptReader() {
        GenericContentReader reader = new GenericContentReader(".ppt");
        String cmd = System.getProperty(PPTHTML_PROP_TAG, PPTHTML_DEFAULT);
        if (!PortUtil.fileExists(cmd)) {
            return null;
        }
        String cmd2 = System.getProperty(W3M_PROP_TAG, W3M_DEFAULT);
        if (!PortUtil.fileExists(cmd2)) {
            return null;
        }
        reader.addCommand(cmd, "__FILE__");
        reader.addCommand(cmd2, "-T", "text/html", "-dump");
        reader.setFileterMode(false);
        return reader;
    }
}

