/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import slothLib.linearAlgebra.featureVector.AbstractVector;
import slothLib.linearAlgebra.featureVector.IVector;
import slothLib.linearAlgebra.featureVector.VectorComparer;

public class BasicVector<T>
extends AbstractVector<T> {
    private Map<T, Double> dic = new HashMap<T, Double>();

    public BasicVector() {
    }

    public BasicVector(IVector<T> vector) {
        this();
        for (T key : vector.keys()) {
            this.dic.put(key, vector.get(key));
        }
    }

    public BasicVector(Map<T, Double> dictionary) {
        this();
        for (T key : dictionary.keySet()) {
            this.dic.put(key, dictionary.get(key));
        }
    }

    @Override
    public double get(T e) {
        if (this.dic.containsKey(e)) {
            return this.dic.get(e);
        }
        return 0.0;
    }

    @Override
    public void set(T e, double val) {
        this.dic.put(e, val);
        if (val == 0.0) {
            this.dic.remove(e);
        }
    }

    @Override
    public Object clone() {
        return new BasicVector<T>(this);
    }

    public int dimension() {
        return this.dic.size();
    }

    @Override
    public double[] getPlainVector() {
        double[] r = new double[this.dimension()];
        int i = 0;
        for (T key : this.keys()) {
            r[i++] = this.get(key);
        }
        return null;
    }

    public boolean containsKey(T key) {
        return this.dic.containsKey(key);
    }

    @Override
    public Set<T> keys() {
        return this.dic.keySet();
    }

    @Override
    public List<T> keyList() {
        return new ArrayList<T>(this.keys());
    }

    @Override
    public List<T> getSortedKeyList() {
        List<T> keyList = this.keyList();
        Collections.sort(keyList, new VectorComparer(this));
        return keyList;
    }
}

