/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import slothLib.linearAlgebra.featureVector.AddVector;
import slothLib.linearAlgebra.featureVector.BasicVector;
import slothLib.linearAlgebra.featureVector.CentroidDendrogramNode;
import slothLib.linearAlgebra.featureVector.ClusteringDistanceType;
import slothLib.linearAlgebra.featureVector.HierarchicalClusteringProcess;
import slothLib.linearAlgebra.featureVector.ICalculatorScalarFromTwoVectors;
import slothLib.linearAlgebra.featureVector.IDendrogramNode;
import slothLib.linearAlgebra.featureVector.IVector;
import slothLib.linearAlgebra.featureVector.MultiplyVector;

public class CentroidClusteringProcess<T>
extends HierarchicalClusteringProcess<T> {
    protected int[] itemCountInCluster;
    protected IVector<T>[] centroidVectors;

    public CentroidClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType) {
        super(vectors, calculator, dType);
        this.itemCountInCluster = new int[this.itemCount];
        this.centroidVectors = (IVector[])new Object[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            this.itemCountInCluster[i] = 1;
            this.centroidVectors[i] = new BasicVector<T>(vectors[i]);
            ++i;
        }
    }

    @Override
    protected IDendrogramNode<T> getDendrogramNode(int cid1, int cid2, double minDistance) {
        return new CentroidDendrogramNode<T>(cid1, cid2, minDistance, this.centroidVectors[cid1]);
    }

    @Override
    protected void union(int cid1, int cid2) {
        this.clusterID[cid2] = cid1;
        MultiplyVector v1 = new MultiplyVector((double)this.itemCountInCluster[cid1], this.centroidVectors[cid1]);
        MultiplyVector v2 = new MultiplyVector((double)this.itemCountInCluster[cid2], this.centroidVectors[cid2]);
        int c = this.itemCountInCluster[cid1] + this.itemCountInCluster[cid2];
        MultiplyVector v = new MultiplyVector(1.0 / (double)c, new AddVector(v1, v2));
        this.centroidVectors[cid1] = v;
        this.itemCountInCluster[cid1] = c;
        int i = 0;
        while (i < this.itemCount) {
            if (this.clusterID[i] == i && i != cid1 && i != cid2) {
                this.setDistance(cid1, i, this.calculator.doCalculate(this.centroidVectors[i], v) * this.ds);
            }
            ++i;
        }
    }
}

