/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.matrix;

import slothLib.linearAlgebra.matrix.BasicMatrix;
import slothLib.linearAlgebra.matrix.IMatrix;

public class LogMatrix
extends BasicMatrix {
    public LogMatrix(IMatrix matrix) {
        this(matrix, 2.0, 1.0);
    }

    public LogMatrix(IMatrix matrix, double baseValue, double addValue) {
        super(matrix.rowCount(), matrix.columnCount());
        int i = 0;
        while (i < matrix.rowCount()) {
            int j = 0;
            while (j < matrix.columnCount()) {
                if (matrix.get(i, j) <= 0.0) {
                    this.set(i, j, Math.log(addValue + matrix.get(i, j)) / Math.log(baseValue));
                } else {
                    this.set(i, j, Math.log(matrix.get(i, j)) / Math.log(baseValue));
                }
                ++j;
            }
            ++i;
        }
    }
}

