/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.configuration.impl;

import de.jollyday.configuration.ConfigurationProvider;
import de.jollyday.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationProvider.class.getName());
    private static final String CONFIG_FILE = "jollyday.properties";
    private ResourceUtil resourceUtil = new ResourceUtil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            InputStream stream = null;
            try {
                stream = this.resourceUtil.getResource(CONFIG_FILE).openStream();
                if (stream != null) {
                    properties.load(stream);
                } else {
                    LOG.warning("Could not load default properties file 'jollyday.properties' from classpath.");
                }
                this.closeStream(stream);
            }
            catch (Throwable throwable) {
                this.closeStream(stream);
                throw throwable;
            }
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load default properties from classpath.", e);
        }
    }

    private void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.warning("Could not close configurations input stream.");
            }
        }
    }
}

