/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import java.io.File;
import java.io.FileFilter;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private String extension;
    private boolean recursively;

    public ExtensionFileFilter(String ext, boolean recurse) {
        if (ext != null) {
            this.extension = ext.startsWith(".") ? ext : '.' + ext;
        }
        this.recursively = recurse;
    }

    public ExtensionFileFilter(String ext) {
        this(ext, true);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.recursively;
        }
        if (this.extension == null) {
            return true;
        }
        return file.getName().endsWith(this.extension);
    }

    @Override
    public String getDescription() {
        String ucExt = this.extension.substring(1).toUpperCase();
        return ucExt + " Files (*" + this.extension + ')';
    }
}

