/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtOffsetsOnlySourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.psi.PsiSourceManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001d\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b\u00a2\u0006\u0002\u0010\t\u001a\u001b\u0010\n\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b\u00a2\u0006\u0002\u0010\t\u001a#\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\r\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u000e\u001a$\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0003\u00a8\u0006\u0018"}, d2={"findKtSourceElement", "Lorg/jetbrains/kotlin/KtSourceElement;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "peek", "E", "", "(Ljava/util/List;)Ljava/lang/Object;", "pop", "push", "", "element", "(Ljava/util/List;Ljava/lang/Object;)Z", "reportWarning", "", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "message", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "sourceElement", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "ir.backend.common"})
public final class UtilsKt {
    public static final void reportWarning(@NotNull CommonBackendContext $this$reportWarning, @NotNull String message, @Nullable IrFile irFile, @NotNull IrElement irElement) {
        Intrinsics.checkNotNullParameter((Object)$this$reportWarning, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        $this$reportWarning.report(irElement, irFile, message, false);
    }

    public static final <E> boolean push(@NotNull List<E> $this$push, E element) {
        Intrinsics.checkNotNullParameter($this$push, (String)"<this>");
        return $this$push.add(element);
    }

    public static final <E> E pop(@NotNull List<E> $this$pop) {
        Intrinsics.checkNotNullParameter($this$pop, (String)"<this>");
        return $this$pop.remove($this$pop.size() - 1);
    }

    @Nullable
    public static final <E> E peek(@NotNull List<E> $this$peek) {
        Intrinsics.checkNotNullParameter($this$peek, (String)"<this>");
        return $this$peek.size() == 0 ? null : (E)$this$peek.get($this$peek.size() - 1);
    }

    @NotNull
    public static final KtSourceElement findKtSourceElement(@NotNull IrElement irElement, @NotNull IrDeclaration irDeclaration2) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
        PsiElement psiElement = PsiSourceManager.INSTANCE.findPsiElement(irElement, irDeclaration2);
        if (psiElement == null) {
            throw new AssertionError((Object)("No PsiElement found for '" + RenderIrElementKt.render(irElement) + '\''));
        }
        PsiElement psiElement2 = psiElement;
        return new KtRealPsiSourceElement(psiElement2);
    }

    @Nullable
    public static final AbstractKtSourceElement sourceElement(@NotNull IrElement $this$sourceElement) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceElement, (String)"<this>");
        return $this$sourceElement.getStartOffset() != -1 ? (AbstractKtSourceElement)new KtOffsetsOnlySourceElement($this$sourceElement.getStartOffset(), $this$sourceElement.getEndOffset()) : null;
    }
}

