/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.Stoppable;

public class ResolvedArtifactCaches
implements Stoppable {
    private static final Logger LOG = Logging.getLogger(ResolvedArtifactCaches.class);
    private final Map<String, Map<ComponentArtifactIdentifier, ResolvableArtifact>> cachePerRepo = new MapMaker().makeMap();
    private final Map<String, Map<ComponentArtifactIdentifier, ResolvableArtifact>> cachePerRepoWithVerification = new MapMaker().makeMap();

    public ModuleComponentRepository provideResolvedArtifactCache(ModuleComponentRepository input, boolean withVerification) {
        Map<ComponentArtifactIdentifier, ResolvableArtifact> caches = this.getResolvedArtifactCache(withVerification ? this.cachePerRepoWithVerification : this.cachePerRepo, input);
        return new ResolvedArtifactCacheProvidingModuleComponentRepository(caches, input);
    }

    private Map<ComponentArtifactIdentifier, ResolvableArtifact> getResolvedArtifactCache(Map<String, Map<ComponentArtifactIdentifier, ResolvableArtifact>> cache, ModuleComponentRepository input) {
        ConcurrentMap resolvedArtifactCache = cache.get(input.getId());
        if (resolvedArtifactCache == null) {
            LOG.debug("Creating new in-memory cache for repo '{}' [{}].", (Object)input.getName(), (Object)input.getId());
            resolvedArtifactCache = Maps.newConcurrentMap();
            cache.put(input.getId(), resolvedArtifactCache);
        } else {
            LOG.debug("Reusing in-memory cache for repo '{}' [{}].", (Object)input.getName(), (Object)input.getId());
        }
        return resolvedArtifactCache;
    }

    public void stop() {
        this.cachePerRepo.clear();
        this.cachePerRepoWithVerification.clear();
    }

    private static class ResolvedArtifactCacheProvidingModuleComponentRepository
    extends BaseModuleComponentRepository {
        private final Map<ComponentArtifactIdentifier, ResolvableArtifact> resolvedArtifactCache;

        public ResolvedArtifactCacheProvidingModuleComponentRepository(Map<ComponentArtifactIdentifier, ResolvableArtifact> resolvedArtifactsCache, ModuleComponentRepository delegate) {
            super(delegate);
            this.resolvedArtifactCache = resolvedArtifactsCache;
        }

        @Override
        public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
            return this.resolvedArtifactCache;
        }
    }
}

