/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)", date = "2016-10-21")
public class AuroraSchedulerManager {

  public interface Iface extends ReadOnlyScheduler.Iface {

    /**
     * Creates a new job.  The request will be denied if a job with the provided name already exists
     * in the cluster.
     * 
     * @param description
     */
    public Response createJob(JobConfiguration description) throws org.apache.thrift.TException;

    /**
     * Enters a job into the cron schedule, without actually starting the job.
     * If the job is already present in the schedule, this will update the schedule entry with the new
     * configuration.
     * 
     * @param description
     */
    public Response scheduleCronJob(JobConfiguration description) throws org.apache.thrift.TException;

    /**
     * Removes a job from the cron schedule. The request will be denied if the job was not previously
     * scheduled with scheduleCronJob.
     * 
     * @param job
     */
    public Response descheduleCronJob(JobKey job) throws org.apache.thrift.TException;

    /**
     * Starts a cron job immediately.  The request will be denied if the specified job does not
     * exist for the role account, or the job is not a cron job.
     * 
     * @param job
     */
    public Response startCronJob(JobKey job) throws org.apache.thrift.TException;

    /**
     * Restarts a batch of shards.
     * 
     * @param job
     * @param shardIds
     */
    public Response restartShards(JobKey job, Set<Integer> shardIds) throws org.apache.thrift.TException;

    /**
     * Initiates a kill on tasks.
     * 
     * @param job
     * @param instances
     */
    public Response killTasks(JobKey job, Set<Integer> instances) throws org.apache.thrift.TException;

    /**
     * Adds new instances with the TaskConfig of the existing instance pointed by the key.
     * 
     * @param key
     * @param count
     */
    public Response addInstances(InstanceKey key, int count) throws org.apache.thrift.TException;

    /**
     * Replaces the template (configuration) for the existing cron job.
     * The cron job template (configuration) must exist for the call to succeed.
     * 
     * @param config
     */
    public Response replaceCronTemplate(JobConfiguration config) throws org.apache.thrift.TException;

    /**
     * Starts update of the existing service job.
     * 
     * @param request A description of how to change the job.
     * 
     * @param message A user-specified message to include with the induced job update state change.
     */
    public Response startJobUpdate(JobUpdateRequest request, String message) throws org.apache.thrift.TException;

    /**
     * Pauses the specified job update. Can be resumed by resumeUpdate call.
     * 
     * @param key The update to pause.
     * 
     * @param message A user-specified message to include with the induced job update state change.
     */
    public Response pauseJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException;

    /**
     * Resumes progress of a previously paused job update.
     * 
     * @param key The update to resume.
     * 
     * @param message A user-specified message to include with the induced job update state change.
     */
    public Response resumeJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException;

    /**
     * Permanently aborts the job update. Does not remove the update history.
     * 
     * @param key The update to abort.
     * 
     * @param message A user-specified message to include with the induced job update state change.
     */
    public Response abortJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException;

    /**
     * Rollbacks the specified active job update to the initial state.
     * 
     * @param key The update to rollback.
     * 
     * @param message A user-specified message to include with the induced job update state change.
     */
    public Response rollbackJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException;

    /**
     * Allows progress of the job update in case blockIfNoPulsesAfterMs is specified in
     * JobUpdateSettings. Unblocks progress if the update was previously blocked.
     * Responds with ResponseCode.INVALID_REQUEST in case an unknown update key is specified.
     * 
     * @param key
     */
    public Response pulseJobUpdate(JobUpdateKey key) throws org.apache.thrift.TException;

  }

  public interface AsyncIface extends ReadOnlyScheduler .AsyncIface {

    public void createJob(JobConfiguration description, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void scheduleCronJob(JobConfiguration description, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void descheduleCronJob(JobKey job, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void startCronJob(JobKey job, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void restartShards(JobKey job, Set<Integer> shardIds, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void killTasks(JobKey job, Set<Integer> instances, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addInstances(InstanceKey key, int count, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void replaceCronTemplate(JobConfiguration config, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void startJobUpdate(JobUpdateRequest request, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void pauseJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void resumeJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void abortJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void rollbackJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void pulseJobUpdate(JobUpdateKey key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends ReadOnlyScheduler.Client implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public Response createJob(JobConfiguration description) throws org.apache.thrift.TException
    {
      send_createJob(description);
      return recv_createJob();
    }

    public void send_createJob(JobConfiguration description) throws org.apache.thrift.TException
    {
      createJob_args args = new createJob_args();
      args.setDescription(description);
      sendBase("createJob", args);
    }

    public Response recv_createJob() throws org.apache.thrift.TException
    {
      createJob_result result = new createJob_result();
      receiveBase(result, "createJob");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createJob failed: unknown result");
    }

    public Response scheduleCronJob(JobConfiguration description) throws org.apache.thrift.TException
    {
      send_scheduleCronJob(description);
      return recv_scheduleCronJob();
    }

    public void send_scheduleCronJob(JobConfiguration description) throws org.apache.thrift.TException
    {
      scheduleCronJob_args args = new scheduleCronJob_args();
      args.setDescription(description);
      sendBase("scheduleCronJob", args);
    }

    public Response recv_scheduleCronJob() throws org.apache.thrift.TException
    {
      scheduleCronJob_result result = new scheduleCronJob_result();
      receiveBase(result, "scheduleCronJob");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scheduleCronJob failed: unknown result");
    }

    public Response descheduleCronJob(JobKey job) throws org.apache.thrift.TException
    {
      send_descheduleCronJob(job);
      return recv_descheduleCronJob();
    }

    public void send_descheduleCronJob(JobKey job) throws org.apache.thrift.TException
    {
      descheduleCronJob_args args = new descheduleCronJob_args();
      args.setJob(job);
      sendBase("descheduleCronJob", args);
    }

    public Response recv_descheduleCronJob() throws org.apache.thrift.TException
    {
      descheduleCronJob_result result = new descheduleCronJob_result();
      receiveBase(result, "descheduleCronJob");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "descheduleCronJob failed: unknown result");
    }

    public Response startCronJob(JobKey job) throws org.apache.thrift.TException
    {
      send_startCronJob(job);
      return recv_startCronJob();
    }

    public void send_startCronJob(JobKey job) throws org.apache.thrift.TException
    {
      startCronJob_args args = new startCronJob_args();
      args.setJob(job);
      sendBase("startCronJob", args);
    }

    public Response recv_startCronJob() throws org.apache.thrift.TException
    {
      startCronJob_result result = new startCronJob_result();
      receiveBase(result, "startCronJob");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startCronJob failed: unknown result");
    }

    public Response restartShards(JobKey job, Set<Integer> shardIds) throws org.apache.thrift.TException
    {
      send_restartShards(job, shardIds);
      return recv_restartShards();
    }

    public void send_restartShards(JobKey job, Set<Integer> shardIds) throws org.apache.thrift.TException
    {
      restartShards_args args = new restartShards_args();
      args.setJob(job);
      args.setShardIds(shardIds);
      sendBase("restartShards", args);
    }

    public Response recv_restartShards() throws org.apache.thrift.TException
    {
      restartShards_result result = new restartShards_result();
      receiveBase(result, "restartShards");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "restartShards failed: unknown result");
    }

    public Response killTasks(JobKey job, Set<Integer> instances) throws org.apache.thrift.TException
    {
      send_killTasks(job, instances);
      return recv_killTasks();
    }

    public void send_killTasks(JobKey job, Set<Integer> instances) throws org.apache.thrift.TException
    {
      killTasks_args args = new killTasks_args();
      args.setJob(job);
      args.setInstances(instances);
      sendBase("killTasks", args);
    }

    public Response recv_killTasks() throws org.apache.thrift.TException
    {
      killTasks_result result = new killTasks_result();
      receiveBase(result, "killTasks");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "killTasks failed: unknown result");
    }

    public Response addInstances(InstanceKey key, int count) throws org.apache.thrift.TException
    {
      send_addInstances(key, count);
      return recv_addInstances();
    }

    public void send_addInstances(InstanceKey key, int count) throws org.apache.thrift.TException
    {
      addInstances_args args = new addInstances_args();
      args.setKey(key);
      args.setCount(count);
      sendBase("addInstances", args);
    }

    public Response recv_addInstances() throws org.apache.thrift.TException
    {
      addInstances_result result = new addInstances_result();
      receiveBase(result, "addInstances");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addInstances failed: unknown result");
    }

    public Response replaceCronTemplate(JobConfiguration config) throws org.apache.thrift.TException
    {
      send_replaceCronTemplate(config);
      return recv_replaceCronTemplate();
    }

    public void send_replaceCronTemplate(JobConfiguration config) throws org.apache.thrift.TException
    {
      replaceCronTemplate_args args = new replaceCronTemplate_args();
      args.setConfig(config);
      sendBase("replaceCronTemplate", args);
    }

    public Response recv_replaceCronTemplate() throws org.apache.thrift.TException
    {
      replaceCronTemplate_result result = new replaceCronTemplate_result();
      receiveBase(result, "replaceCronTemplate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "replaceCronTemplate failed: unknown result");
    }

    public Response startJobUpdate(JobUpdateRequest request, String message) throws org.apache.thrift.TException
    {
      send_startJobUpdate(request, message);
      return recv_startJobUpdate();
    }

    public void send_startJobUpdate(JobUpdateRequest request, String message) throws org.apache.thrift.TException
    {
      startJobUpdate_args args = new startJobUpdate_args();
      args.setRequest(request);
      args.setMessage(message);
      sendBase("startJobUpdate", args);
    }

    public Response recv_startJobUpdate() throws org.apache.thrift.TException
    {
      startJobUpdate_result result = new startJobUpdate_result();
      receiveBase(result, "startJobUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startJobUpdate failed: unknown result");
    }

    public Response pauseJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      send_pauseJobUpdate(key, message);
      return recv_pauseJobUpdate();
    }

    public void send_pauseJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      pauseJobUpdate_args args = new pauseJobUpdate_args();
      args.setKey(key);
      args.setMessage(message);
      sendBase("pauseJobUpdate", args);
    }

    public Response recv_pauseJobUpdate() throws org.apache.thrift.TException
    {
      pauseJobUpdate_result result = new pauseJobUpdate_result();
      receiveBase(result, "pauseJobUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "pauseJobUpdate failed: unknown result");
    }

    public Response resumeJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      send_resumeJobUpdate(key, message);
      return recv_resumeJobUpdate();
    }

    public void send_resumeJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      resumeJobUpdate_args args = new resumeJobUpdate_args();
      args.setKey(key);
      args.setMessage(message);
      sendBase("resumeJobUpdate", args);
    }

    public Response recv_resumeJobUpdate() throws org.apache.thrift.TException
    {
      resumeJobUpdate_result result = new resumeJobUpdate_result();
      receiveBase(result, "resumeJobUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "resumeJobUpdate failed: unknown result");
    }

    public Response abortJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      send_abortJobUpdate(key, message);
      return recv_abortJobUpdate();
    }

    public void send_abortJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      abortJobUpdate_args args = new abortJobUpdate_args();
      args.setKey(key);
      args.setMessage(message);
      sendBase("abortJobUpdate", args);
    }

    public Response recv_abortJobUpdate() throws org.apache.thrift.TException
    {
      abortJobUpdate_result result = new abortJobUpdate_result();
      receiveBase(result, "abortJobUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "abortJobUpdate failed: unknown result");
    }

    public Response rollbackJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      send_rollbackJobUpdate(key, message);
      return recv_rollbackJobUpdate();
    }

    public void send_rollbackJobUpdate(JobUpdateKey key, String message) throws org.apache.thrift.TException
    {
      rollbackJobUpdate_args args = new rollbackJobUpdate_args();
      args.setKey(key);
      args.setMessage(message);
      sendBase("rollbackJobUpdate", args);
    }

    public Response recv_rollbackJobUpdate() throws org.apache.thrift.TException
    {
      rollbackJobUpdate_result result = new rollbackJobUpdate_result();
      receiveBase(result, "rollbackJobUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "rollbackJobUpdate failed: unknown result");
    }

    public Response pulseJobUpdate(JobUpdateKey key) throws org.apache.thrift.TException
    {
      send_pulseJobUpdate(key);
      return recv_pulseJobUpdate();
    }

    public void send_pulseJobUpdate(JobUpdateKey key) throws org.apache.thrift.TException
    {
      pulseJobUpdate_args args = new pulseJobUpdate_args();
      args.setKey(key);
      sendBase("pulseJobUpdate", args);
    }

    public Response recv_pulseJobUpdate() throws org.apache.thrift.TException
    {
      pulseJobUpdate_result result = new pulseJobUpdate_result();
      receiveBase(result, "pulseJobUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "pulseJobUpdate failed: unknown result");
    }

  }
  public static class AsyncClient extends ReadOnlyScheduler.AsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void createJob(JobConfiguration description, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createJob_call method_call = new createJob_call(description, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createJob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobConfiguration description;
      public createJob_call(JobConfiguration description, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.description = description;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createJob_args args = new createJob_args();
        args.setDescription(description);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createJob();
      }
    }

    public void scheduleCronJob(JobConfiguration description, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scheduleCronJob_call method_call = new scheduleCronJob_call(description, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scheduleCronJob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobConfiguration description;
      public scheduleCronJob_call(JobConfiguration description, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.description = description;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scheduleCronJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scheduleCronJob_args args = new scheduleCronJob_args();
        args.setDescription(description);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scheduleCronJob();
      }
    }

    public void descheduleCronJob(JobKey job, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      descheduleCronJob_call method_call = new descheduleCronJob_call(job, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class descheduleCronJob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobKey job;
      public descheduleCronJob_call(JobKey job, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.job = job;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("descheduleCronJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        descheduleCronJob_args args = new descheduleCronJob_args();
        args.setJob(job);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_descheduleCronJob();
      }
    }

    public void startCronJob(JobKey job, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startCronJob_call method_call = new startCronJob_call(job, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startCronJob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobKey job;
      public startCronJob_call(JobKey job, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.job = job;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startCronJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startCronJob_args args = new startCronJob_args();
        args.setJob(job);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startCronJob();
      }
    }

    public void restartShards(JobKey job, Set<Integer> shardIds, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      restartShards_call method_call = new restartShards_call(job, shardIds, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class restartShards_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobKey job;
      private Set<Integer> shardIds;
      public restartShards_call(JobKey job, Set<Integer> shardIds, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.job = job;
        this.shardIds = shardIds;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("restartShards", org.apache.thrift.protocol.TMessageType.CALL, 0));
        restartShards_args args = new restartShards_args();
        args.setJob(job);
        args.setShardIds(shardIds);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_restartShards();
      }
    }

    public void killTasks(JobKey job, Set<Integer> instances, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      killTasks_call method_call = new killTasks_call(job, instances, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class killTasks_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobKey job;
      private Set<Integer> instances;
      public killTasks_call(JobKey job, Set<Integer> instances, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.job = job;
        this.instances = instances;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("killTasks", org.apache.thrift.protocol.TMessageType.CALL, 0));
        killTasks_args args = new killTasks_args();
        args.setJob(job);
        args.setInstances(instances);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_killTasks();
      }
    }

    public void addInstances(InstanceKey key, int count, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addInstances_call method_call = new addInstances_call(key, count, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addInstances_call extends org.apache.thrift.async.TAsyncMethodCall {
      private InstanceKey key;
      private int count;
      public addInstances_call(InstanceKey key, int count, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.count = count;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addInstances", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addInstances_args args = new addInstances_args();
        args.setKey(key);
        args.setCount(count);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addInstances();
      }
    }

    public void replaceCronTemplate(JobConfiguration config, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      replaceCronTemplate_call method_call = new replaceCronTemplate_call(config, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class replaceCronTemplate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobConfiguration config;
      public replaceCronTemplate_call(JobConfiguration config, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.config = config;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("replaceCronTemplate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        replaceCronTemplate_args args = new replaceCronTemplate_args();
        args.setConfig(config);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_replaceCronTemplate();
      }
    }

    public void startJobUpdate(JobUpdateRequest request, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startJobUpdate_call method_call = new startJobUpdate_call(request, message, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startJobUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobUpdateRequest request;
      private String message;
      public startJobUpdate_call(JobUpdateRequest request, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.request = request;
        this.message = message;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startJobUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startJobUpdate_args args = new startJobUpdate_args();
        args.setRequest(request);
        args.setMessage(message);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startJobUpdate();
      }
    }

    public void pauseJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      pauseJobUpdate_call method_call = new pauseJobUpdate_call(key, message, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class pauseJobUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobUpdateKey key;
      private String message;
      public pauseJobUpdate_call(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.message = message;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("pauseJobUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        pauseJobUpdate_args args = new pauseJobUpdate_args();
        args.setKey(key);
        args.setMessage(message);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_pauseJobUpdate();
      }
    }

    public void resumeJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      resumeJobUpdate_call method_call = new resumeJobUpdate_call(key, message, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class resumeJobUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobUpdateKey key;
      private String message;
      public resumeJobUpdate_call(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.message = message;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resumeJobUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        resumeJobUpdate_args args = new resumeJobUpdate_args();
        args.setKey(key);
        args.setMessage(message);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_resumeJobUpdate();
      }
    }

    public void abortJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      abortJobUpdate_call method_call = new abortJobUpdate_call(key, message, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class abortJobUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobUpdateKey key;
      private String message;
      public abortJobUpdate_call(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.message = message;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("abortJobUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        abortJobUpdate_args args = new abortJobUpdate_args();
        args.setKey(key);
        args.setMessage(message);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_abortJobUpdate();
      }
    }

    public void rollbackJobUpdate(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      rollbackJobUpdate_call method_call = new rollbackJobUpdate_call(key, message, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class rollbackJobUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobUpdateKey key;
      private String message;
      public rollbackJobUpdate_call(JobUpdateKey key, String message, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.message = message;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("rollbackJobUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        rollbackJobUpdate_args args = new rollbackJobUpdate_args();
        args.setKey(key);
        args.setMessage(message);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_rollbackJobUpdate();
      }
    }

    public void pulseJobUpdate(JobUpdateKey key, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      pulseJobUpdate_call method_call = new pulseJobUpdate_call(key, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class pulseJobUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private JobUpdateKey key;
      public pulseJobUpdate_call(JobUpdateKey key, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("pulseJobUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        pulseJobUpdate_args args = new pulseJobUpdate_args();
        args.setKey(key);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Response getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_pulseJobUpdate();
      }
    }

  }

  public static class Processor<I extends Iface> extends ReadOnlyScheduler.Processor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("createJob", new createJob());
      processMap.put("scheduleCronJob", new scheduleCronJob());
      processMap.put("descheduleCronJob", new descheduleCronJob());
      processMap.put("startCronJob", new startCronJob());
      processMap.put("restartShards", new restartShards());
      processMap.put("killTasks", new killTasks());
      processMap.put("addInstances", new addInstances());
      processMap.put("replaceCronTemplate", new replaceCronTemplate());
      processMap.put("startJobUpdate", new startJobUpdate());
      processMap.put("pauseJobUpdate", new pauseJobUpdate());
      processMap.put("resumeJobUpdate", new resumeJobUpdate());
      processMap.put("abortJobUpdate", new abortJobUpdate());
      processMap.put("rollbackJobUpdate", new rollbackJobUpdate());
      processMap.put("pulseJobUpdate", new pulseJobUpdate());
      return processMap;
    }

    public static class createJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createJob_args> {
      public createJob() {
        super("createJob");
      }

      public createJob_args getEmptyArgsInstance() {
        return new createJob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createJob_result getResult(I iface, createJob_args args) throws org.apache.thrift.TException {
        createJob_result result = new createJob_result();
        result.success = iface.createJob(args.description);
        return result;
      }
    }

    public static class scheduleCronJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scheduleCronJob_args> {
      public scheduleCronJob() {
        super("scheduleCronJob");
      }

      public scheduleCronJob_args getEmptyArgsInstance() {
        return new scheduleCronJob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scheduleCronJob_result getResult(I iface, scheduleCronJob_args args) throws org.apache.thrift.TException {
        scheduleCronJob_result result = new scheduleCronJob_result();
        result.success = iface.scheduleCronJob(args.description);
        return result;
      }
    }

    public static class descheduleCronJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, descheduleCronJob_args> {
      public descheduleCronJob() {
        super("descheduleCronJob");
      }

      public descheduleCronJob_args getEmptyArgsInstance() {
        return new descheduleCronJob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public descheduleCronJob_result getResult(I iface, descheduleCronJob_args args) throws org.apache.thrift.TException {
        descheduleCronJob_result result = new descheduleCronJob_result();
        result.success = iface.descheduleCronJob(args.job);
        return result;
      }
    }

    public static class startCronJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startCronJob_args> {
      public startCronJob() {
        super("startCronJob");
      }

      public startCronJob_args getEmptyArgsInstance() {
        return new startCronJob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startCronJob_result getResult(I iface, startCronJob_args args) throws org.apache.thrift.TException {
        startCronJob_result result = new startCronJob_result();
        result.success = iface.startCronJob(args.job);
        return result;
      }
    }

    public static class restartShards<I extends Iface> extends org.apache.thrift.ProcessFunction<I, restartShards_args> {
      public restartShards() {
        super("restartShards");
      }

      public restartShards_args getEmptyArgsInstance() {
        return new restartShards_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public restartShards_result getResult(I iface, restartShards_args args) throws org.apache.thrift.TException {
        restartShards_result result = new restartShards_result();
        result.success = iface.restartShards(args.job, args.shardIds);
        return result;
      }
    }

    public static class killTasks<I extends Iface> extends org.apache.thrift.ProcessFunction<I, killTasks_args> {
      public killTasks() {
        super("killTasks");
      }

      public killTasks_args getEmptyArgsInstance() {
        return new killTasks_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public killTasks_result getResult(I iface, killTasks_args args) throws org.apache.thrift.TException {
        killTasks_result result = new killTasks_result();
        result.success = iface.killTasks(args.job, args.instances);
        return result;
      }
    }

    public static class addInstances<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addInstances_args> {
      public addInstances() {
        super("addInstances");
      }

      public addInstances_args getEmptyArgsInstance() {
        return new addInstances_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addInstances_result getResult(I iface, addInstances_args args) throws org.apache.thrift.TException {
        addInstances_result result = new addInstances_result();
        result.success = iface.addInstances(args.key, args.count);
        return result;
      }
    }

    public static class replaceCronTemplate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, replaceCronTemplate_args> {
      public replaceCronTemplate() {
        super("replaceCronTemplate");
      }

      public replaceCronTemplate_args getEmptyArgsInstance() {
        return new replaceCronTemplate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public replaceCronTemplate_result getResult(I iface, replaceCronTemplate_args args) throws org.apache.thrift.TException {
        replaceCronTemplate_result result = new replaceCronTemplate_result();
        result.success = iface.replaceCronTemplate(args.config);
        return result;
      }
    }

    public static class startJobUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startJobUpdate_args> {
      public startJobUpdate() {
        super("startJobUpdate");
      }

      public startJobUpdate_args getEmptyArgsInstance() {
        return new startJobUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startJobUpdate_result getResult(I iface, startJobUpdate_args args) throws org.apache.thrift.TException {
        startJobUpdate_result result = new startJobUpdate_result();
        result.success = iface.startJobUpdate(args.request, args.message);
        return result;
      }
    }

    public static class pauseJobUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, pauseJobUpdate_args> {
      public pauseJobUpdate() {
        super("pauseJobUpdate");
      }

      public pauseJobUpdate_args getEmptyArgsInstance() {
        return new pauseJobUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public pauseJobUpdate_result getResult(I iface, pauseJobUpdate_args args) throws org.apache.thrift.TException {
        pauseJobUpdate_result result = new pauseJobUpdate_result();
        result.success = iface.pauseJobUpdate(args.key, args.message);
        return result;
      }
    }

    public static class resumeJobUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resumeJobUpdate_args> {
      public resumeJobUpdate() {
        super("resumeJobUpdate");
      }

      public resumeJobUpdate_args getEmptyArgsInstance() {
        return new resumeJobUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public resumeJobUpdate_result getResult(I iface, resumeJobUpdate_args args) throws org.apache.thrift.TException {
        resumeJobUpdate_result result = new resumeJobUpdate_result();
        result.success = iface.resumeJobUpdate(args.key, args.message);
        return result;
      }
    }

    public static class abortJobUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, abortJobUpdate_args> {
      public abortJobUpdate() {
        super("abortJobUpdate");
      }

      public abortJobUpdate_args getEmptyArgsInstance() {
        return new abortJobUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public abortJobUpdate_result getResult(I iface, abortJobUpdate_args args) throws org.apache.thrift.TException {
        abortJobUpdate_result result = new abortJobUpdate_result();
        result.success = iface.abortJobUpdate(args.key, args.message);
        return result;
      }
    }

    public static class rollbackJobUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, rollbackJobUpdate_args> {
      public rollbackJobUpdate() {
        super("rollbackJobUpdate");
      }

      public rollbackJobUpdate_args getEmptyArgsInstance() {
        return new rollbackJobUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public rollbackJobUpdate_result getResult(I iface, rollbackJobUpdate_args args) throws org.apache.thrift.TException {
        rollbackJobUpdate_result result = new rollbackJobUpdate_result();
        result.success = iface.rollbackJobUpdate(args.key, args.message);
        return result;
      }
    }

    public static class pulseJobUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, pulseJobUpdate_args> {
      public pulseJobUpdate() {
        super("pulseJobUpdate");
      }

      public pulseJobUpdate_args getEmptyArgsInstance() {
        return new pulseJobUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public pulseJobUpdate_result getResult(I iface, pulseJobUpdate_args args) throws org.apache.thrift.TException {
        pulseJobUpdate_result result = new pulseJobUpdate_result();
        result.success = iface.pulseJobUpdate(args.key);
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends ReadOnlyScheduler.AsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("createJob", new createJob());
      processMap.put("scheduleCronJob", new scheduleCronJob());
      processMap.put("descheduleCronJob", new descheduleCronJob());
      processMap.put("startCronJob", new startCronJob());
      processMap.put("restartShards", new restartShards());
      processMap.put("killTasks", new killTasks());
      processMap.put("addInstances", new addInstances());
      processMap.put("replaceCronTemplate", new replaceCronTemplate());
      processMap.put("startJobUpdate", new startJobUpdate());
      processMap.put("pauseJobUpdate", new pauseJobUpdate());
      processMap.put("resumeJobUpdate", new resumeJobUpdate());
      processMap.put("abortJobUpdate", new abortJobUpdate());
      processMap.put("rollbackJobUpdate", new rollbackJobUpdate());
      processMap.put("pulseJobUpdate", new pulseJobUpdate());
      return processMap;
    }

    public static class createJob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createJob_args, Response> {
      public createJob() {
        super("createJob");
      }

      public createJob_args getEmptyArgsInstance() {
        return new createJob_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            createJob_result result = new createJob_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createJob_result result = new createJob_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createJob_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.createJob(args.description,resultHandler);
      }
    }

    public static class scheduleCronJob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scheduleCronJob_args, Response> {
      public scheduleCronJob() {
        super("scheduleCronJob");
      }

      public scheduleCronJob_args getEmptyArgsInstance() {
        return new scheduleCronJob_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            scheduleCronJob_result result = new scheduleCronJob_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            scheduleCronJob_result result = new scheduleCronJob_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scheduleCronJob_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.scheduleCronJob(args.description,resultHandler);
      }
    }

    public static class descheduleCronJob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, descheduleCronJob_args, Response> {
      public descheduleCronJob() {
        super("descheduleCronJob");
      }

      public descheduleCronJob_args getEmptyArgsInstance() {
        return new descheduleCronJob_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            descheduleCronJob_result result = new descheduleCronJob_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            descheduleCronJob_result result = new descheduleCronJob_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, descheduleCronJob_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.descheduleCronJob(args.job,resultHandler);
      }
    }

    public static class startCronJob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startCronJob_args, Response> {
      public startCronJob() {
        super("startCronJob");
      }

      public startCronJob_args getEmptyArgsInstance() {
        return new startCronJob_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            startCronJob_result result = new startCronJob_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            startCronJob_result result = new startCronJob_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, startCronJob_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.startCronJob(args.job,resultHandler);
      }
    }

    public static class restartShards<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, restartShards_args, Response> {
      public restartShards() {
        super("restartShards");
      }

      public restartShards_args getEmptyArgsInstance() {
        return new restartShards_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            restartShards_result result = new restartShards_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            restartShards_result result = new restartShards_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, restartShards_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.restartShards(args.job, args.shardIds,resultHandler);
      }
    }

    public static class killTasks<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, killTasks_args, Response> {
      public killTasks() {
        super("killTasks");
      }

      public killTasks_args getEmptyArgsInstance() {
        return new killTasks_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            killTasks_result result = new killTasks_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            killTasks_result result = new killTasks_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, killTasks_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.killTasks(args.job, args.instances,resultHandler);
      }
    }

    public static class addInstances<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addInstances_args, Response> {
      public addInstances() {
        super("addInstances");
      }

      public addInstances_args getEmptyArgsInstance() {
        return new addInstances_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            addInstances_result result = new addInstances_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addInstances_result result = new addInstances_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addInstances_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.addInstances(args.key, args.count,resultHandler);
      }
    }

    public static class replaceCronTemplate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, replaceCronTemplate_args, Response> {
      public replaceCronTemplate() {
        super("replaceCronTemplate");
      }

      public replaceCronTemplate_args getEmptyArgsInstance() {
        return new replaceCronTemplate_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            replaceCronTemplate_result result = new replaceCronTemplate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            replaceCronTemplate_result result = new replaceCronTemplate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, replaceCronTemplate_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.replaceCronTemplate(args.config,resultHandler);
      }
    }

    public static class startJobUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startJobUpdate_args, Response> {
      public startJobUpdate() {
        super("startJobUpdate");
      }

      public startJobUpdate_args getEmptyArgsInstance() {
        return new startJobUpdate_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            startJobUpdate_result result = new startJobUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            startJobUpdate_result result = new startJobUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, startJobUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.startJobUpdate(args.request, args.message,resultHandler);
      }
    }

    public static class pauseJobUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, pauseJobUpdate_args, Response> {
      public pauseJobUpdate() {
        super("pauseJobUpdate");
      }

      public pauseJobUpdate_args getEmptyArgsInstance() {
        return new pauseJobUpdate_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            pauseJobUpdate_result result = new pauseJobUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            pauseJobUpdate_result result = new pauseJobUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, pauseJobUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.pauseJobUpdate(args.key, args.message,resultHandler);
      }
    }

    public static class resumeJobUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, resumeJobUpdate_args, Response> {
      public resumeJobUpdate() {
        super("resumeJobUpdate");
      }

      public resumeJobUpdate_args getEmptyArgsInstance() {
        return new resumeJobUpdate_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            resumeJobUpdate_result result = new resumeJobUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            resumeJobUpdate_result result = new resumeJobUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, resumeJobUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.resumeJobUpdate(args.key, args.message,resultHandler);
      }
    }

    public static class abortJobUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, abortJobUpdate_args, Response> {
      public abortJobUpdate() {
        super("abortJobUpdate");
      }

      public abortJobUpdate_args getEmptyArgsInstance() {
        return new abortJobUpdate_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            abortJobUpdate_result result = new abortJobUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            abortJobUpdate_result result = new abortJobUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, abortJobUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.abortJobUpdate(args.key, args.message,resultHandler);
      }
    }

    public static class rollbackJobUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, rollbackJobUpdate_args, Response> {
      public rollbackJobUpdate() {
        super("rollbackJobUpdate");
      }

      public rollbackJobUpdate_args getEmptyArgsInstance() {
        return new rollbackJobUpdate_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            rollbackJobUpdate_result result = new rollbackJobUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            rollbackJobUpdate_result result = new rollbackJobUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, rollbackJobUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.rollbackJobUpdate(args.key, args.message,resultHandler);
      }
    }

    public static class pulseJobUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, pulseJobUpdate_args, Response> {
      public pulseJobUpdate() {
        super("pulseJobUpdate");
      }

      public pulseJobUpdate_args getEmptyArgsInstance() {
        return new pulseJobUpdate_args();
      }

      public AsyncMethodCallback<Response> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Response>() { 
          public void onComplete(Response o) {
            pulseJobUpdate_result result = new pulseJobUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            pulseJobUpdate_result result = new pulseJobUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, pulseJobUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Response> resultHandler) throws TException {
        iface.pulseJobUpdate(args.key,resultHandler);
      }
    }

  }

  public static class createJob_args implements org.apache.thrift.TBase<createJob_args, createJob_args._Fields>, java.io.Serializable, Cloneable, Comparable<createJob_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createJob_args");

    private static final org.apache.thrift.protocol.TField DESCRIPTION_FIELD_DESC = new org.apache.thrift.protocol.TField("description", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createJob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createJob_argsTupleSchemeFactory());
    }

    public JobConfiguration description; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DESCRIPTION((short)1, "description");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DESCRIPTION
            return DESCRIPTION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DESCRIPTION, new org.apache.thrift.meta_data.FieldMetaData("description", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobConfiguration.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createJob_args.class, metaDataMap);
    }

    public createJob_args() {
    }

    public createJob_args(
      JobConfiguration description)
    {
      this();
      this.description = description;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createJob_args(createJob_args other) {
      if (other.isSetDescription()) {
        this.description = new JobConfiguration(other.description);
      }
    }

    public createJob_args deepCopy() {
      return new createJob_args(this);
    }

    @Override
    public void clear() {
      this.description = null;
    }

    public JobConfiguration getDescription() {
      return this.description;
    }

    public createJob_args setDescription(JobConfiguration description) {
      this.description = description;
      return this;
    }

    public void unsetDescription() {
      this.description = null;
    }

    /** Returns true if field description is set (has been assigned a value) and false otherwise */
    public boolean isSetDescription() {
      return this.description != null;
    }

    public void setDescriptionIsSet(boolean value) {
      if (!value) {
        this.description = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DESCRIPTION:
        if (value == null) {
          unsetDescription();
        } else {
          setDescription((JobConfiguration)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DESCRIPTION:
        return getDescription();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DESCRIPTION:
        return isSetDescription();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createJob_args)
        return this.equals((createJob_args)that);
      return false;
    }

    public boolean equals(createJob_args that) {
      if (that == null)
        return false;

      boolean this_present_description = true && this.isSetDescription();
      boolean that_present_description = true && that.isSetDescription();
      if (this_present_description || that_present_description) {
        if (!(this_present_description && that_present_description))
          return false;
        if (!this.description.equals(that.description))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_description = true && (isSetDescription());
      list.add(present_description);
      if (present_description)
        list.add(description);

      return list.hashCode();
    }

    @Override
    public int compareTo(createJob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDescription()).compareTo(other.isSetDescription());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDescription()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.description, other.description);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createJob_args(");
      boolean first = true;

      sb.append("description:");
      if (this.description == null) {
        sb.append("null");
      } else {
        sb.append(this.description);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (description != null) {
        description.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createJob_argsStandardSchemeFactory implements SchemeFactory {
      public createJob_argsStandardScheme getScheme() {
        return new createJob_argsStandardScheme();
      }
    }

    private static class createJob_argsStandardScheme extends StandardScheme<createJob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createJob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DESCRIPTION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.description = new JobConfiguration();
                struct.description.read(iprot);
                struct.setDescriptionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createJob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.description != null) {
          oprot.writeFieldBegin(DESCRIPTION_FIELD_DESC);
          struct.description.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createJob_argsTupleSchemeFactory implements SchemeFactory {
      public createJob_argsTupleScheme getScheme() {
        return new createJob_argsTupleScheme();
      }
    }

    private static class createJob_argsTupleScheme extends TupleScheme<createJob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetDescription()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetDescription()) {
          struct.description.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.description = new JobConfiguration();
          struct.description.read(iprot);
          struct.setDescriptionIsSet(true);
        }
      }
    }

  }

  public static class createJob_result implements org.apache.thrift.TBase<createJob_result, createJob_result._Fields>, java.io.Serializable, Cloneable, Comparable<createJob_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createJob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createJob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createJob_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createJob_result.class, metaDataMap);
    }

    public createJob_result() {
    }

    public createJob_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createJob_result(createJob_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public createJob_result deepCopy() {
      return new createJob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public createJob_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createJob_result)
        return this.equals((createJob_result)that);
      return false;
    }

    public boolean equals(createJob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(createJob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createJob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createJob_resultStandardSchemeFactory implements SchemeFactory {
      public createJob_resultStandardScheme getScheme() {
        return new createJob_resultStandardScheme();
      }
    }

    private static class createJob_resultStandardScheme extends StandardScheme<createJob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createJob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createJob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createJob_resultTupleSchemeFactory implements SchemeFactory {
      public createJob_resultTupleScheme getScheme() {
        return new createJob_resultTupleScheme();
      }
    }

    private static class createJob_resultTupleScheme extends TupleScheme<createJob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class scheduleCronJob_args implements org.apache.thrift.TBase<scheduleCronJob_args, scheduleCronJob_args._Fields>, java.io.Serializable, Cloneable, Comparable<scheduleCronJob_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("scheduleCronJob_args");

    private static final org.apache.thrift.protocol.TField DESCRIPTION_FIELD_DESC = new org.apache.thrift.protocol.TField("description", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new scheduleCronJob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new scheduleCronJob_argsTupleSchemeFactory());
    }

    public JobConfiguration description; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DESCRIPTION((short)1, "description");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DESCRIPTION
            return DESCRIPTION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DESCRIPTION, new org.apache.thrift.meta_data.FieldMetaData("description", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobConfiguration.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(scheduleCronJob_args.class, metaDataMap);
    }

    public scheduleCronJob_args() {
    }

    public scheduleCronJob_args(
      JobConfiguration description)
    {
      this();
      this.description = description;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public scheduleCronJob_args(scheduleCronJob_args other) {
      if (other.isSetDescription()) {
        this.description = new JobConfiguration(other.description);
      }
    }

    public scheduleCronJob_args deepCopy() {
      return new scheduleCronJob_args(this);
    }

    @Override
    public void clear() {
      this.description = null;
    }

    public JobConfiguration getDescription() {
      return this.description;
    }

    public scheduleCronJob_args setDescription(JobConfiguration description) {
      this.description = description;
      return this;
    }

    public void unsetDescription() {
      this.description = null;
    }

    /** Returns true if field description is set (has been assigned a value) and false otherwise */
    public boolean isSetDescription() {
      return this.description != null;
    }

    public void setDescriptionIsSet(boolean value) {
      if (!value) {
        this.description = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DESCRIPTION:
        if (value == null) {
          unsetDescription();
        } else {
          setDescription((JobConfiguration)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DESCRIPTION:
        return getDescription();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DESCRIPTION:
        return isSetDescription();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scheduleCronJob_args)
        return this.equals((scheduleCronJob_args)that);
      return false;
    }

    public boolean equals(scheduleCronJob_args that) {
      if (that == null)
        return false;

      boolean this_present_description = true && this.isSetDescription();
      boolean that_present_description = true && that.isSetDescription();
      if (this_present_description || that_present_description) {
        if (!(this_present_description && that_present_description))
          return false;
        if (!this.description.equals(that.description))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_description = true && (isSetDescription());
      list.add(present_description);
      if (present_description)
        list.add(description);

      return list.hashCode();
    }

    @Override
    public int compareTo(scheduleCronJob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDescription()).compareTo(other.isSetDescription());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDescription()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.description, other.description);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("scheduleCronJob_args(");
      boolean first = true;

      sb.append("description:");
      if (this.description == null) {
        sb.append("null");
      } else {
        sb.append(this.description);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (description != null) {
        description.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class scheduleCronJob_argsStandardSchemeFactory implements SchemeFactory {
      public scheduleCronJob_argsStandardScheme getScheme() {
        return new scheduleCronJob_argsStandardScheme();
      }
    }

    private static class scheduleCronJob_argsStandardScheme extends StandardScheme<scheduleCronJob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, scheduleCronJob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DESCRIPTION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.description = new JobConfiguration();
                struct.description.read(iprot);
                struct.setDescriptionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, scheduleCronJob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.description != null) {
          oprot.writeFieldBegin(DESCRIPTION_FIELD_DESC);
          struct.description.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class scheduleCronJob_argsTupleSchemeFactory implements SchemeFactory {
      public scheduleCronJob_argsTupleScheme getScheme() {
        return new scheduleCronJob_argsTupleScheme();
      }
    }

    private static class scheduleCronJob_argsTupleScheme extends TupleScheme<scheduleCronJob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, scheduleCronJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetDescription()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetDescription()) {
          struct.description.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, scheduleCronJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.description = new JobConfiguration();
          struct.description.read(iprot);
          struct.setDescriptionIsSet(true);
        }
      }
    }

  }

  public static class scheduleCronJob_result implements org.apache.thrift.TBase<scheduleCronJob_result, scheduleCronJob_result._Fields>, java.io.Serializable, Cloneable, Comparable<scheduleCronJob_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("scheduleCronJob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new scheduleCronJob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new scheduleCronJob_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(scheduleCronJob_result.class, metaDataMap);
    }

    public scheduleCronJob_result() {
    }

    public scheduleCronJob_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public scheduleCronJob_result(scheduleCronJob_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public scheduleCronJob_result deepCopy() {
      return new scheduleCronJob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public scheduleCronJob_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scheduleCronJob_result)
        return this.equals((scheduleCronJob_result)that);
      return false;
    }

    public boolean equals(scheduleCronJob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(scheduleCronJob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("scheduleCronJob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class scheduleCronJob_resultStandardSchemeFactory implements SchemeFactory {
      public scheduleCronJob_resultStandardScheme getScheme() {
        return new scheduleCronJob_resultStandardScheme();
      }
    }

    private static class scheduleCronJob_resultStandardScheme extends StandardScheme<scheduleCronJob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, scheduleCronJob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, scheduleCronJob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class scheduleCronJob_resultTupleSchemeFactory implements SchemeFactory {
      public scheduleCronJob_resultTupleScheme getScheme() {
        return new scheduleCronJob_resultTupleScheme();
      }
    }

    private static class scheduleCronJob_resultTupleScheme extends TupleScheme<scheduleCronJob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, scheduleCronJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, scheduleCronJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class descheduleCronJob_args implements org.apache.thrift.TBase<descheduleCronJob_args, descheduleCronJob_args._Fields>, java.io.Serializable, Cloneable, Comparable<descheduleCronJob_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("descheduleCronJob_args");

    private static final org.apache.thrift.protocol.TField JOB_FIELD_DESC = new org.apache.thrift.protocol.TField("job", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new descheduleCronJob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new descheduleCronJob_argsTupleSchemeFactory());
    }

    public JobKey job; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      JOB((short)4, "job");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // JOB
            return JOB;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.JOB, new org.apache.thrift.meta_data.FieldMetaData("job", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobKey.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(descheduleCronJob_args.class, metaDataMap);
    }

    public descheduleCronJob_args() {
    }

    public descheduleCronJob_args(
      JobKey job)
    {
      this();
      this.job = job;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public descheduleCronJob_args(descheduleCronJob_args other) {
      if (other.isSetJob()) {
        this.job = new JobKey(other.job);
      }
    }

    public descheduleCronJob_args deepCopy() {
      return new descheduleCronJob_args(this);
    }

    @Override
    public void clear() {
      this.job = null;
    }

    public JobKey getJob() {
      return this.job;
    }

    public descheduleCronJob_args setJob(JobKey job) {
      this.job = job;
      return this;
    }

    public void unsetJob() {
      this.job = null;
    }

    /** Returns true if field job is set (has been assigned a value) and false otherwise */
    public boolean isSetJob() {
      return this.job != null;
    }

    public void setJobIsSet(boolean value) {
      if (!value) {
        this.job = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case JOB:
        if (value == null) {
          unsetJob();
        } else {
          setJob((JobKey)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case JOB:
        return getJob();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case JOB:
        return isSetJob();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof descheduleCronJob_args)
        return this.equals((descheduleCronJob_args)that);
      return false;
    }

    public boolean equals(descheduleCronJob_args that) {
      if (that == null)
        return false;

      boolean this_present_job = true && this.isSetJob();
      boolean that_present_job = true && that.isSetJob();
      if (this_present_job || that_present_job) {
        if (!(this_present_job && that_present_job))
          return false;
        if (!this.job.equals(that.job))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_job = true && (isSetJob());
      list.add(present_job);
      if (present_job)
        list.add(job);

      return list.hashCode();
    }

    @Override
    public int compareTo(descheduleCronJob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetJob()).compareTo(other.isSetJob());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJob()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.job, other.job);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("descheduleCronJob_args(");
      boolean first = true;

      sb.append("job:");
      if (this.job == null) {
        sb.append("null");
      } else {
        sb.append(this.job);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (job != null) {
        job.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class descheduleCronJob_argsStandardSchemeFactory implements SchemeFactory {
      public descheduleCronJob_argsStandardScheme getScheme() {
        return new descheduleCronJob_argsStandardScheme();
      }
    }

    private static class descheduleCronJob_argsStandardScheme extends StandardScheme<descheduleCronJob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, descheduleCronJob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // JOB
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.job = new JobKey();
                struct.job.read(iprot);
                struct.setJobIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, descheduleCronJob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.job != null) {
          oprot.writeFieldBegin(JOB_FIELD_DESC);
          struct.job.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class descheduleCronJob_argsTupleSchemeFactory implements SchemeFactory {
      public descheduleCronJob_argsTupleScheme getScheme() {
        return new descheduleCronJob_argsTupleScheme();
      }
    }

    private static class descheduleCronJob_argsTupleScheme extends TupleScheme<descheduleCronJob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, descheduleCronJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetJob()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetJob()) {
          struct.job.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, descheduleCronJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.job = new JobKey();
          struct.job.read(iprot);
          struct.setJobIsSet(true);
        }
      }
    }

  }

  public static class descheduleCronJob_result implements org.apache.thrift.TBase<descheduleCronJob_result, descheduleCronJob_result._Fields>, java.io.Serializable, Cloneable, Comparable<descheduleCronJob_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("descheduleCronJob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new descheduleCronJob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new descheduleCronJob_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(descheduleCronJob_result.class, metaDataMap);
    }

    public descheduleCronJob_result() {
    }

    public descheduleCronJob_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public descheduleCronJob_result(descheduleCronJob_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public descheduleCronJob_result deepCopy() {
      return new descheduleCronJob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public descheduleCronJob_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof descheduleCronJob_result)
        return this.equals((descheduleCronJob_result)that);
      return false;
    }

    public boolean equals(descheduleCronJob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(descheduleCronJob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("descheduleCronJob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class descheduleCronJob_resultStandardSchemeFactory implements SchemeFactory {
      public descheduleCronJob_resultStandardScheme getScheme() {
        return new descheduleCronJob_resultStandardScheme();
      }
    }

    private static class descheduleCronJob_resultStandardScheme extends StandardScheme<descheduleCronJob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, descheduleCronJob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, descheduleCronJob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class descheduleCronJob_resultTupleSchemeFactory implements SchemeFactory {
      public descheduleCronJob_resultTupleScheme getScheme() {
        return new descheduleCronJob_resultTupleScheme();
      }
    }

    private static class descheduleCronJob_resultTupleScheme extends TupleScheme<descheduleCronJob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, descheduleCronJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, descheduleCronJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class startCronJob_args implements org.apache.thrift.TBase<startCronJob_args, startCronJob_args._Fields>, java.io.Serializable, Cloneable, Comparable<startCronJob_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startCronJob_args");

    private static final org.apache.thrift.protocol.TField JOB_FIELD_DESC = new org.apache.thrift.protocol.TField("job", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startCronJob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startCronJob_argsTupleSchemeFactory());
    }

    public JobKey job; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      JOB((short)4, "job");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // JOB
            return JOB;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.JOB, new org.apache.thrift.meta_data.FieldMetaData("job", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobKey.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startCronJob_args.class, metaDataMap);
    }

    public startCronJob_args() {
    }

    public startCronJob_args(
      JobKey job)
    {
      this();
      this.job = job;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startCronJob_args(startCronJob_args other) {
      if (other.isSetJob()) {
        this.job = new JobKey(other.job);
      }
    }

    public startCronJob_args deepCopy() {
      return new startCronJob_args(this);
    }

    @Override
    public void clear() {
      this.job = null;
    }

    public JobKey getJob() {
      return this.job;
    }

    public startCronJob_args setJob(JobKey job) {
      this.job = job;
      return this;
    }

    public void unsetJob() {
      this.job = null;
    }

    /** Returns true if field job is set (has been assigned a value) and false otherwise */
    public boolean isSetJob() {
      return this.job != null;
    }

    public void setJobIsSet(boolean value) {
      if (!value) {
        this.job = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case JOB:
        if (value == null) {
          unsetJob();
        } else {
          setJob((JobKey)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case JOB:
        return getJob();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case JOB:
        return isSetJob();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startCronJob_args)
        return this.equals((startCronJob_args)that);
      return false;
    }

    public boolean equals(startCronJob_args that) {
      if (that == null)
        return false;

      boolean this_present_job = true && this.isSetJob();
      boolean that_present_job = true && that.isSetJob();
      if (this_present_job || that_present_job) {
        if (!(this_present_job && that_present_job))
          return false;
        if (!this.job.equals(that.job))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_job = true && (isSetJob());
      list.add(present_job);
      if (present_job)
        list.add(job);

      return list.hashCode();
    }

    @Override
    public int compareTo(startCronJob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetJob()).compareTo(other.isSetJob());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJob()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.job, other.job);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startCronJob_args(");
      boolean first = true;

      sb.append("job:");
      if (this.job == null) {
        sb.append("null");
      } else {
        sb.append(this.job);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (job != null) {
        job.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startCronJob_argsStandardSchemeFactory implements SchemeFactory {
      public startCronJob_argsStandardScheme getScheme() {
        return new startCronJob_argsStandardScheme();
      }
    }

    private static class startCronJob_argsStandardScheme extends StandardScheme<startCronJob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startCronJob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // JOB
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.job = new JobKey();
                struct.job.read(iprot);
                struct.setJobIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startCronJob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.job != null) {
          oprot.writeFieldBegin(JOB_FIELD_DESC);
          struct.job.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startCronJob_argsTupleSchemeFactory implements SchemeFactory {
      public startCronJob_argsTupleScheme getScheme() {
        return new startCronJob_argsTupleScheme();
      }
    }

    private static class startCronJob_argsTupleScheme extends TupleScheme<startCronJob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startCronJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetJob()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetJob()) {
          struct.job.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startCronJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.job = new JobKey();
          struct.job.read(iprot);
          struct.setJobIsSet(true);
        }
      }
    }

  }

  public static class startCronJob_result implements org.apache.thrift.TBase<startCronJob_result, startCronJob_result._Fields>, java.io.Serializable, Cloneable, Comparable<startCronJob_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startCronJob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startCronJob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startCronJob_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startCronJob_result.class, metaDataMap);
    }

    public startCronJob_result() {
    }

    public startCronJob_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startCronJob_result(startCronJob_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public startCronJob_result deepCopy() {
      return new startCronJob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public startCronJob_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startCronJob_result)
        return this.equals((startCronJob_result)that);
      return false;
    }

    public boolean equals(startCronJob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(startCronJob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startCronJob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startCronJob_resultStandardSchemeFactory implements SchemeFactory {
      public startCronJob_resultStandardScheme getScheme() {
        return new startCronJob_resultStandardScheme();
      }
    }

    private static class startCronJob_resultStandardScheme extends StandardScheme<startCronJob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startCronJob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startCronJob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startCronJob_resultTupleSchemeFactory implements SchemeFactory {
      public startCronJob_resultTupleScheme getScheme() {
        return new startCronJob_resultTupleScheme();
      }
    }

    private static class startCronJob_resultTupleScheme extends TupleScheme<startCronJob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startCronJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startCronJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class restartShards_args implements org.apache.thrift.TBase<restartShards_args, restartShards_args._Fields>, java.io.Serializable, Cloneable, Comparable<restartShards_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("restartShards_args");

    private static final org.apache.thrift.protocol.TField JOB_FIELD_DESC = new org.apache.thrift.protocol.TField("job", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField SHARD_IDS_FIELD_DESC = new org.apache.thrift.protocol.TField("shardIds", org.apache.thrift.protocol.TType.SET, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new restartShards_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new restartShards_argsTupleSchemeFactory());
    }

    public JobKey job; // required
    public Set<Integer> shardIds; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      JOB((short)5, "job"),
      SHARD_IDS((short)3, "shardIds");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // JOB
            return JOB;
          case 3: // SHARD_IDS
            return SHARD_IDS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.JOB, new org.apache.thrift.meta_data.FieldMetaData("job", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobKey.class)));
      tmpMap.put(_Fields.SHARD_IDS, new org.apache.thrift.meta_data.FieldMetaData("shardIds", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(restartShards_args.class, metaDataMap);
    }

    public restartShards_args() {
    }

    public restartShards_args(
      JobKey job,
      Set<Integer> shardIds)
    {
      this();
      this.job = job;
      this.shardIds = shardIds;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public restartShards_args(restartShards_args other) {
      if (other.isSetJob()) {
        this.job = new JobKey(other.job);
      }
      if (other.isSetShardIds()) {
        Set<Integer> __this__shardIds = new HashSet<Integer>(other.shardIds);
        this.shardIds = __this__shardIds;
      }
    }

    public restartShards_args deepCopy() {
      return new restartShards_args(this);
    }

    @Override
    public void clear() {
      this.job = null;
      this.shardIds = null;
    }

    public JobKey getJob() {
      return this.job;
    }

    public restartShards_args setJob(JobKey job) {
      this.job = job;
      return this;
    }

    public void unsetJob() {
      this.job = null;
    }

    /** Returns true if field job is set (has been assigned a value) and false otherwise */
    public boolean isSetJob() {
      return this.job != null;
    }

    public void setJobIsSet(boolean value) {
      if (!value) {
        this.job = null;
      }
    }

    public int getShardIdsSize() {
      return (this.shardIds == null) ? 0 : this.shardIds.size();
    }

    public java.util.Iterator<Integer> getShardIdsIterator() {
      return (this.shardIds == null) ? null : this.shardIds.iterator();
    }

    public void addToShardIds(int elem) {
      if (this.shardIds == null) {
        this.shardIds = new HashSet<Integer>();
      }
      this.shardIds.add(elem);
    }

    public Set<Integer> getShardIds() {
      return this.shardIds;
    }

    public restartShards_args setShardIds(Set<Integer> shardIds) {
      this.shardIds = shardIds;
      return this;
    }

    public void unsetShardIds() {
      this.shardIds = null;
    }

    /** Returns true if field shardIds is set (has been assigned a value) and false otherwise */
    public boolean isSetShardIds() {
      return this.shardIds != null;
    }

    public void setShardIdsIsSet(boolean value) {
      if (!value) {
        this.shardIds = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case JOB:
        if (value == null) {
          unsetJob();
        } else {
          setJob((JobKey)value);
        }
        break;

      case SHARD_IDS:
        if (value == null) {
          unsetShardIds();
        } else {
          setShardIds((Set<Integer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case JOB:
        return getJob();

      case SHARD_IDS:
        return getShardIds();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case JOB:
        return isSetJob();
      case SHARD_IDS:
        return isSetShardIds();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof restartShards_args)
        return this.equals((restartShards_args)that);
      return false;
    }

    public boolean equals(restartShards_args that) {
      if (that == null)
        return false;

      boolean this_present_job = true && this.isSetJob();
      boolean that_present_job = true && that.isSetJob();
      if (this_present_job || that_present_job) {
        if (!(this_present_job && that_present_job))
          return false;
        if (!this.job.equals(that.job))
          return false;
      }

      boolean this_present_shardIds = true && this.isSetShardIds();
      boolean that_present_shardIds = true && that.isSetShardIds();
      if (this_present_shardIds || that_present_shardIds) {
        if (!(this_present_shardIds && that_present_shardIds))
          return false;
        if (!this.shardIds.equals(that.shardIds))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_job = true && (isSetJob());
      list.add(present_job);
      if (present_job)
        list.add(job);

      boolean present_shardIds = true && (isSetShardIds());
      list.add(present_shardIds);
      if (present_shardIds)
        list.add(shardIds);

      return list.hashCode();
    }

    @Override
    public int compareTo(restartShards_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetJob()).compareTo(other.isSetJob());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJob()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.job, other.job);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetShardIds()).compareTo(other.isSetShardIds());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetShardIds()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.shardIds, other.shardIds);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("restartShards_args(");
      boolean first = true;

      sb.append("job:");
      if (this.job == null) {
        sb.append("null");
      } else {
        sb.append(this.job);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("shardIds:");
      if (this.shardIds == null) {
        sb.append("null");
      } else {
        sb.append(this.shardIds);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (job != null) {
        job.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class restartShards_argsStandardSchemeFactory implements SchemeFactory {
      public restartShards_argsStandardScheme getScheme() {
        return new restartShards_argsStandardScheme();
      }
    }

    private static class restartShards_argsStandardScheme extends StandardScheme<restartShards_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, restartShards_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // JOB
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.job = new JobKey();
                struct.job.read(iprot);
                struct.setJobIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // SHARD_IDS
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set408 = iprot.readSetBegin();
                  struct.shardIds = new HashSet<Integer>(2*_set408.size);
                  int _elem409;
                  for (int _i410 = 0; _i410 < _set408.size; ++_i410)
                  {
                    _elem409 = iprot.readI32();
                    struct.shardIds.add(_elem409);
                  }
                  iprot.readSetEnd();
                }
                struct.setShardIdsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, restartShards_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.shardIds != null) {
          oprot.writeFieldBegin(SHARD_IDS_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, struct.shardIds.size()));
            for (int _iter411 : struct.shardIds)
            {
              oprot.writeI32(_iter411);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.job != null) {
          oprot.writeFieldBegin(JOB_FIELD_DESC);
          struct.job.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class restartShards_argsTupleSchemeFactory implements SchemeFactory {
      public restartShards_argsTupleScheme getScheme() {
        return new restartShards_argsTupleScheme();
      }
    }

    private static class restartShards_argsTupleScheme extends TupleScheme<restartShards_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, restartShards_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetJob()) {
          optionals.set(0);
        }
        if (struct.isSetShardIds()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetJob()) {
          struct.job.write(oprot);
        }
        if (struct.isSetShardIds()) {
          {
            oprot.writeI32(struct.shardIds.size());
            for (int _iter412 : struct.shardIds)
            {
              oprot.writeI32(_iter412);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, restartShards_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.job = new JobKey();
          struct.job.read(iprot);
          struct.setJobIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TSet _set413 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.shardIds = new HashSet<Integer>(2*_set413.size);
            int _elem414;
            for (int _i415 = 0; _i415 < _set413.size; ++_i415)
            {
              _elem414 = iprot.readI32();
              struct.shardIds.add(_elem414);
            }
          }
          struct.setShardIdsIsSet(true);
        }
      }
    }

  }

  public static class restartShards_result implements org.apache.thrift.TBase<restartShards_result, restartShards_result._Fields>, java.io.Serializable, Cloneable, Comparable<restartShards_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("restartShards_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new restartShards_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new restartShards_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(restartShards_result.class, metaDataMap);
    }

    public restartShards_result() {
    }

    public restartShards_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public restartShards_result(restartShards_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public restartShards_result deepCopy() {
      return new restartShards_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public restartShards_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof restartShards_result)
        return this.equals((restartShards_result)that);
      return false;
    }

    public boolean equals(restartShards_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(restartShards_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("restartShards_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class restartShards_resultStandardSchemeFactory implements SchemeFactory {
      public restartShards_resultStandardScheme getScheme() {
        return new restartShards_resultStandardScheme();
      }
    }

    private static class restartShards_resultStandardScheme extends StandardScheme<restartShards_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, restartShards_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, restartShards_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class restartShards_resultTupleSchemeFactory implements SchemeFactory {
      public restartShards_resultTupleScheme getScheme() {
        return new restartShards_resultTupleScheme();
      }
    }

    private static class restartShards_resultTupleScheme extends TupleScheme<restartShards_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, restartShards_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, restartShards_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class killTasks_args implements org.apache.thrift.TBase<killTasks_args, killTasks_args._Fields>, java.io.Serializable, Cloneable, Comparable<killTasks_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTasks_args");

    private static final org.apache.thrift.protocol.TField JOB_FIELD_DESC = new org.apache.thrift.protocol.TField("job", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField INSTANCES_FIELD_DESC = new org.apache.thrift.protocol.TField("instances", org.apache.thrift.protocol.TType.SET, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTasks_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTasks_argsTupleSchemeFactory());
    }

    public JobKey job; // required
    public Set<Integer> instances; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      JOB((short)4, "job"),
      INSTANCES((short)5, "instances");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // JOB
            return JOB;
          case 5: // INSTANCES
            return INSTANCES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.JOB, new org.apache.thrift.meta_data.FieldMetaData("job", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobKey.class)));
      tmpMap.put(_Fields.INSTANCES, new org.apache.thrift.meta_data.FieldMetaData("instances", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTasks_args.class, metaDataMap);
    }

    public killTasks_args() {
    }

    public killTasks_args(
      JobKey job,
      Set<Integer> instances)
    {
      this();
      this.job = job;
      this.instances = instances;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTasks_args(killTasks_args other) {
      if (other.isSetJob()) {
        this.job = new JobKey(other.job);
      }
      if (other.isSetInstances()) {
        Set<Integer> __this__instances = new HashSet<Integer>(other.instances);
        this.instances = __this__instances;
      }
    }

    public killTasks_args deepCopy() {
      return new killTasks_args(this);
    }

    @Override
    public void clear() {
      this.job = null;
      this.instances = null;
    }

    public JobKey getJob() {
      return this.job;
    }

    public killTasks_args setJob(JobKey job) {
      this.job = job;
      return this;
    }

    public void unsetJob() {
      this.job = null;
    }

    /** Returns true if field job is set (has been assigned a value) and false otherwise */
    public boolean isSetJob() {
      return this.job != null;
    }

    public void setJobIsSet(boolean value) {
      if (!value) {
        this.job = null;
      }
    }

    public int getInstancesSize() {
      return (this.instances == null) ? 0 : this.instances.size();
    }

    public java.util.Iterator<Integer> getInstancesIterator() {
      return (this.instances == null) ? null : this.instances.iterator();
    }

    public void addToInstances(int elem) {
      if (this.instances == null) {
        this.instances = new HashSet<Integer>();
      }
      this.instances.add(elem);
    }

    public Set<Integer> getInstances() {
      return this.instances;
    }

    public killTasks_args setInstances(Set<Integer> instances) {
      this.instances = instances;
      return this;
    }

    public void unsetInstances() {
      this.instances = null;
    }

    /** Returns true if field instances is set (has been assigned a value) and false otherwise */
    public boolean isSetInstances() {
      return this.instances != null;
    }

    public void setInstancesIsSet(boolean value) {
      if (!value) {
        this.instances = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case JOB:
        if (value == null) {
          unsetJob();
        } else {
          setJob((JobKey)value);
        }
        break;

      case INSTANCES:
        if (value == null) {
          unsetInstances();
        } else {
          setInstances((Set<Integer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case JOB:
        return getJob();

      case INSTANCES:
        return getInstances();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case JOB:
        return isSetJob();
      case INSTANCES:
        return isSetInstances();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTasks_args)
        return this.equals((killTasks_args)that);
      return false;
    }

    public boolean equals(killTasks_args that) {
      if (that == null)
        return false;

      boolean this_present_job = true && this.isSetJob();
      boolean that_present_job = true && that.isSetJob();
      if (this_present_job || that_present_job) {
        if (!(this_present_job && that_present_job))
          return false;
        if (!this.job.equals(that.job))
          return false;
      }

      boolean this_present_instances = true && this.isSetInstances();
      boolean that_present_instances = true && that.isSetInstances();
      if (this_present_instances || that_present_instances) {
        if (!(this_present_instances && that_present_instances))
          return false;
        if (!this.instances.equals(that.instances))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_job = true && (isSetJob());
      list.add(present_job);
      if (present_job)
        list.add(job);

      boolean present_instances = true && (isSetInstances());
      list.add(present_instances);
      if (present_instances)
        list.add(instances);

      return list.hashCode();
    }

    @Override
    public int compareTo(killTasks_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetJob()).compareTo(other.isSetJob());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJob()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.job, other.job);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetInstances()).compareTo(other.isSetInstances());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetInstances()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.instances, other.instances);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTasks_args(");
      boolean first = true;

      sb.append("job:");
      if (this.job == null) {
        sb.append("null");
      } else {
        sb.append(this.job);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("instances:");
      if (this.instances == null) {
        sb.append("null");
      } else {
        sb.append(this.instances);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (job != null) {
        job.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTasks_argsStandardSchemeFactory implements SchemeFactory {
      public killTasks_argsStandardScheme getScheme() {
        return new killTasks_argsStandardScheme();
      }
    }

    private static class killTasks_argsStandardScheme extends StandardScheme<killTasks_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTasks_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // JOB
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.job = new JobKey();
                struct.job.read(iprot);
                struct.setJobIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // INSTANCES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set416 = iprot.readSetBegin();
                  struct.instances = new HashSet<Integer>(2*_set416.size);
                  int _elem417;
                  for (int _i418 = 0; _i418 < _set416.size; ++_i418)
                  {
                    _elem417 = iprot.readI32();
                    struct.instances.add(_elem417);
                  }
                  iprot.readSetEnd();
                }
                struct.setInstancesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTasks_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.job != null) {
          oprot.writeFieldBegin(JOB_FIELD_DESC);
          struct.job.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.instances != null) {
          oprot.writeFieldBegin(INSTANCES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, struct.instances.size()));
            for (int _iter419 : struct.instances)
            {
              oprot.writeI32(_iter419);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTasks_argsTupleSchemeFactory implements SchemeFactory {
      public killTasks_argsTupleScheme getScheme() {
        return new killTasks_argsTupleScheme();
      }
    }

    private static class killTasks_argsTupleScheme extends TupleScheme<killTasks_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTasks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetJob()) {
          optionals.set(0);
        }
        if (struct.isSetInstances()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetJob()) {
          struct.job.write(oprot);
        }
        if (struct.isSetInstances()) {
          {
            oprot.writeI32(struct.instances.size());
            for (int _iter420 : struct.instances)
            {
              oprot.writeI32(_iter420);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTasks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.job = new JobKey();
          struct.job.read(iprot);
          struct.setJobIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TSet _set421 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.instances = new HashSet<Integer>(2*_set421.size);
            int _elem422;
            for (int _i423 = 0; _i423 < _set421.size; ++_i423)
            {
              _elem422 = iprot.readI32();
              struct.instances.add(_elem422);
            }
          }
          struct.setInstancesIsSet(true);
        }
      }
    }

  }

  public static class killTasks_result implements org.apache.thrift.TBase<killTasks_result, killTasks_result._Fields>, java.io.Serializable, Cloneable, Comparable<killTasks_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTasks_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTasks_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTasks_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTasks_result.class, metaDataMap);
    }

    public killTasks_result() {
    }

    public killTasks_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTasks_result(killTasks_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public killTasks_result deepCopy() {
      return new killTasks_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public killTasks_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTasks_result)
        return this.equals((killTasks_result)that);
      return false;
    }

    public boolean equals(killTasks_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(killTasks_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTasks_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTasks_resultStandardSchemeFactory implements SchemeFactory {
      public killTasks_resultStandardScheme getScheme() {
        return new killTasks_resultStandardScheme();
      }
    }

    private static class killTasks_resultStandardScheme extends StandardScheme<killTasks_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTasks_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTasks_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTasks_resultTupleSchemeFactory implements SchemeFactory {
      public killTasks_resultTupleScheme getScheme() {
        return new killTasks_resultTupleScheme();
      }
    }

    private static class killTasks_resultTupleScheme extends TupleScheme<killTasks_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTasks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTasks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class addInstances_args implements org.apache.thrift.TBase<addInstances_args, addInstances_args._Fields>, java.io.Serializable, Cloneable, Comparable<addInstances_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addInstances_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField COUNT_FIELD_DESC = new org.apache.thrift.protocol.TField("count", org.apache.thrift.protocol.TType.I32, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addInstances_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addInstances_argsTupleSchemeFactory());
    }

    public InstanceKey key; // required
    public int count; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)3, "key"),
      COUNT((short)4, "count");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 3: // KEY
            return KEY;
          case 4: // COUNT
            return COUNT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __COUNT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, InstanceKey.class)));
      tmpMap.put(_Fields.COUNT, new org.apache.thrift.meta_data.FieldMetaData("count", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addInstances_args.class, metaDataMap);
    }

    public addInstances_args() {
    }

    public addInstances_args(
      InstanceKey key,
      int count)
    {
      this();
      this.key = key;
      this.count = count;
      setCountIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addInstances_args(addInstances_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetKey()) {
        this.key = new InstanceKey(other.key);
      }
      this.count = other.count;
    }

    public addInstances_args deepCopy() {
      return new addInstances_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      setCountIsSet(false);
      this.count = 0;
    }

    public InstanceKey getKey() {
      return this.key;
    }

    public addInstances_args setKey(InstanceKey key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public int getCount() {
      return this.count;
    }

    public addInstances_args setCount(int count) {
      this.count = count;
      setCountIsSet(true);
      return this;
    }

    public void unsetCount() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __COUNT_ISSET_ID);
    }

    /** Returns true if field count is set (has been assigned a value) and false otherwise */
    public boolean isSetCount() {
      return EncodingUtils.testBit(__isset_bitfield, __COUNT_ISSET_ID);
    }

    public void setCountIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __COUNT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((InstanceKey)value);
        }
        break;

      case COUNT:
        if (value == null) {
          unsetCount();
        } else {
          setCount((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case COUNT:
        return getCount();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case COUNT:
        return isSetCount();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addInstances_args)
        return this.equals((addInstances_args)that);
      return false;
    }

    public boolean equals(addInstances_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_count = true;
      boolean that_present_count = true;
      if (this_present_count || that_present_count) {
        if (!(this_present_count && that_present_count))
          return false;
        if (this.count != that.count)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (isSetKey());
      list.add(present_key);
      if (present_key)
        list.add(key);

      boolean present_count = true;
      list.add(present_count);
      if (present_count)
        list.add(count);

      return list.hashCode();
    }

    @Override
    public int compareTo(addInstances_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(other.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCount()).compareTo(other.isSetCount());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCount()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.count, other.count);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addInstances_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("count:");
      sb.append(this.count);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (key != null) {
        key.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addInstances_argsStandardSchemeFactory implements SchemeFactory {
      public addInstances_argsStandardScheme getScheme() {
        return new addInstances_argsStandardScheme();
      }
    }

    private static class addInstances_argsStandardScheme extends StandardScheme<addInstances_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addInstances_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 3: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.key = new InstanceKey();
                struct.key.read(iprot);
                struct.setKeyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // COUNT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.count = iprot.readI32();
                struct.setCountIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addInstances_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          struct.key.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(COUNT_FIELD_DESC);
        oprot.writeI32(struct.count);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addInstances_argsTupleSchemeFactory implements SchemeFactory {
      public addInstances_argsTupleScheme getScheme() {
        return new addInstances_argsTupleScheme();
      }
    }

    private static class addInstances_argsTupleScheme extends TupleScheme<addInstances_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addInstances_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetKey()) {
          optionals.set(0);
        }
        if (struct.isSetCount()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetKey()) {
          struct.key.write(oprot);
        }
        if (struct.isSetCount()) {
          oprot.writeI32(struct.count);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addInstances_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.key = new InstanceKey();
          struct.key.read(iprot);
          struct.setKeyIsSet(true);
        }
        if (incoming.get(1)) {
          struct.count = iprot.readI32();
          struct.setCountIsSet(true);
        }
      }
    }

  }

  public static class addInstances_result implements org.apache.thrift.TBase<addInstances_result, addInstances_result._Fields>, java.io.Serializable, Cloneable, Comparable<addInstances_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addInstances_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addInstances_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addInstances_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addInstances_result.class, metaDataMap);
    }

    public addInstances_result() {
    }

    public addInstances_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addInstances_result(addInstances_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public addInstances_result deepCopy() {
      return new addInstances_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public addInstances_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addInstances_result)
        return this.equals((addInstances_result)that);
      return false;
    }

    public boolean equals(addInstances_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(addInstances_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addInstances_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addInstances_resultStandardSchemeFactory implements SchemeFactory {
      public addInstances_resultStandardScheme getScheme() {
        return new addInstances_resultStandardScheme();
      }
    }

    private static class addInstances_resultStandardScheme extends StandardScheme<addInstances_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addInstances_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addInstances_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addInstances_resultTupleSchemeFactory implements SchemeFactory {
      public addInstances_resultTupleScheme getScheme() {
        return new addInstances_resultTupleScheme();
      }
    }

    private static class addInstances_resultTupleScheme extends TupleScheme<addInstances_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addInstances_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addInstances_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class replaceCronTemplate_args implements org.apache.thrift.TBase<replaceCronTemplate_args, replaceCronTemplate_args._Fields>, java.io.Serializable, Cloneable, Comparable<replaceCronTemplate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("replaceCronTemplate_args");

    private static final org.apache.thrift.protocol.TField CONFIG_FIELD_DESC = new org.apache.thrift.protocol.TField("config", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new replaceCronTemplate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new replaceCronTemplate_argsTupleSchemeFactory());
    }

    public JobConfiguration config; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CONFIG((short)1, "config");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CONFIG
            return CONFIG;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CONFIG, new org.apache.thrift.meta_data.FieldMetaData("config", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobConfiguration.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(replaceCronTemplate_args.class, metaDataMap);
    }

    public replaceCronTemplate_args() {
    }

    public replaceCronTemplate_args(
      JobConfiguration config)
    {
      this();
      this.config = config;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public replaceCronTemplate_args(replaceCronTemplate_args other) {
      if (other.isSetConfig()) {
        this.config = new JobConfiguration(other.config);
      }
    }

    public replaceCronTemplate_args deepCopy() {
      return new replaceCronTemplate_args(this);
    }

    @Override
    public void clear() {
      this.config = null;
    }

    public JobConfiguration getConfig() {
      return this.config;
    }

    public replaceCronTemplate_args setConfig(JobConfiguration config) {
      this.config = config;
      return this;
    }

    public void unsetConfig() {
      this.config = null;
    }

    /** Returns true if field config is set (has been assigned a value) and false otherwise */
    public boolean isSetConfig() {
      return this.config != null;
    }

    public void setConfigIsSet(boolean value) {
      if (!value) {
        this.config = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CONFIG:
        if (value == null) {
          unsetConfig();
        } else {
          setConfig((JobConfiguration)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CONFIG:
        return getConfig();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CONFIG:
        return isSetConfig();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof replaceCronTemplate_args)
        return this.equals((replaceCronTemplate_args)that);
      return false;
    }

    public boolean equals(replaceCronTemplate_args that) {
      if (that == null)
        return false;

      boolean this_present_config = true && this.isSetConfig();
      boolean that_present_config = true && that.isSetConfig();
      if (this_present_config || that_present_config) {
        if (!(this_present_config && that_present_config))
          return false;
        if (!this.config.equals(that.config))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_config = true && (isSetConfig());
      list.add(present_config);
      if (present_config)
        list.add(config);

      return list.hashCode();
    }

    @Override
    public int compareTo(replaceCronTemplate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetConfig()).compareTo(other.isSetConfig());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConfig()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.config, other.config);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("replaceCronTemplate_args(");
      boolean first = true;

      sb.append("config:");
      if (this.config == null) {
        sb.append("null");
      } else {
        sb.append(this.config);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (config != null) {
        config.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class replaceCronTemplate_argsStandardSchemeFactory implements SchemeFactory {
      public replaceCronTemplate_argsStandardScheme getScheme() {
        return new replaceCronTemplate_argsStandardScheme();
      }
    }

    private static class replaceCronTemplate_argsStandardScheme extends StandardScheme<replaceCronTemplate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, replaceCronTemplate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CONFIG
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.config = new JobConfiguration();
                struct.config.read(iprot);
                struct.setConfigIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, replaceCronTemplate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.config != null) {
          oprot.writeFieldBegin(CONFIG_FIELD_DESC);
          struct.config.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class replaceCronTemplate_argsTupleSchemeFactory implements SchemeFactory {
      public replaceCronTemplate_argsTupleScheme getScheme() {
        return new replaceCronTemplate_argsTupleScheme();
      }
    }

    private static class replaceCronTemplate_argsTupleScheme extends TupleScheme<replaceCronTemplate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, replaceCronTemplate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetConfig()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetConfig()) {
          struct.config.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, replaceCronTemplate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.config = new JobConfiguration();
          struct.config.read(iprot);
          struct.setConfigIsSet(true);
        }
      }
    }

  }

  public static class replaceCronTemplate_result implements org.apache.thrift.TBase<replaceCronTemplate_result, replaceCronTemplate_result._Fields>, java.io.Serializable, Cloneable, Comparable<replaceCronTemplate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("replaceCronTemplate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new replaceCronTemplate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new replaceCronTemplate_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(replaceCronTemplate_result.class, metaDataMap);
    }

    public replaceCronTemplate_result() {
    }

    public replaceCronTemplate_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public replaceCronTemplate_result(replaceCronTemplate_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public replaceCronTemplate_result deepCopy() {
      return new replaceCronTemplate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public replaceCronTemplate_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof replaceCronTemplate_result)
        return this.equals((replaceCronTemplate_result)that);
      return false;
    }

    public boolean equals(replaceCronTemplate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(replaceCronTemplate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("replaceCronTemplate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class replaceCronTemplate_resultStandardSchemeFactory implements SchemeFactory {
      public replaceCronTemplate_resultStandardScheme getScheme() {
        return new replaceCronTemplate_resultStandardScheme();
      }
    }

    private static class replaceCronTemplate_resultStandardScheme extends StandardScheme<replaceCronTemplate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, replaceCronTemplate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, replaceCronTemplate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class replaceCronTemplate_resultTupleSchemeFactory implements SchemeFactory {
      public replaceCronTemplate_resultTupleScheme getScheme() {
        return new replaceCronTemplate_resultTupleScheme();
      }
    }

    private static class replaceCronTemplate_resultTupleScheme extends TupleScheme<replaceCronTemplate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, replaceCronTemplate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, replaceCronTemplate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class startJobUpdate_args implements org.apache.thrift.TBase<startJobUpdate_args, startJobUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<startJobUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startJobUpdate_args");

    private static final org.apache.thrift.protocol.TField REQUEST_FIELD_DESC = new org.apache.thrift.protocol.TField("request", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField MESSAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("message", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startJobUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startJobUpdate_argsTupleSchemeFactory());
    }

    /**
     * A description of how to change the job.
     */
    public JobUpdateRequest request; // required
    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String message; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * A description of how to change the job.
       */
      REQUEST((short)1, "request"),
      /**
       * A user-specified message to include with the induced job update state change.
       */
      MESSAGE((short)3, "message");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // REQUEST
            return REQUEST;
          case 3: // MESSAGE
            return MESSAGE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.REQUEST, new org.apache.thrift.meta_data.FieldMetaData("request", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobUpdateRequest.class)));
      tmpMap.put(_Fields.MESSAGE, new org.apache.thrift.meta_data.FieldMetaData("message", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startJobUpdate_args.class, metaDataMap);
    }

    public startJobUpdate_args() {
    }

    public startJobUpdate_args(
      JobUpdateRequest request,
      String message)
    {
      this();
      this.request = request;
      this.message = message;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startJobUpdate_args(startJobUpdate_args other) {
      if (other.isSetRequest()) {
        this.request = new JobUpdateRequest(other.request);
      }
      if (other.isSetMessage()) {
        this.message = other.message;
      }
    }

    public startJobUpdate_args deepCopy() {
      return new startJobUpdate_args(this);
    }

    @Override
    public void clear() {
      this.request = null;
      this.message = null;
    }

    /**
     * A description of how to change the job.
     */
    public JobUpdateRequest getRequest() {
      return this.request;
    }

    /**
     * A description of how to change the job.
     */
    public startJobUpdate_args setRequest(JobUpdateRequest request) {
      this.request = request;
      return this;
    }

    public void unsetRequest() {
      this.request = null;
    }

    /** Returns true if field request is set (has been assigned a value) and false otherwise */
    public boolean isSetRequest() {
      return this.request != null;
    }

    public void setRequestIsSet(boolean value) {
      if (!value) {
        this.request = null;
      }
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String getMessage() {
      return this.message;
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public startJobUpdate_args setMessage(String message) {
      this.message = message;
      return this;
    }

    public void unsetMessage() {
      this.message = null;
    }

    /** Returns true if field message is set (has been assigned a value) and false otherwise */
    public boolean isSetMessage() {
      return this.message != null;
    }

    public void setMessageIsSet(boolean value) {
      if (!value) {
        this.message = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case REQUEST:
        if (value == null) {
          unsetRequest();
        } else {
          setRequest((JobUpdateRequest)value);
        }
        break;

      case MESSAGE:
        if (value == null) {
          unsetMessage();
        } else {
          setMessage((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case REQUEST:
        return getRequest();

      case MESSAGE:
        return getMessage();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case REQUEST:
        return isSetRequest();
      case MESSAGE:
        return isSetMessage();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startJobUpdate_args)
        return this.equals((startJobUpdate_args)that);
      return false;
    }

    public boolean equals(startJobUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_request = true && this.isSetRequest();
      boolean that_present_request = true && that.isSetRequest();
      if (this_present_request || that_present_request) {
        if (!(this_present_request && that_present_request))
          return false;
        if (!this.request.equals(that.request))
          return false;
      }

      boolean this_present_message = true && this.isSetMessage();
      boolean that_present_message = true && that.isSetMessage();
      if (this_present_message || that_present_message) {
        if (!(this_present_message && that_present_message))
          return false;
        if (!this.message.equals(that.message))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_request = true && (isSetRequest());
      list.add(present_request);
      if (present_request)
        list.add(request);

      boolean present_message = true && (isSetMessage());
      list.add(present_message);
      if (present_message)
        list.add(message);

      return list.hashCode();
    }

    @Override
    public int compareTo(startJobUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetRequest()).compareTo(other.isSetRequest());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRequest()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.request, other.request);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMessage()).compareTo(other.isSetMessage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMessage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.message, other.message);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startJobUpdate_args(");
      boolean first = true;

      sb.append("request:");
      if (this.request == null) {
        sb.append("null");
      } else {
        sb.append(this.request);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("message:");
      if (this.message == null) {
        sb.append("null");
      } else {
        sb.append(this.message);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (request != null) {
        request.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startJobUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public startJobUpdate_argsStandardScheme getScheme() {
        return new startJobUpdate_argsStandardScheme();
      }
    }

    private static class startJobUpdate_argsStandardScheme extends StandardScheme<startJobUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startJobUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // REQUEST
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.request = new JobUpdateRequest();
                struct.request.read(iprot);
                struct.setRequestIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MESSAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.message = iprot.readString();
                struct.setMessageIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startJobUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.request != null) {
          oprot.writeFieldBegin(REQUEST_FIELD_DESC);
          struct.request.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.message != null) {
          oprot.writeFieldBegin(MESSAGE_FIELD_DESC);
          oprot.writeString(struct.message);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startJobUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public startJobUpdate_argsTupleScheme getScheme() {
        return new startJobUpdate_argsTupleScheme();
      }
    }

    private static class startJobUpdate_argsTupleScheme extends TupleScheme<startJobUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetRequest()) {
          optionals.set(0);
        }
        if (struct.isSetMessage()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetRequest()) {
          struct.request.write(oprot);
        }
        if (struct.isSetMessage()) {
          oprot.writeString(struct.message);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.request = new JobUpdateRequest();
          struct.request.read(iprot);
          struct.setRequestIsSet(true);
        }
        if (incoming.get(1)) {
          struct.message = iprot.readString();
          struct.setMessageIsSet(true);
        }
      }
    }

  }

  public static class startJobUpdate_result implements org.apache.thrift.TBase<startJobUpdate_result, startJobUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<startJobUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startJobUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startJobUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startJobUpdate_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startJobUpdate_result.class, metaDataMap);
    }

    public startJobUpdate_result() {
    }

    public startJobUpdate_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startJobUpdate_result(startJobUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public startJobUpdate_result deepCopy() {
      return new startJobUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public startJobUpdate_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startJobUpdate_result)
        return this.equals((startJobUpdate_result)that);
      return false;
    }

    public boolean equals(startJobUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(startJobUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startJobUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startJobUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public startJobUpdate_resultStandardScheme getScheme() {
        return new startJobUpdate_resultStandardScheme();
      }
    }

    private static class startJobUpdate_resultStandardScheme extends StandardScheme<startJobUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startJobUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startJobUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startJobUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public startJobUpdate_resultTupleScheme getScheme() {
        return new startJobUpdate_resultTupleScheme();
      }
    }

    private static class startJobUpdate_resultTupleScheme extends TupleScheme<startJobUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class pauseJobUpdate_args implements org.apache.thrift.TBase<pauseJobUpdate_args, pauseJobUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<pauseJobUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("pauseJobUpdate_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField MESSAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("message", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new pauseJobUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new pauseJobUpdate_argsTupleSchemeFactory());
    }

    /**
     * The update to pause.
     */
    public JobUpdateKey key; // required
    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String message; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * The update to pause.
       */
      KEY((short)1, "key"),
      /**
       * A user-specified message to include with the induced job update state change.
       */
      MESSAGE((short)3, "message");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 3: // MESSAGE
            return MESSAGE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobUpdateKey.class)));
      tmpMap.put(_Fields.MESSAGE, new org.apache.thrift.meta_data.FieldMetaData("message", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(pauseJobUpdate_args.class, metaDataMap);
    }

    public pauseJobUpdate_args() {
    }

    public pauseJobUpdate_args(
      JobUpdateKey key,
      String message)
    {
      this();
      this.key = key;
      this.message = message;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public pauseJobUpdate_args(pauseJobUpdate_args other) {
      if (other.isSetKey()) {
        this.key = new JobUpdateKey(other.key);
      }
      if (other.isSetMessage()) {
        this.message = other.message;
      }
    }

    public pauseJobUpdate_args deepCopy() {
      return new pauseJobUpdate_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.message = null;
    }

    /**
     * The update to pause.
     */
    public JobUpdateKey getKey() {
      return this.key;
    }

    /**
     * The update to pause.
     */
    public pauseJobUpdate_args setKey(JobUpdateKey key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String getMessage() {
      return this.message;
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public pauseJobUpdate_args setMessage(String message) {
      this.message = message;
      return this;
    }

    public void unsetMessage() {
      this.message = null;
    }

    /** Returns true if field message is set (has been assigned a value) and false otherwise */
    public boolean isSetMessage() {
      return this.message != null;
    }

    public void setMessageIsSet(boolean value) {
      if (!value) {
        this.message = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((JobUpdateKey)value);
        }
        break;

      case MESSAGE:
        if (value == null) {
          unsetMessage();
        } else {
          setMessage((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case MESSAGE:
        return getMessage();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case MESSAGE:
        return isSetMessage();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof pauseJobUpdate_args)
        return this.equals((pauseJobUpdate_args)that);
      return false;
    }

    public boolean equals(pauseJobUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_message = true && this.isSetMessage();
      boolean that_present_message = true && that.isSetMessage();
      if (this_present_message || that_present_message) {
        if (!(this_present_message && that_present_message))
          return false;
        if (!this.message.equals(that.message))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (isSetKey());
      list.add(present_key);
      if (present_key)
        list.add(key);

      boolean present_message = true && (isSetMessage());
      list.add(present_message);
      if (present_message)
        list.add(message);

      return list.hashCode();
    }

    @Override
    public int compareTo(pauseJobUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(other.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMessage()).compareTo(other.isSetMessage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMessage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.message, other.message);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("pauseJobUpdate_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("message:");
      if (this.message == null) {
        sb.append("null");
      } else {
        sb.append(this.message);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (key != null) {
        key.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class pauseJobUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public pauseJobUpdate_argsStandardScheme getScheme() {
        return new pauseJobUpdate_argsStandardScheme();
      }
    }

    private static class pauseJobUpdate_argsStandardScheme extends StandardScheme<pauseJobUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, pauseJobUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.key = new JobUpdateKey();
                struct.key.read(iprot);
                struct.setKeyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MESSAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.message = iprot.readString();
                struct.setMessageIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, pauseJobUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          struct.key.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.message != null) {
          oprot.writeFieldBegin(MESSAGE_FIELD_DESC);
          oprot.writeString(struct.message);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class pauseJobUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public pauseJobUpdate_argsTupleScheme getScheme() {
        return new pauseJobUpdate_argsTupleScheme();
      }
    }

    private static class pauseJobUpdate_argsTupleScheme extends TupleScheme<pauseJobUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, pauseJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetKey()) {
          optionals.set(0);
        }
        if (struct.isSetMessage()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetKey()) {
          struct.key.write(oprot);
        }
        if (struct.isSetMessage()) {
          oprot.writeString(struct.message);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, pauseJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.key = new JobUpdateKey();
          struct.key.read(iprot);
          struct.setKeyIsSet(true);
        }
        if (incoming.get(1)) {
          struct.message = iprot.readString();
          struct.setMessageIsSet(true);
        }
      }
    }

  }

  public static class pauseJobUpdate_result implements org.apache.thrift.TBase<pauseJobUpdate_result, pauseJobUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<pauseJobUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("pauseJobUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new pauseJobUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new pauseJobUpdate_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(pauseJobUpdate_result.class, metaDataMap);
    }

    public pauseJobUpdate_result() {
    }

    public pauseJobUpdate_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public pauseJobUpdate_result(pauseJobUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public pauseJobUpdate_result deepCopy() {
      return new pauseJobUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public pauseJobUpdate_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof pauseJobUpdate_result)
        return this.equals((pauseJobUpdate_result)that);
      return false;
    }

    public boolean equals(pauseJobUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(pauseJobUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("pauseJobUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class pauseJobUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public pauseJobUpdate_resultStandardScheme getScheme() {
        return new pauseJobUpdate_resultStandardScheme();
      }
    }

    private static class pauseJobUpdate_resultStandardScheme extends StandardScheme<pauseJobUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, pauseJobUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, pauseJobUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class pauseJobUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public pauseJobUpdate_resultTupleScheme getScheme() {
        return new pauseJobUpdate_resultTupleScheme();
      }
    }

    private static class pauseJobUpdate_resultTupleScheme extends TupleScheme<pauseJobUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, pauseJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, pauseJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class resumeJobUpdate_args implements org.apache.thrift.TBase<resumeJobUpdate_args, resumeJobUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<resumeJobUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resumeJobUpdate_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField MESSAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("message", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resumeJobUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resumeJobUpdate_argsTupleSchemeFactory());
    }

    /**
     * The update to resume.
     */
    public JobUpdateKey key; // required
    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String message; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * The update to resume.
       */
      KEY((short)1, "key"),
      /**
       * A user-specified message to include with the induced job update state change.
       */
      MESSAGE((short)3, "message");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 3: // MESSAGE
            return MESSAGE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobUpdateKey.class)));
      tmpMap.put(_Fields.MESSAGE, new org.apache.thrift.meta_data.FieldMetaData("message", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resumeJobUpdate_args.class, metaDataMap);
    }

    public resumeJobUpdate_args() {
    }

    public resumeJobUpdate_args(
      JobUpdateKey key,
      String message)
    {
      this();
      this.key = key;
      this.message = message;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resumeJobUpdate_args(resumeJobUpdate_args other) {
      if (other.isSetKey()) {
        this.key = new JobUpdateKey(other.key);
      }
      if (other.isSetMessage()) {
        this.message = other.message;
      }
    }

    public resumeJobUpdate_args deepCopy() {
      return new resumeJobUpdate_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.message = null;
    }

    /**
     * The update to resume.
     */
    public JobUpdateKey getKey() {
      return this.key;
    }

    /**
     * The update to resume.
     */
    public resumeJobUpdate_args setKey(JobUpdateKey key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String getMessage() {
      return this.message;
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public resumeJobUpdate_args setMessage(String message) {
      this.message = message;
      return this;
    }

    public void unsetMessage() {
      this.message = null;
    }

    /** Returns true if field message is set (has been assigned a value) and false otherwise */
    public boolean isSetMessage() {
      return this.message != null;
    }

    public void setMessageIsSet(boolean value) {
      if (!value) {
        this.message = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((JobUpdateKey)value);
        }
        break;

      case MESSAGE:
        if (value == null) {
          unsetMessage();
        } else {
          setMessage((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case MESSAGE:
        return getMessage();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case MESSAGE:
        return isSetMessage();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resumeJobUpdate_args)
        return this.equals((resumeJobUpdate_args)that);
      return false;
    }

    public boolean equals(resumeJobUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_message = true && this.isSetMessage();
      boolean that_present_message = true && that.isSetMessage();
      if (this_present_message || that_present_message) {
        if (!(this_present_message && that_present_message))
          return false;
        if (!this.message.equals(that.message))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (isSetKey());
      list.add(present_key);
      if (present_key)
        list.add(key);

      boolean present_message = true && (isSetMessage());
      list.add(present_message);
      if (present_message)
        list.add(message);

      return list.hashCode();
    }

    @Override
    public int compareTo(resumeJobUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(other.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMessage()).compareTo(other.isSetMessage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMessage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.message, other.message);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resumeJobUpdate_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("message:");
      if (this.message == null) {
        sb.append("null");
      } else {
        sb.append(this.message);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (key != null) {
        key.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resumeJobUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public resumeJobUpdate_argsStandardScheme getScheme() {
        return new resumeJobUpdate_argsStandardScheme();
      }
    }

    private static class resumeJobUpdate_argsStandardScheme extends StandardScheme<resumeJobUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resumeJobUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.key = new JobUpdateKey();
                struct.key.read(iprot);
                struct.setKeyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MESSAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.message = iprot.readString();
                struct.setMessageIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resumeJobUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          struct.key.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.message != null) {
          oprot.writeFieldBegin(MESSAGE_FIELD_DESC);
          oprot.writeString(struct.message);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resumeJobUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public resumeJobUpdate_argsTupleScheme getScheme() {
        return new resumeJobUpdate_argsTupleScheme();
      }
    }

    private static class resumeJobUpdate_argsTupleScheme extends TupleScheme<resumeJobUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resumeJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetKey()) {
          optionals.set(0);
        }
        if (struct.isSetMessage()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetKey()) {
          struct.key.write(oprot);
        }
        if (struct.isSetMessage()) {
          oprot.writeString(struct.message);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resumeJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.key = new JobUpdateKey();
          struct.key.read(iprot);
          struct.setKeyIsSet(true);
        }
        if (incoming.get(1)) {
          struct.message = iprot.readString();
          struct.setMessageIsSet(true);
        }
      }
    }

  }

  public static class resumeJobUpdate_result implements org.apache.thrift.TBase<resumeJobUpdate_result, resumeJobUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<resumeJobUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resumeJobUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resumeJobUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resumeJobUpdate_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resumeJobUpdate_result.class, metaDataMap);
    }

    public resumeJobUpdate_result() {
    }

    public resumeJobUpdate_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resumeJobUpdate_result(resumeJobUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public resumeJobUpdate_result deepCopy() {
      return new resumeJobUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public resumeJobUpdate_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resumeJobUpdate_result)
        return this.equals((resumeJobUpdate_result)that);
      return false;
    }

    public boolean equals(resumeJobUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(resumeJobUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resumeJobUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resumeJobUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public resumeJobUpdate_resultStandardScheme getScheme() {
        return new resumeJobUpdate_resultStandardScheme();
      }
    }

    private static class resumeJobUpdate_resultStandardScheme extends StandardScheme<resumeJobUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resumeJobUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resumeJobUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resumeJobUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public resumeJobUpdate_resultTupleScheme getScheme() {
        return new resumeJobUpdate_resultTupleScheme();
      }
    }

    private static class resumeJobUpdate_resultTupleScheme extends TupleScheme<resumeJobUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resumeJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resumeJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class abortJobUpdate_args implements org.apache.thrift.TBase<abortJobUpdate_args, abortJobUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<abortJobUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("abortJobUpdate_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField MESSAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("message", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new abortJobUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new abortJobUpdate_argsTupleSchemeFactory());
    }

    /**
     * The update to abort.
     */
    public JobUpdateKey key; // required
    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String message; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * The update to abort.
       */
      KEY((short)1, "key"),
      /**
       * A user-specified message to include with the induced job update state change.
       */
      MESSAGE((short)3, "message");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 3: // MESSAGE
            return MESSAGE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobUpdateKey.class)));
      tmpMap.put(_Fields.MESSAGE, new org.apache.thrift.meta_data.FieldMetaData("message", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(abortJobUpdate_args.class, metaDataMap);
    }

    public abortJobUpdate_args() {
    }

    public abortJobUpdate_args(
      JobUpdateKey key,
      String message)
    {
      this();
      this.key = key;
      this.message = message;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public abortJobUpdate_args(abortJobUpdate_args other) {
      if (other.isSetKey()) {
        this.key = new JobUpdateKey(other.key);
      }
      if (other.isSetMessage()) {
        this.message = other.message;
      }
    }

    public abortJobUpdate_args deepCopy() {
      return new abortJobUpdate_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.message = null;
    }

    /**
     * The update to abort.
     */
    public JobUpdateKey getKey() {
      return this.key;
    }

    /**
     * The update to abort.
     */
    public abortJobUpdate_args setKey(JobUpdateKey key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String getMessage() {
      return this.message;
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public abortJobUpdate_args setMessage(String message) {
      this.message = message;
      return this;
    }

    public void unsetMessage() {
      this.message = null;
    }

    /** Returns true if field message is set (has been assigned a value) and false otherwise */
    public boolean isSetMessage() {
      return this.message != null;
    }

    public void setMessageIsSet(boolean value) {
      if (!value) {
        this.message = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((JobUpdateKey)value);
        }
        break;

      case MESSAGE:
        if (value == null) {
          unsetMessage();
        } else {
          setMessage((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case MESSAGE:
        return getMessage();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case MESSAGE:
        return isSetMessage();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof abortJobUpdate_args)
        return this.equals((abortJobUpdate_args)that);
      return false;
    }

    public boolean equals(abortJobUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_message = true && this.isSetMessage();
      boolean that_present_message = true && that.isSetMessage();
      if (this_present_message || that_present_message) {
        if (!(this_present_message && that_present_message))
          return false;
        if (!this.message.equals(that.message))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (isSetKey());
      list.add(present_key);
      if (present_key)
        list.add(key);

      boolean present_message = true && (isSetMessage());
      list.add(present_message);
      if (present_message)
        list.add(message);

      return list.hashCode();
    }

    @Override
    public int compareTo(abortJobUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(other.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMessage()).compareTo(other.isSetMessage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMessage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.message, other.message);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("abortJobUpdate_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("message:");
      if (this.message == null) {
        sb.append("null");
      } else {
        sb.append(this.message);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (key != null) {
        key.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class abortJobUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public abortJobUpdate_argsStandardScheme getScheme() {
        return new abortJobUpdate_argsStandardScheme();
      }
    }

    private static class abortJobUpdate_argsStandardScheme extends StandardScheme<abortJobUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, abortJobUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.key = new JobUpdateKey();
                struct.key.read(iprot);
                struct.setKeyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MESSAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.message = iprot.readString();
                struct.setMessageIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, abortJobUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          struct.key.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.message != null) {
          oprot.writeFieldBegin(MESSAGE_FIELD_DESC);
          oprot.writeString(struct.message);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class abortJobUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public abortJobUpdate_argsTupleScheme getScheme() {
        return new abortJobUpdate_argsTupleScheme();
      }
    }

    private static class abortJobUpdate_argsTupleScheme extends TupleScheme<abortJobUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, abortJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetKey()) {
          optionals.set(0);
        }
        if (struct.isSetMessage()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetKey()) {
          struct.key.write(oprot);
        }
        if (struct.isSetMessage()) {
          oprot.writeString(struct.message);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, abortJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.key = new JobUpdateKey();
          struct.key.read(iprot);
          struct.setKeyIsSet(true);
        }
        if (incoming.get(1)) {
          struct.message = iprot.readString();
          struct.setMessageIsSet(true);
        }
      }
    }

  }

  public static class abortJobUpdate_result implements org.apache.thrift.TBase<abortJobUpdate_result, abortJobUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<abortJobUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("abortJobUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new abortJobUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new abortJobUpdate_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(abortJobUpdate_result.class, metaDataMap);
    }

    public abortJobUpdate_result() {
    }

    public abortJobUpdate_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public abortJobUpdate_result(abortJobUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public abortJobUpdate_result deepCopy() {
      return new abortJobUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public abortJobUpdate_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof abortJobUpdate_result)
        return this.equals((abortJobUpdate_result)that);
      return false;
    }

    public boolean equals(abortJobUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(abortJobUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("abortJobUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class abortJobUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public abortJobUpdate_resultStandardScheme getScheme() {
        return new abortJobUpdate_resultStandardScheme();
      }
    }

    private static class abortJobUpdate_resultStandardScheme extends StandardScheme<abortJobUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, abortJobUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, abortJobUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class abortJobUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public abortJobUpdate_resultTupleScheme getScheme() {
        return new abortJobUpdate_resultTupleScheme();
      }
    }

    private static class abortJobUpdate_resultTupleScheme extends TupleScheme<abortJobUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, abortJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, abortJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class rollbackJobUpdate_args implements org.apache.thrift.TBase<rollbackJobUpdate_args, rollbackJobUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<rollbackJobUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("rollbackJobUpdate_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField MESSAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("message", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new rollbackJobUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new rollbackJobUpdate_argsTupleSchemeFactory());
    }

    /**
     * The update to rollback.
     */
    public JobUpdateKey key; // required
    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String message; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * The update to rollback.
       */
      KEY((short)1, "key"),
      /**
       * A user-specified message to include with the induced job update state change.
       */
      MESSAGE((short)2, "message");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // MESSAGE
            return MESSAGE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobUpdateKey.class)));
      tmpMap.put(_Fields.MESSAGE, new org.apache.thrift.meta_data.FieldMetaData("message", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(rollbackJobUpdate_args.class, metaDataMap);
    }

    public rollbackJobUpdate_args() {
    }

    public rollbackJobUpdate_args(
      JobUpdateKey key,
      String message)
    {
      this();
      this.key = key;
      this.message = message;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public rollbackJobUpdate_args(rollbackJobUpdate_args other) {
      if (other.isSetKey()) {
        this.key = new JobUpdateKey(other.key);
      }
      if (other.isSetMessage()) {
        this.message = other.message;
      }
    }

    public rollbackJobUpdate_args deepCopy() {
      return new rollbackJobUpdate_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.message = null;
    }

    /**
     * The update to rollback.
     */
    public JobUpdateKey getKey() {
      return this.key;
    }

    /**
     * The update to rollback.
     */
    public rollbackJobUpdate_args setKey(JobUpdateKey key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public String getMessage() {
      return this.message;
    }

    /**
     * A user-specified message to include with the induced job update state change.
     */
    public rollbackJobUpdate_args setMessage(String message) {
      this.message = message;
      return this;
    }

    public void unsetMessage() {
      this.message = null;
    }

    /** Returns true if field message is set (has been assigned a value) and false otherwise */
    public boolean isSetMessage() {
      return this.message != null;
    }

    public void setMessageIsSet(boolean value) {
      if (!value) {
        this.message = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((JobUpdateKey)value);
        }
        break;

      case MESSAGE:
        if (value == null) {
          unsetMessage();
        } else {
          setMessage((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case MESSAGE:
        return getMessage();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case MESSAGE:
        return isSetMessage();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rollbackJobUpdate_args)
        return this.equals((rollbackJobUpdate_args)that);
      return false;
    }

    public boolean equals(rollbackJobUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_message = true && this.isSetMessage();
      boolean that_present_message = true && that.isSetMessage();
      if (this_present_message || that_present_message) {
        if (!(this_present_message && that_present_message))
          return false;
        if (!this.message.equals(that.message))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (isSetKey());
      list.add(present_key);
      if (present_key)
        list.add(key);

      boolean present_message = true && (isSetMessage());
      list.add(present_message);
      if (present_message)
        list.add(message);

      return list.hashCode();
    }

    @Override
    public int compareTo(rollbackJobUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(other.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMessage()).compareTo(other.isSetMessage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMessage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.message, other.message);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("rollbackJobUpdate_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("message:");
      if (this.message == null) {
        sb.append("null");
      } else {
        sb.append(this.message);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (key != null) {
        key.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class rollbackJobUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public rollbackJobUpdate_argsStandardScheme getScheme() {
        return new rollbackJobUpdate_argsStandardScheme();
      }
    }

    private static class rollbackJobUpdate_argsStandardScheme extends StandardScheme<rollbackJobUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, rollbackJobUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.key = new JobUpdateKey();
                struct.key.read(iprot);
                struct.setKeyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // MESSAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.message = iprot.readString();
                struct.setMessageIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, rollbackJobUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          struct.key.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.message != null) {
          oprot.writeFieldBegin(MESSAGE_FIELD_DESC);
          oprot.writeString(struct.message);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class rollbackJobUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public rollbackJobUpdate_argsTupleScheme getScheme() {
        return new rollbackJobUpdate_argsTupleScheme();
      }
    }

    private static class rollbackJobUpdate_argsTupleScheme extends TupleScheme<rollbackJobUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, rollbackJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetKey()) {
          optionals.set(0);
        }
        if (struct.isSetMessage()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetKey()) {
          struct.key.write(oprot);
        }
        if (struct.isSetMessage()) {
          oprot.writeString(struct.message);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, rollbackJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.key = new JobUpdateKey();
          struct.key.read(iprot);
          struct.setKeyIsSet(true);
        }
        if (incoming.get(1)) {
          struct.message = iprot.readString();
          struct.setMessageIsSet(true);
        }
      }
    }

  }

  public static class rollbackJobUpdate_result implements org.apache.thrift.TBase<rollbackJobUpdate_result, rollbackJobUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<rollbackJobUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("rollbackJobUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new rollbackJobUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new rollbackJobUpdate_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(rollbackJobUpdate_result.class, metaDataMap);
    }

    public rollbackJobUpdate_result() {
    }

    public rollbackJobUpdate_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public rollbackJobUpdate_result(rollbackJobUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public rollbackJobUpdate_result deepCopy() {
      return new rollbackJobUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public rollbackJobUpdate_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rollbackJobUpdate_result)
        return this.equals((rollbackJobUpdate_result)that);
      return false;
    }

    public boolean equals(rollbackJobUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(rollbackJobUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("rollbackJobUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class rollbackJobUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public rollbackJobUpdate_resultStandardScheme getScheme() {
        return new rollbackJobUpdate_resultStandardScheme();
      }
    }

    private static class rollbackJobUpdate_resultStandardScheme extends StandardScheme<rollbackJobUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, rollbackJobUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, rollbackJobUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class rollbackJobUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public rollbackJobUpdate_resultTupleScheme getScheme() {
        return new rollbackJobUpdate_resultTupleScheme();
      }
    }

    private static class rollbackJobUpdate_resultTupleScheme extends TupleScheme<rollbackJobUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, rollbackJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, rollbackJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class pulseJobUpdate_args implements org.apache.thrift.TBase<pulseJobUpdate_args, pulseJobUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<pulseJobUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("pulseJobUpdate_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new pulseJobUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new pulseJobUpdate_argsTupleSchemeFactory());
    }

    public JobUpdateKey key; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobUpdateKey.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(pulseJobUpdate_args.class, metaDataMap);
    }

    public pulseJobUpdate_args() {
    }

    public pulseJobUpdate_args(
      JobUpdateKey key)
    {
      this();
      this.key = key;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public pulseJobUpdate_args(pulseJobUpdate_args other) {
      if (other.isSetKey()) {
        this.key = new JobUpdateKey(other.key);
      }
    }

    public pulseJobUpdate_args deepCopy() {
      return new pulseJobUpdate_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
    }

    public JobUpdateKey getKey() {
      return this.key;
    }

    public pulseJobUpdate_args setKey(JobUpdateKey key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((JobUpdateKey)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof pulseJobUpdate_args)
        return this.equals((pulseJobUpdate_args)that);
      return false;
    }

    public boolean equals(pulseJobUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_key = true && (isSetKey());
      list.add(present_key);
      if (present_key)
        list.add(key);

      return list.hashCode();
    }

    @Override
    public int compareTo(pulseJobUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(other.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("pulseJobUpdate_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        sb.append(this.key);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (key != null) {
        key.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class pulseJobUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public pulseJobUpdate_argsStandardScheme getScheme() {
        return new pulseJobUpdate_argsStandardScheme();
      }
    }

    private static class pulseJobUpdate_argsStandardScheme extends StandardScheme<pulseJobUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, pulseJobUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // KEY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.key = new JobUpdateKey();
                struct.key.read(iprot);
                struct.setKeyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, pulseJobUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.key != null) {
          oprot.writeFieldBegin(KEY_FIELD_DESC);
          struct.key.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class pulseJobUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public pulseJobUpdate_argsTupleScheme getScheme() {
        return new pulseJobUpdate_argsTupleScheme();
      }
    }

    private static class pulseJobUpdate_argsTupleScheme extends TupleScheme<pulseJobUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, pulseJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetKey()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetKey()) {
          struct.key.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, pulseJobUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.key = new JobUpdateKey();
          struct.key.read(iprot);
          struct.setKeyIsSet(true);
        }
      }
    }

  }

  public static class pulseJobUpdate_result implements org.apache.thrift.TBase<pulseJobUpdate_result, pulseJobUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<pulseJobUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("pulseJobUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new pulseJobUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new pulseJobUpdate_resultTupleSchemeFactory());
    }

    public Response success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Response.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(pulseJobUpdate_result.class, metaDataMap);
    }

    public pulseJobUpdate_result() {
    }

    public pulseJobUpdate_result(
      Response success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public pulseJobUpdate_result(pulseJobUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new Response(other.success);
      }
    }

    public pulseJobUpdate_result deepCopy() {
      return new pulseJobUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public Response getSuccess() {
      return this.success;
    }

    public pulseJobUpdate_result setSuccess(Response success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Response)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof pulseJobUpdate_result)
        return this.equals((pulseJobUpdate_result)that);
      return false;
    }

    public boolean equals(pulseJobUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(pulseJobUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("pulseJobUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class pulseJobUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public pulseJobUpdate_resultStandardScheme getScheme() {
        return new pulseJobUpdate_resultStandardScheme();
      }
    }

    private static class pulseJobUpdate_resultStandardScheme extends StandardScheme<pulseJobUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, pulseJobUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Response();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, pulseJobUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class pulseJobUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public pulseJobUpdate_resultTupleScheme getScheme() {
        return new pulseJobUpdate_resultTupleScheme();
      }
    }

    private static class pulseJobUpdate_resultTupleScheme extends TupleScheme<pulseJobUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, pulseJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, pulseJobUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new Response();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

}
