/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
/**
 * Description of the tasks contained within a job.
 */
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)", date = "2016-10-21")
public class TaskConfig implements org.apache.thrift.TBase<TaskConfig, TaskConfig._Fields>, java.io.Serializable, Cloneable, Comparable<TaskConfig> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("TaskConfig");

  private static final org.apache.thrift.protocol.TField JOB_FIELD_DESC = new org.apache.thrift.protocol.TField("job", org.apache.thrift.protocol.TType.STRUCT, (short)28);
  private static final org.apache.thrift.protocol.TField OWNER_FIELD_DESC = new org.apache.thrift.protocol.TField("owner", org.apache.thrift.protocol.TType.STRUCT, (short)17);
  private static final org.apache.thrift.protocol.TField IS_SERVICE_FIELD_DESC = new org.apache.thrift.protocol.TField("isService", org.apache.thrift.protocol.TType.BOOL, (short)7);
  private static final org.apache.thrift.protocol.TField NUM_CPUS_FIELD_DESC = new org.apache.thrift.protocol.TField("numCpus", org.apache.thrift.protocol.TType.DOUBLE, (short)8);
  private static final org.apache.thrift.protocol.TField RAM_MB_FIELD_DESC = new org.apache.thrift.protocol.TField("ramMb", org.apache.thrift.protocol.TType.I64, (short)9);
  private static final org.apache.thrift.protocol.TField DISK_MB_FIELD_DESC = new org.apache.thrift.protocol.TField("diskMb", org.apache.thrift.protocol.TType.I64, (short)10);
  private static final org.apache.thrift.protocol.TField PRIORITY_FIELD_DESC = new org.apache.thrift.protocol.TField("priority", org.apache.thrift.protocol.TType.I32, (short)11);
  private static final org.apache.thrift.protocol.TField MAX_TASK_FAILURES_FIELD_DESC = new org.apache.thrift.protocol.TField("maxTaskFailures", org.apache.thrift.protocol.TType.I32, (short)13);
  private static final org.apache.thrift.protocol.TField PRODUCTION_FIELD_DESC = new org.apache.thrift.protocol.TField("production", org.apache.thrift.protocol.TType.BOOL, (short)18);
  private static final org.apache.thrift.protocol.TField TIER_FIELD_DESC = new org.apache.thrift.protocol.TField("tier", org.apache.thrift.protocol.TType.STRING, (short)30);
  private static final org.apache.thrift.protocol.TField RESOURCES_FIELD_DESC = new org.apache.thrift.protocol.TField("resources", org.apache.thrift.protocol.TType.SET, (short)32);
  private static final org.apache.thrift.protocol.TField CONSTRAINTS_FIELD_DESC = new org.apache.thrift.protocol.TField("constraints", org.apache.thrift.protocol.TType.SET, (short)20);
  private static final org.apache.thrift.protocol.TField REQUESTED_PORTS_FIELD_DESC = new org.apache.thrift.protocol.TField("requestedPorts", org.apache.thrift.protocol.TType.SET, (short)21);
  private static final org.apache.thrift.protocol.TField MESOS_FETCHER_URIS_FIELD_DESC = new org.apache.thrift.protocol.TField("mesosFetcherUris", org.apache.thrift.protocol.TType.SET, (short)33);
  private static final org.apache.thrift.protocol.TField TASK_LINKS_FIELD_DESC = new org.apache.thrift.protocol.TField("taskLinks", org.apache.thrift.protocol.TType.MAP, (short)22);
  private static final org.apache.thrift.protocol.TField CONTACT_EMAIL_FIELD_DESC = new org.apache.thrift.protocol.TField("contactEmail", org.apache.thrift.protocol.TType.STRING, (short)23);
  private static final org.apache.thrift.protocol.TField EXECUTOR_CONFIG_FIELD_DESC = new org.apache.thrift.protocol.TField("executorConfig", org.apache.thrift.protocol.TType.STRUCT, (short)25);
  private static final org.apache.thrift.protocol.TField METADATA_FIELD_DESC = new org.apache.thrift.protocol.TField("metadata", org.apache.thrift.protocol.TType.SET, (short)27);
  private static final org.apache.thrift.protocol.TField CONTAINER_FIELD_DESC = new org.apache.thrift.protocol.TField("container", org.apache.thrift.protocol.TType.STRUCT, (short)29);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new TaskConfigStandardSchemeFactory());
    schemes.put(TupleScheme.class, new TaskConfigTupleSchemeFactory());
  }

  /**
   * Job task belongs to.
   */
  public JobKey job; // required
  /**
   * contains the role component of JobKey
   */
  public Identity owner; // required
  public boolean isService; // required
  public double numCpus; // required
  public long ramMb; // required
  public long diskMb; // required
  public int priority; // required
  public int maxTaskFailures; // required
  /**
   * Whether this is a production task, which can preempt.
   */
  public boolean production; // optional
  /**
   * Task tier type.
   */
  public String tier; // optional
  /**
   * All resources required to run a task.
   */
  public Set<Resource> resources; // required
  public Set<Constraint> constraints; // required
  /**
   * a list of named ports this task requests
   */
  public Set<String> requestedPorts; // required
  /**
   * Resources to retrieve with Mesos Fetcher
   */
  public Set<MesosFetcherURI> mesosFetcherUris; // optional
  /**
   * Custom links to include when displaying this task on the scheduler dashboard. Keys are anchor
   * text, values are URLs. Wildcards are supported for dynamic link crafting based on host, ports,
   * instance, etc.
   */
  public Map<String,String> taskLinks; // optional
  public String contactEmail; // optional
  /**
   * Executor configuration
   */
  public ExecutorConfig executorConfig; // optional
  /**
   * Used to display additional details in the UI.
   */
  public Set<Metadata> metadata; // optional
  /**
   * the container the task should use to execute
   */
  public Container container; // required

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    /**
     * Job task belongs to.
     */
    JOB((short)28, "job"),
    /**
     * contains the role component of JobKey
     */
    OWNER((short)17, "owner"),
    IS_SERVICE((short)7, "isService"),
    NUM_CPUS((short)8, "numCpus"),
    RAM_MB((short)9, "ramMb"),
    DISK_MB((short)10, "diskMb"),
    PRIORITY((short)11, "priority"),
    MAX_TASK_FAILURES((short)13, "maxTaskFailures"),
    /**
     * Whether this is a production task, which can preempt.
     */
    PRODUCTION((short)18, "production"),
    /**
     * Task tier type.
     */
    TIER((short)30, "tier"),
    /**
     * All resources required to run a task.
     */
    RESOURCES((short)32, "resources"),
    CONSTRAINTS((short)20, "constraints"),
    /**
     * a list of named ports this task requests
     */
    REQUESTED_PORTS((short)21, "requestedPorts"),
    /**
     * Resources to retrieve with Mesos Fetcher
     */
    MESOS_FETCHER_URIS((short)33, "mesosFetcherUris"),
    /**
     * Custom links to include when displaying this task on the scheduler dashboard. Keys are anchor
     * text, values are URLs. Wildcards are supported for dynamic link crafting based on host, ports,
     * instance, etc.
     */
    TASK_LINKS((short)22, "taskLinks"),
    CONTACT_EMAIL((short)23, "contactEmail"),
    /**
     * Executor configuration
     */
    EXECUTOR_CONFIG((short)25, "executorConfig"),
    /**
     * Used to display additional details in the UI.
     */
    METADATA((short)27, "metadata"),
    /**
     * the container the task should use to execute
     */
    CONTAINER((short)29, "container");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 28: // JOB
          return JOB;
        case 17: // OWNER
          return OWNER;
        case 7: // IS_SERVICE
          return IS_SERVICE;
        case 8: // NUM_CPUS
          return NUM_CPUS;
        case 9: // RAM_MB
          return RAM_MB;
        case 10: // DISK_MB
          return DISK_MB;
        case 11: // PRIORITY
          return PRIORITY;
        case 13: // MAX_TASK_FAILURES
          return MAX_TASK_FAILURES;
        case 18: // PRODUCTION
          return PRODUCTION;
        case 30: // TIER
          return TIER;
        case 32: // RESOURCES
          return RESOURCES;
        case 20: // CONSTRAINTS
          return CONSTRAINTS;
        case 21: // REQUESTED_PORTS
          return REQUESTED_PORTS;
        case 33: // MESOS_FETCHER_URIS
          return MESOS_FETCHER_URIS;
        case 22: // TASK_LINKS
          return TASK_LINKS;
        case 23: // CONTACT_EMAIL
          return CONTACT_EMAIL;
        case 25: // EXECUTOR_CONFIG
          return EXECUTOR_CONFIG;
        case 27: // METADATA
          return METADATA;
        case 29: // CONTAINER
          return CONTAINER;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __ISSERVICE_ISSET_ID = 0;
  private static final int __NUMCPUS_ISSET_ID = 1;
  private static final int __RAMMB_ISSET_ID = 2;
  private static final int __DISKMB_ISSET_ID = 3;
  private static final int __PRIORITY_ISSET_ID = 4;
  private static final int __MAXTASKFAILURES_ISSET_ID = 5;
  private static final int __PRODUCTION_ISSET_ID = 6;
  private byte __isset_bitfield = 0;
  private static final _Fields optionals[] = {_Fields.PRODUCTION,_Fields.TIER,_Fields.MESOS_FETCHER_URIS,_Fields.TASK_LINKS,_Fields.CONTACT_EMAIL,_Fields.EXECUTOR_CONFIG,_Fields.METADATA};
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.JOB, new org.apache.thrift.meta_data.FieldMetaData("job", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobKey.class)));
    tmpMap.put(_Fields.OWNER, new org.apache.thrift.meta_data.FieldMetaData("owner", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Identity.class)));
    tmpMap.put(_Fields.IS_SERVICE, new org.apache.thrift.meta_data.FieldMetaData("isService", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    tmpMap.put(_Fields.NUM_CPUS, new org.apache.thrift.meta_data.FieldMetaData("numCpus", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.DOUBLE)));
    tmpMap.put(_Fields.RAM_MB, new org.apache.thrift.meta_data.FieldMetaData("ramMb", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.DISK_MB, new org.apache.thrift.meta_data.FieldMetaData("diskMb", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.PRIORITY, new org.apache.thrift.meta_data.FieldMetaData("priority", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(_Fields.MAX_TASK_FAILURES, new org.apache.thrift.meta_data.FieldMetaData("maxTaskFailures", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(_Fields.PRODUCTION, new org.apache.thrift.meta_data.FieldMetaData("production", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    tmpMap.put(_Fields.TIER, new org.apache.thrift.meta_data.FieldMetaData("tier", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.RESOURCES, new org.apache.thrift.meta_data.FieldMetaData("resources", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Resource.class))));
    tmpMap.put(_Fields.CONSTRAINTS, new org.apache.thrift.meta_data.FieldMetaData("constraints", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Constraint.class))));
    tmpMap.put(_Fields.REQUESTED_PORTS, new org.apache.thrift.meta_data.FieldMetaData("requestedPorts", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
    tmpMap.put(_Fields.MESOS_FETCHER_URIS, new org.apache.thrift.meta_data.FieldMetaData("mesosFetcherUris", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, MesosFetcherURI.class))));
    tmpMap.put(_Fields.TASK_LINKS, new org.apache.thrift.meta_data.FieldMetaData("taskLinks", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
    tmpMap.put(_Fields.CONTACT_EMAIL, new org.apache.thrift.meta_data.FieldMetaData("contactEmail", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.EXECUTOR_CONFIG, new org.apache.thrift.meta_data.FieldMetaData("executorConfig", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ExecutorConfig.class)));
    tmpMap.put(_Fields.METADATA, new org.apache.thrift.meta_data.FieldMetaData("metadata", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Metadata.class))));
    tmpMap.put(_Fields.CONTAINER, new org.apache.thrift.meta_data.FieldMetaData("container", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Container.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(TaskConfig.class, metaDataMap);
  }

  public TaskConfig() {
    this.container = new Container();
    MesosContainer tmp32 = new MesosContainer();

    this.container.setMesos(tmp32);

  }

  public TaskConfig(
    JobKey job,
    Identity owner,
    boolean isService,
    double numCpus,
    long ramMb,
    long diskMb,
    int priority,
    int maxTaskFailures,
    Set<Resource> resources,
    Set<Constraint> constraints,
    Set<String> requestedPorts,
    Container container)
  {
    this();
    this.job = job;
    this.owner = owner;
    this.isService = isService;
    setIsServiceIsSet(true);
    this.numCpus = numCpus;
    setNumCpusIsSet(true);
    this.ramMb = ramMb;
    setRamMbIsSet(true);
    this.diskMb = diskMb;
    setDiskMbIsSet(true);
    this.priority = priority;
    setPriorityIsSet(true);
    this.maxTaskFailures = maxTaskFailures;
    setMaxTaskFailuresIsSet(true);
    this.resources = resources;
    this.constraints = constraints;
    this.requestedPorts = requestedPorts;
    this.container = container;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public TaskConfig(TaskConfig other) {
    __isset_bitfield = other.__isset_bitfield;
    if (other.isSetJob()) {
      this.job = new JobKey(other.job);
    }
    if (other.isSetOwner()) {
      this.owner = new Identity(other.owner);
    }
    this.isService = other.isService;
    this.numCpus = other.numCpus;
    this.ramMb = other.ramMb;
    this.diskMb = other.diskMb;
    this.priority = other.priority;
    this.maxTaskFailures = other.maxTaskFailures;
    this.production = other.production;
    if (other.isSetTier()) {
      this.tier = other.tier;
    }
    if (other.isSetResources()) {
      Set<Resource> __this__resources = new HashSet<Resource>(other.resources.size());
      for (Resource other_element : other.resources) {
        __this__resources.add(new Resource(other_element));
      }
      this.resources = __this__resources;
    }
    if (other.isSetConstraints()) {
      Set<Constraint> __this__constraints = new HashSet<Constraint>(other.constraints.size());
      for (Constraint other_element : other.constraints) {
        __this__constraints.add(new Constraint(other_element));
      }
      this.constraints = __this__constraints;
    }
    if (other.isSetRequestedPorts()) {
      Set<String> __this__requestedPorts = new HashSet<String>(other.requestedPorts);
      this.requestedPorts = __this__requestedPorts;
    }
    if (other.isSetMesosFetcherUris()) {
      Set<MesosFetcherURI> __this__mesosFetcherUris = new HashSet<MesosFetcherURI>(other.mesosFetcherUris.size());
      for (MesosFetcherURI other_element : other.mesosFetcherUris) {
        __this__mesosFetcherUris.add(new MesosFetcherURI(other_element));
      }
      this.mesosFetcherUris = __this__mesosFetcherUris;
    }
    if (other.isSetTaskLinks()) {
      Map<String,String> __this__taskLinks = new HashMap<String,String>(other.taskLinks);
      this.taskLinks = __this__taskLinks;
    }
    if (other.isSetContactEmail()) {
      this.contactEmail = other.contactEmail;
    }
    if (other.isSetExecutorConfig()) {
      this.executorConfig = new ExecutorConfig(other.executorConfig);
    }
    if (other.isSetMetadata()) {
      Set<Metadata> __this__metadata = new HashSet<Metadata>(other.metadata.size());
      for (Metadata other_element : other.metadata) {
        __this__metadata.add(new Metadata(other_element));
      }
      this.metadata = __this__metadata;
    }
    if (other.isSetContainer()) {
      this.container = new Container(other.container);
    }
  }

  public TaskConfig deepCopy() {
    return new TaskConfig(this);
  }

  @Override
  public void clear() {
    this.job = null;
    this.owner = null;
    setIsServiceIsSet(false);
    this.isService = false;
    setNumCpusIsSet(false);
    this.numCpus = 0.0;
    setRamMbIsSet(false);
    this.ramMb = 0;
    setDiskMbIsSet(false);
    this.diskMb = 0;
    setPriorityIsSet(false);
    this.priority = 0;
    setMaxTaskFailuresIsSet(false);
    this.maxTaskFailures = 0;
    setProductionIsSet(false);
    this.production = false;
    this.tier = null;
    this.resources = null;
    this.constraints = null;
    this.requestedPorts = null;
    this.mesosFetcherUris = null;
    this.taskLinks = null;
    this.contactEmail = null;
    this.executorConfig = null;
    this.metadata = null;
    this.container = new Container();
    MesosContainer tmp33 = new MesosContainer();

    this.container.setMesos(tmp33);

  }

  /**
   * Job task belongs to.
   */
  public JobKey getJob() {
    return this.job;
  }

  /**
   * Job task belongs to.
   */
  public TaskConfig setJob(JobKey job) {
    this.job = job;
    return this;
  }

  public void unsetJob() {
    this.job = null;
  }

  /** Returns true if field job is set (has been assigned a value) and false otherwise */
  public boolean isSetJob() {
    return this.job != null;
  }

  public void setJobIsSet(boolean value) {
    if (!value) {
      this.job = null;
    }
  }

  /**
   * contains the role component of JobKey
   */
  public Identity getOwner() {
    return this.owner;
  }

  /**
   * contains the role component of JobKey
   */
  public TaskConfig setOwner(Identity owner) {
    this.owner = owner;
    return this;
  }

  public void unsetOwner() {
    this.owner = null;
  }

  /** Returns true if field owner is set (has been assigned a value) and false otherwise */
  public boolean isSetOwner() {
    return this.owner != null;
  }

  public void setOwnerIsSet(boolean value) {
    if (!value) {
      this.owner = null;
    }
  }

  public boolean isIsService() {
    return this.isService;
  }

  public TaskConfig setIsService(boolean isService) {
    this.isService = isService;
    setIsServiceIsSet(true);
    return this;
  }

  public void unsetIsService() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __ISSERVICE_ISSET_ID);
  }

  /** Returns true if field isService is set (has been assigned a value) and false otherwise */
  public boolean isSetIsService() {
    return EncodingUtils.testBit(__isset_bitfield, __ISSERVICE_ISSET_ID);
  }

  public void setIsServiceIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __ISSERVICE_ISSET_ID, value);
  }

  public double getNumCpus() {
    return this.numCpus;
  }

  public TaskConfig setNumCpus(double numCpus) {
    this.numCpus = numCpus;
    setNumCpusIsSet(true);
    return this;
  }

  public void unsetNumCpus() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __NUMCPUS_ISSET_ID);
  }

  /** Returns true if field numCpus is set (has been assigned a value) and false otherwise */
  public boolean isSetNumCpus() {
    return EncodingUtils.testBit(__isset_bitfield, __NUMCPUS_ISSET_ID);
  }

  public void setNumCpusIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __NUMCPUS_ISSET_ID, value);
  }

  public long getRamMb() {
    return this.ramMb;
  }

  public TaskConfig setRamMb(long ramMb) {
    this.ramMb = ramMb;
    setRamMbIsSet(true);
    return this;
  }

  public void unsetRamMb() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __RAMMB_ISSET_ID);
  }

  /** Returns true if field ramMb is set (has been assigned a value) and false otherwise */
  public boolean isSetRamMb() {
    return EncodingUtils.testBit(__isset_bitfield, __RAMMB_ISSET_ID);
  }

  public void setRamMbIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __RAMMB_ISSET_ID, value);
  }

  public long getDiskMb() {
    return this.diskMb;
  }

  public TaskConfig setDiskMb(long diskMb) {
    this.diskMb = diskMb;
    setDiskMbIsSet(true);
    return this;
  }

  public void unsetDiskMb() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __DISKMB_ISSET_ID);
  }

  /** Returns true if field diskMb is set (has been assigned a value) and false otherwise */
  public boolean isSetDiskMb() {
    return EncodingUtils.testBit(__isset_bitfield, __DISKMB_ISSET_ID);
  }

  public void setDiskMbIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __DISKMB_ISSET_ID, value);
  }

  public int getPriority() {
    return this.priority;
  }

  public TaskConfig setPriority(int priority) {
    this.priority = priority;
    setPriorityIsSet(true);
    return this;
  }

  public void unsetPriority() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PRIORITY_ISSET_ID);
  }

  /** Returns true if field priority is set (has been assigned a value) and false otherwise */
  public boolean isSetPriority() {
    return EncodingUtils.testBit(__isset_bitfield, __PRIORITY_ISSET_ID);
  }

  public void setPriorityIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PRIORITY_ISSET_ID, value);
  }

  public int getMaxTaskFailures() {
    return this.maxTaskFailures;
  }

  public TaskConfig setMaxTaskFailures(int maxTaskFailures) {
    this.maxTaskFailures = maxTaskFailures;
    setMaxTaskFailuresIsSet(true);
    return this;
  }

  public void unsetMaxTaskFailures() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __MAXTASKFAILURES_ISSET_ID);
  }

  /** Returns true if field maxTaskFailures is set (has been assigned a value) and false otherwise */
  public boolean isSetMaxTaskFailures() {
    return EncodingUtils.testBit(__isset_bitfield, __MAXTASKFAILURES_ISSET_ID);
  }

  public void setMaxTaskFailuresIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __MAXTASKFAILURES_ISSET_ID, value);
  }

  /**
   * Whether this is a production task, which can preempt.
   */
  public boolean isProduction() {
    return this.production;
  }

  /**
   * Whether this is a production task, which can preempt.
   */
  public TaskConfig setProduction(boolean production) {
    this.production = production;
    setProductionIsSet(true);
    return this;
  }

  public void unsetProduction() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PRODUCTION_ISSET_ID);
  }

  /** Returns true if field production is set (has been assigned a value) and false otherwise */
  public boolean isSetProduction() {
    return EncodingUtils.testBit(__isset_bitfield, __PRODUCTION_ISSET_ID);
  }

  public void setProductionIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PRODUCTION_ISSET_ID, value);
  }

  /**
   * Task tier type.
   */
  public String getTier() {
    return this.tier;
  }

  /**
   * Task tier type.
   */
  public TaskConfig setTier(String tier) {
    this.tier = tier;
    return this;
  }

  public void unsetTier() {
    this.tier = null;
  }

  /** Returns true if field tier is set (has been assigned a value) and false otherwise */
  public boolean isSetTier() {
    return this.tier != null;
  }

  public void setTierIsSet(boolean value) {
    if (!value) {
      this.tier = null;
    }
  }

  public int getResourcesSize() {
    return (this.resources == null) ? 0 : this.resources.size();
  }

  public java.util.Iterator<Resource> getResourcesIterator() {
    return (this.resources == null) ? null : this.resources.iterator();
  }

  public void addToResources(Resource elem) {
    if (this.resources == null) {
      this.resources = new HashSet<Resource>();
    }
    this.resources.add(elem);
  }

  /**
   * All resources required to run a task.
   */
  public Set<Resource> getResources() {
    return this.resources;
  }

  /**
   * All resources required to run a task.
   */
  public TaskConfig setResources(Set<Resource> resources) {
    this.resources = resources;
    return this;
  }

  public void unsetResources() {
    this.resources = null;
  }

  /** Returns true if field resources is set (has been assigned a value) and false otherwise */
  public boolean isSetResources() {
    return this.resources != null;
  }

  public void setResourcesIsSet(boolean value) {
    if (!value) {
      this.resources = null;
    }
  }

  public int getConstraintsSize() {
    return (this.constraints == null) ? 0 : this.constraints.size();
  }

  public java.util.Iterator<Constraint> getConstraintsIterator() {
    return (this.constraints == null) ? null : this.constraints.iterator();
  }

  public void addToConstraints(Constraint elem) {
    if (this.constraints == null) {
      this.constraints = new HashSet<Constraint>();
    }
    this.constraints.add(elem);
  }

  public Set<Constraint> getConstraints() {
    return this.constraints;
  }

  public TaskConfig setConstraints(Set<Constraint> constraints) {
    this.constraints = constraints;
    return this;
  }

  public void unsetConstraints() {
    this.constraints = null;
  }

  /** Returns true if field constraints is set (has been assigned a value) and false otherwise */
  public boolean isSetConstraints() {
    return this.constraints != null;
  }

  public void setConstraintsIsSet(boolean value) {
    if (!value) {
      this.constraints = null;
    }
  }

  public int getRequestedPortsSize() {
    return (this.requestedPorts == null) ? 0 : this.requestedPorts.size();
  }

  public java.util.Iterator<String> getRequestedPortsIterator() {
    return (this.requestedPorts == null) ? null : this.requestedPorts.iterator();
  }

  public void addToRequestedPorts(String elem) {
    if (this.requestedPorts == null) {
      this.requestedPorts = new HashSet<String>();
    }
    this.requestedPorts.add(elem);
  }

  /**
   * a list of named ports this task requests
   */
  public Set<String> getRequestedPorts() {
    return this.requestedPorts;
  }

  /**
   * a list of named ports this task requests
   */
  public TaskConfig setRequestedPorts(Set<String> requestedPorts) {
    this.requestedPorts = requestedPorts;
    return this;
  }

  public void unsetRequestedPorts() {
    this.requestedPorts = null;
  }

  /** Returns true if field requestedPorts is set (has been assigned a value) and false otherwise */
  public boolean isSetRequestedPorts() {
    return this.requestedPorts != null;
  }

  public void setRequestedPortsIsSet(boolean value) {
    if (!value) {
      this.requestedPorts = null;
    }
  }

  public int getMesosFetcherUrisSize() {
    return (this.mesosFetcherUris == null) ? 0 : this.mesosFetcherUris.size();
  }

  public java.util.Iterator<MesosFetcherURI> getMesosFetcherUrisIterator() {
    return (this.mesosFetcherUris == null) ? null : this.mesosFetcherUris.iterator();
  }

  public void addToMesosFetcherUris(MesosFetcherURI elem) {
    if (this.mesosFetcherUris == null) {
      this.mesosFetcherUris = new HashSet<MesosFetcherURI>();
    }
    this.mesosFetcherUris.add(elem);
  }

  /**
   * Resources to retrieve with Mesos Fetcher
   */
  public Set<MesosFetcherURI> getMesosFetcherUris() {
    return this.mesosFetcherUris;
  }

  /**
   * Resources to retrieve with Mesos Fetcher
   */
  public TaskConfig setMesosFetcherUris(Set<MesosFetcherURI> mesosFetcherUris) {
    this.mesosFetcherUris = mesosFetcherUris;
    return this;
  }

  public void unsetMesosFetcherUris() {
    this.mesosFetcherUris = null;
  }

  /** Returns true if field mesosFetcherUris is set (has been assigned a value) and false otherwise */
  public boolean isSetMesosFetcherUris() {
    return this.mesosFetcherUris != null;
  }

  public void setMesosFetcherUrisIsSet(boolean value) {
    if (!value) {
      this.mesosFetcherUris = null;
    }
  }

  public int getTaskLinksSize() {
    return (this.taskLinks == null) ? 0 : this.taskLinks.size();
  }

  public void putToTaskLinks(String key, String val) {
    if (this.taskLinks == null) {
      this.taskLinks = new HashMap<String,String>();
    }
    this.taskLinks.put(key, val);
  }

  /**
   * Custom links to include when displaying this task on the scheduler dashboard. Keys are anchor
   * text, values are URLs. Wildcards are supported for dynamic link crafting based on host, ports,
   * instance, etc.
   */
  public Map<String,String> getTaskLinks() {
    return this.taskLinks;
  }

  /**
   * Custom links to include when displaying this task on the scheduler dashboard. Keys are anchor
   * text, values are URLs. Wildcards are supported for dynamic link crafting based on host, ports,
   * instance, etc.
   */
  public TaskConfig setTaskLinks(Map<String,String> taskLinks) {
    this.taskLinks = taskLinks;
    return this;
  }

  public void unsetTaskLinks() {
    this.taskLinks = null;
  }

  /** Returns true if field taskLinks is set (has been assigned a value) and false otherwise */
  public boolean isSetTaskLinks() {
    return this.taskLinks != null;
  }

  public void setTaskLinksIsSet(boolean value) {
    if (!value) {
      this.taskLinks = null;
    }
  }

  public String getContactEmail() {
    return this.contactEmail;
  }

  public TaskConfig setContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
    return this;
  }

  public void unsetContactEmail() {
    this.contactEmail = null;
  }

  /** Returns true if field contactEmail is set (has been assigned a value) and false otherwise */
  public boolean isSetContactEmail() {
    return this.contactEmail != null;
  }

  public void setContactEmailIsSet(boolean value) {
    if (!value) {
      this.contactEmail = null;
    }
  }

  /**
   * Executor configuration
   */
  public ExecutorConfig getExecutorConfig() {
    return this.executorConfig;
  }

  /**
   * Executor configuration
   */
  public TaskConfig setExecutorConfig(ExecutorConfig executorConfig) {
    this.executorConfig = executorConfig;
    return this;
  }

  public void unsetExecutorConfig() {
    this.executorConfig = null;
  }

  /** Returns true if field executorConfig is set (has been assigned a value) and false otherwise */
  public boolean isSetExecutorConfig() {
    return this.executorConfig != null;
  }

  public void setExecutorConfigIsSet(boolean value) {
    if (!value) {
      this.executorConfig = null;
    }
  }

  public int getMetadataSize() {
    return (this.metadata == null) ? 0 : this.metadata.size();
  }

  public java.util.Iterator<Metadata> getMetadataIterator() {
    return (this.metadata == null) ? null : this.metadata.iterator();
  }

  public void addToMetadata(Metadata elem) {
    if (this.metadata == null) {
      this.metadata = new HashSet<Metadata>();
    }
    this.metadata.add(elem);
  }

  /**
   * Used to display additional details in the UI.
   */
  public Set<Metadata> getMetadata() {
    return this.metadata;
  }

  /**
   * Used to display additional details in the UI.
   */
  public TaskConfig setMetadata(Set<Metadata> metadata) {
    this.metadata = metadata;
    return this;
  }

  public void unsetMetadata() {
    this.metadata = null;
  }

  /** Returns true if field metadata is set (has been assigned a value) and false otherwise */
  public boolean isSetMetadata() {
    return this.metadata != null;
  }

  public void setMetadataIsSet(boolean value) {
    if (!value) {
      this.metadata = null;
    }
  }

  /**
   * the container the task should use to execute
   */
  public Container getContainer() {
    return this.container;
  }

  /**
   * the container the task should use to execute
   */
  public TaskConfig setContainer(Container container) {
    this.container = container;
    return this;
  }

  public void unsetContainer() {
    this.container = null;
  }

  /** Returns true if field container is set (has been assigned a value) and false otherwise */
  public boolean isSetContainer() {
    return this.container != null;
  }

  public void setContainerIsSet(boolean value) {
    if (!value) {
      this.container = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case JOB:
      if (value == null) {
        unsetJob();
      } else {
        setJob((JobKey)value);
      }
      break;

    case OWNER:
      if (value == null) {
        unsetOwner();
      } else {
        setOwner((Identity)value);
      }
      break;

    case IS_SERVICE:
      if (value == null) {
        unsetIsService();
      } else {
        setIsService((Boolean)value);
      }
      break;

    case NUM_CPUS:
      if (value == null) {
        unsetNumCpus();
      } else {
        setNumCpus((Double)value);
      }
      break;

    case RAM_MB:
      if (value == null) {
        unsetRamMb();
      } else {
        setRamMb((Long)value);
      }
      break;

    case DISK_MB:
      if (value == null) {
        unsetDiskMb();
      } else {
        setDiskMb((Long)value);
      }
      break;

    case PRIORITY:
      if (value == null) {
        unsetPriority();
      } else {
        setPriority((Integer)value);
      }
      break;

    case MAX_TASK_FAILURES:
      if (value == null) {
        unsetMaxTaskFailures();
      } else {
        setMaxTaskFailures((Integer)value);
      }
      break;

    case PRODUCTION:
      if (value == null) {
        unsetProduction();
      } else {
        setProduction((Boolean)value);
      }
      break;

    case TIER:
      if (value == null) {
        unsetTier();
      } else {
        setTier((String)value);
      }
      break;

    case RESOURCES:
      if (value == null) {
        unsetResources();
      } else {
        setResources((Set<Resource>)value);
      }
      break;

    case CONSTRAINTS:
      if (value == null) {
        unsetConstraints();
      } else {
        setConstraints((Set<Constraint>)value);
      }
      break;

    case REQUESTED_PORTS:
      if (value == null) {
        unsetRequestedPorts();
      } else {
        setRequestedPorts((Set<String>)value);
      }
      break;

    case MESOS_FETCHER_URIS:
      if (value == null) {
        unsetMesosFetcherUris();
      } else {
        setMesosFetcherUris((Set<MesosFetcherURI>)value);
      }
      break;

    case TASK_LINKS:
      if (value == null) {
        unsetTaskLinks();
      } else {
        setTaskLinks((Map<String,String>)value);
      }
      break;

    case CONTACT_EMAIL:
      if (value == null) {
        unsetContactEmail();
      } else {
        setContactEmail((String)value);
      }
      break;

    case EXECUTOR_CONFIG:
      if (value == null) {
        unsetExecutorConfig();
      } else {
        setExecutorConfig((ExecutorConfig)value);
      }
      break;

    case METADATA:
      if (value == null) {
        unsetMetadata();
      } else {
        setMetadata((Set<Metadata>)value);
      }
      break;

    case CONTAINER:
      if (value == null) {
        unsetContainer();
      } else {
        setContainer((Container)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case JOB:
      return getJob();

    case OWNER:
      return getOwner();

    case IS_SERVICE:
      return isIsService();

    case NUM_CPUS:
      return getNumCpus();

    case RAM_MB:
      return getRamMb();

    case DISK_MB:
      return getDiskMb();

    case PRIORITY:
      return getPriority();

    case MAX_TASK_FAILURES:
      return getMaxTaskFailures();

    case PRODUCTION:
      return isProduction();

    case TIER:
      return getTier();

    case RESOURCES:
      return getResources();

    case CONSTRAINTS:
      return getConstraints();

    case REQUESTED_PORTS:
      return getRequestedPorts();

    case MESOS_FETCHER_URIS:
      return getMesosFetcherUris();

    case TASK_LINKS:
      return getTaskLinks();

    case CONTACT_EMAIL:
      return getContactEmail();

    case EXECUTOR_CONFIG:
      return getExecutorConfig();

    case METADATA:
      return getMetadata();

    case CONTAINER:
      return getContainer();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case JOB:
      return isSetJob();
    case OWNER:
      return isSetOwner();
    case IS_SERVICE:
      return isSetIsService();
    case NUM_CPUS:
      return isSetNumCpus();
    case RAM_MB:
      return isSetRamMb();
    case DISK_MB:
      return isSetDiskMb();
    case PRIORITY:
      return isSetPriority();
    case MAX_TASK_FAILURES:
      return isSetMaxTaskFailures();
    case PRODUCTION:
      return isSetProduction();
    case TIER:
      return isSetTier();
    case RESOURCES:
      return isSetResources();
    case CONSTRAINTS:
      return isSetConstraints();
    case REQUESTED_PORTS:
      return isSetRequestedPorts();
    case MESOS_FETCHER_URIS:
      return isSetMesosFetcherUris();
    case TASK_LINKS:
      return isSetTaskLinks();
    case CONTACT_EMAIL:
      return isSetContactEmail();
    case EXECUTOR_CONFIG:
      return isSetExecutorConfig();
    case METADATA:
      return isSetMetadata();
    case CONTAINER:
      return isSetContainer();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof TaskConfig)
      return this.equals((TaskConfig)that);
    return false;
  }

  public boolean equals(TaskConfig that) {
    if (that == null)
      return false;

    boolean this_present_job = true && this.isSetJob();
    boolean that_present_job = true && that.isSetJob();
    if (this_present_job || that_present_job) {
      if (!(this_present_job && that_present_job))
        return false;
      if (!this.job.equals(that.job))
        return false;
    }

    boolean this_present_owner = true && this.isSetOwner();
    boolean that_present_owner = true && that.isSetOwner();
    if (this_present_owner || that_present_owner) {
      if (!(this_present_owner && that_present_owner))
        return false;
      if (!this.owner.equals(that.owner))
        return false;
    }

    boolean this_present_isService = true;
    boolean that_present_isService = true;
    if (this_present_isService || that_present_isService) {
      if (!(this_present_isService && that_present_isService))
        return false;
      if (this.isService != that.isService)
        return false;
    }

    boolean this_present_numCpus = true;
    boolean that_present_numCpus = true;
    if (this_present_numCpus || that_present_numCpus) {
      if (!(this_present_numCpus && that_present_numCpus))
        return false;
      if (this.numCpus != that.numCpus)
        return false;
    }

    boolean this_present_ramMb = true;
    boolean that_present_ramMb = true;
    if (this_present_ramMb || that_present_ramMb) {
      if (!(this_present_ramMb && that_present_ramMb))
        return false;
      if (this.ramMb != that.ramMb)
        return false;
    }

    boolean this_present_diskMb = true;
    boolean that_present_diskMb = true;
    if (this_present_diskMb || that_present_diskMb) {
      if (!(this_present_diskMb && that_present_diskMb))
        return false;
      if (this.diskMb != that.diskMb)
        return false;
    }

    boolean this_present_priority = true;
    boolean that_present_priority = true;
    if (this_present_priority || that_present_priority) {
      if (!(this_present_priority && that_present_priority))
        return false;
      if (this.priority != that.priority)
        return false;
    }

    boolean this_present_maxTaskFailures = true;
    boolean that_present_maxTaskFailures = true;
    if (this_present_maxTaskFailures || that_present_maxTaskFailures) {
      if (!(this_present_maxTaskFailures && that_present_maxTaskFailures))
        return false;
      if (this.maxTaskFailures != that.maxTaskFailures)
        return false;
    }

    boolean this_present_production = true && this.isSetProduction();
    boolean that_present_production = true && that.isSetProduction();
    if (this_present_production || that_present_production) {
      if (!(this_present_production && that_present_production))
        return false;
      if (this.production != that.production)
        return false;
    }

    boolean this_present_tier = true && this.isSetTier();
    boolean that_present_tier = true && that.isSetTier();
    if (this_present_tier || that_present_tier) {
      if (!(this_present_tier && that_present_tier))
        return false;
      if (!this.tier.equals(that.tier))
        return false;
    }

    boolean this_present_resources = true && this.isSetResources();
    boolean that_present_resources = true && that.isSetResources();
    if (this_present_resources || that_present_resources) {
      if (!(this_present_resources && that_present_resources))
        return false;
      if (!this.resources.equals(that.resources))
        return false;
    }

    boolean this_present_constraints = true && this.isSetConstraints();
    boolean that_present_constraints = true && that.isSetConstraints();
    if (this_present_constraints || that_present_constraints) {
      if (!(this_present_constraints && that_present_constraints))
        return false;
      if (!this.constraints.equals(that.constraints))
        return false;
    }

    boolean this_present_requestedPorts = true && this.isSetRequestedPorts();
    boolean that_present_requestedPorts = true && that.isSetRequestedPorts();
    if (this_present_requestedPorts || that_present_requestedPorts) {
      if (!(this_present_requestedPorts && that_present_requestedPorts))
        return false;
      if (!this.requestedPorts.equals(that.requestedPorts))
        return false;
    }

    boolean this_present_mesosFetcherUris = true && this.isSetMesosFetcherUris();
    boolean that_present_mesosFetcherUris = true && that.isSetMesosFetcherUris();
    if (this_present_mesosFetcherUris || that_present_mesosFetcherUris) {
      if (!(this_present_mesosFetcherUris && that_present_mesosFetcherUris))
        return false;
      if (!this.mesosFetcherUris.equals(that.mesosFetcherUris))
        return false;
    }

    boolean this_present_taskLinks = true && this.isSetTaskLinks();
    boolean that_present_taskLinks = true && that.isSetTaskLinks();
    if (this_present_taskLinks || that_present_taskLinks) {
      if (!(this_present_taskLinks && that_present_taskLinks))
        return false;
      if (!this.taskLinks.equals(that.taskLinks))
        return false;
    }

    boolean this_present_contactEmail = true && this.isSetContactEmail();
    boolean that_present_contactEmail = true && that.isSetContactEmail();
    if (this_present_contactEmail || that_present_contactEmail) {
      if (!(this_present_contactEmail && that_present_contactEmail))
        return false;
      if (!this.contactEmail.equals(that.contactEmail))
        return false;
    }

    boolean this_present_executorConfig = true && this.isSetExecutorConfig();
    boolean that_present_executorConfig = true && that.isSetExecutorConfig();
    if (this_present_executorConfig || that_present_executorConfig) {
      if (!(this_present_executorConfig && that_present_executorConfig))
        return false;
      if (!this.executorConfig.equals(that.executorConfig))
        return false;
    }

    boolean this_present_metadata = true && this.isSetMetadata();
    boolean that_present_metadata = true && that.isSetMetadata();
    if (this_present_metadata || that_present_metadata) {
      if (!(this_present_metadata && that_present_metadata))
        return false;
      if (!this.metadata.equals(that.metadata))
        return false;
    }

    boolean this_present_container = true && this.isSetContainer();
    boolean that_present_container = true && that.isSetContainer();
    if (this_present_container || that_present_container) {
      if (!(this_present_container && that_present_container))
        return false;
      if (!this.container.equals(that.container))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_job = true && (isSetJob());
    list.add(present_job);
    if (present_job)
      list.add(job);

    boolean present_owner = true && (isSetOwner());
    list.add(present_owner);
    if (present_owner)
      list.add(owner);

    boolean present_isService = true;
    list.add(present_isService);
    if (present_isService)
      list.add(isService);

    boolean present_numCpus = true;
    list.add(present_numCpus);
    if (present_numCpus)
      list.add(numCpus);

    boolean present_ramMb = true;
    list.add(present_ramMb);
    if (present_ramMb)
      list.add(ramMb);

    boolean present_diskMb = true;
    list.add(present_diskMb);
    if (present_diskMb)
      list.add(diskMb);

    boolean present_priority = true;
    list.add(present_priority);
    if (present_priority)
      list.add(priority);

    boolean present_maxTaskFailures = true;
    list.add(present_maxTaskFailures);
    if (present_maxTaskFailures)
      list.add(maxTaskFailures);

    boolean present_production = true && (isSetProduction());
    list.add(present_production);
    if (present_production)
      list.add(production);

    boolean present_tier = true && (isSetTier());
    list.add(present_tier);
    if (present_tier)
      list.add(tier);

    boolean present_resources = true && (isSetResources());
    list.add(present_resources);
    if (present_resources)
      list.add(resources);

    boolean present_constraints = true && (isSetConstraints());
    list.add(present_constraints);
    if (present_constraints)
      list.add(constraints);

    boolean present_requestedPorts = true && (isSetRequestedPorts());
    list.add(present_requestedPorts);
    if (present_requestedPorts)
      list.add(requestedPorts);

    boolean present_mesosFetcherUris = true && (isSetMesosFetcherUris());
    list.add(present_mesosFetcherUris);
    if (present_mesosFetcherUris)
      list.add(mesosFetcherUris);

    boolean present_taskLinks = true && (isSetTaskLinks());
    list.add(present_taskLinks);
    if (present_taskLinks)
      list.add(taskLinks);

    boolean present_contactEmail = true && (isSetContactEmail());
    list.add(present_contactEmail);
    if (present_contactEmail)
      list.add(contactEmail);

    boolean present_executorConfig = true && (isSetExecutorConfig());
    list.add(present_executorConfig);
    if (present_executorConfig)
      list.add(executorConfig);

    boolean present_metadata = true && (isSetMetadata());
    list.add(present_metadata);
    if (present_metadata)
      list.add(metadata);

    boolean present_container = true && (isSetContainer());
    list.add(present_container);
    if (present_container)
      list.add(container);

    return list.hashCode();
  }

  @Override
  public int compareTo(TaskConfig other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetJob()).compareTo(other.isSetJob());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetJob()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.job, other.job);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetOwner()).compareTo(other.isSetOwner());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetOwner()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.owner, other.owner);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetIsService()).compareTo(other.isSetIsService());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetIsService()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.isService, other.isService);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetNumCpus()).compareTo(other.isSetNumCpus());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetNumCpus()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numCpus, other.numCpus);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetRamMb()).compareTo(other.isSetRamMb());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetRamMb()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ramMb, other.ramMb);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetDiskMb()).compareTo(other.isSetDiskMb());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetDiskMb()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.diskMb, other.diskMb);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetPriority()).compareTo(other.isSetPriority());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetPriority()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.priority, other.priority);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMaxTaskFailures()).compareTo(other.isSetMaxTaskFailures());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMaxTaskFailures()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.maxTaskFailures, other.maxTaskFailures);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetProduction()).compareTo(other.isSetProduction());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProduction()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.production, other.production);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetTier()).compareTo(other.isSetTier());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTier()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tier, other.tier);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetResources()).compareTo(other.isSetResources());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetResources()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.resources, other.resources);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetConstraints()).compareTo(other.isSetConstraints());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetConstraints()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.constraints, other.constraints);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetRequestedPorts()).compareTo(other.isSetRequestedPorts());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetRequestedPorts()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.requestedPorts, other.requestedPorts);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMesosFetcherUris()).compareTo(other.isSetMesosFetcherUris());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMesosFetcherUris()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mesosFetcherUris, other.mesosFetcherUris);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetTaskLinks()).compareTo(other.isSetTaskLinks());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTaskLinks()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.taskLinks, other.taskLinks);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetContactEmail()).compareTo(other.isSetContactEmail());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetContactEmail()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.contactEmail, other.contactEmail);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetExecutorConfig()).compareTo(other.isSetExecutorConfig());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetExecutorConfig()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.executorConfig, other.executorConfig);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMetadata()).compareTo(other.isSetMetadata());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMetadata()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.metadata, other.metadata);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetContainer()).compareTo(other.isSetContainer());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetContainer()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.container, other.container);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("TaskConfig(");
    boolean first = true;

    sb.append("job:");
    if (this.job == null) {
      sb.append("null");
    } else {
      sb.append(this.job);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("owner:");
    if (this.owner == null) {
      sb.append("null");
    } else {
      sb.append(this.owner);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("isService:");
    sb.append(this.isService);
    first = false;
    if (!first) sb.append(", ");
    sb.append("numCpus:");
    sb.append(this.numCpus);
    first = false;
    if (!first) sb.append(", ");
    sb.append("ramMb:");
    sb.append(this.ramMb);
    first = false;
    if (!first) sb.append(", ");
    sb.append("diskMb:");
    sb.append(this.diskMb);
    first = false;
    if (!first) sb.append(", ");
    sb.append("priority:");
    sb.append(this.priority);
    first = false;
    if (!first) sb.append(", ");
    sb.append("maxTaskFailures:");
    sb.append(this.maxTaskFailures);
    first = false;
    if (isSetProduction()) {
      if (!first) sb.append(", ");
      sb.append("production:");
      sb.append(this.production);
      first = false;
    }
    if (isSetTier()) {
      if (!first) sb.append(", ");
      sb.append("tier:");
      if (this.tier == null) {
        sb.append("null");
      } else {
        sb.append(this.tier);
      }
      first = false;
    }
    if (!first) sb.append(", ");
    sb.append("resources:");
    if (this.resources == null) {
      sb.append("null");
    } else {
      sb.append(this.resources);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("constraints:");
    if (this.constraints == null) {
      sb.append("null");
    } else {
      sb.append(this.constraints);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("requestedPorts:");
    if (this.requestedPorts == null) {
      sb.append("null");
    } else {
      sb.append(this.requestedPorts);
    }
    first = false;
    if (isSetMesosFetcherUris()) {
      if (!first) sb.append(", ");
      sb.append("mesosFetcherUris:");
      if (this.mesosFetcherUris == null) {
        sb.append("null");
      } else {
        sb.append(this.mesosFetcherUris);
      }
      first = false;
    }
    if (isSetTaskLinks()) {
      if (!first) sb.append(", ");
      sb.append("taskLinks:");
      if (this.taskLinks == null) {
        sb.append("null");
      } else {
        sb.append(this.taskLinks);
      }
      first = false;
    }
    if (isSetContactEmail()) {
      if (!first) sb.append(", ");
      sb.append("contactEmail:");
      if (this.contactEmail == null) {
        sb.append("null");
      } else {
        sb.append(this.contactEmail);
      }
      first = false;
    }
    if (isSetExecutorConfig()) {
      if (!first) sb.append(", ");
      sb.append("executorConfig:");
      if (this.executorConfig == null) {
        sb.append("null");
      } else {
        sb.append(this.executorConfig);
      }
      first = false;
    }
    if (isSetMetadata()) {
      if (!first) sb.append(", ");
      sb.append("metadata:");
      if (this.metadata == null) {
        sb.append("null");
      } else {
        sb.append(this.metadata);
      }
      first = false;
    }
    if (!first) sb.append(", ");
    sb.append("container:");
    if (this.container == null) {
      sb.append("null");
    } else {
      sb.append(this.container);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    // check for sub-struct validity
    if (job != null) {
      job.validate();
    }
    if (owner != null) {
      owner.validate();
    }
    if (executorConfig != null) {
      executorConfig.validate();
    }
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
      __isset_bitfield = 0;
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class TaskConfigStandardSchemeFactory implements SchemeFactory {
    public TaskConfigStandardScheme getScheme() {
      return new TaskConfigStandardScheme();
    }
  }

  private static class TaskConfigStandardScheme extends StandardScheme<TaskConfig> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, TaskConfig struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 28: // JOB
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.job = new JobKey();
              struct.job.read(iprot);
              struct.setJobIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 17: // OWNER
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.owner = new Identity();
              struct.owner.read(iprot);
              struct.setOwnerIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // IS_SERVICE
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.isService = iprot.readBool();
              struct.setIsServiceIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // NUM_CPUS
            if (schemeField.type == org.apache.thrift.protocol.TType.DOUBLE) {
              struct.numCpus = iprot.readDouble();
              struct.setNumCpusIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 9: // RAM_MB
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.ramMb = iprot.readI64();
              struct.setRamMbIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 10: // DISK_MB
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.diskMb = iprot.readI64();
              struct.setDiskMbIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 11: // PRIORITY
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.priority = iprot.readI32();
              struct.setPriorityIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 13: // MAX_TASK_FAILURES
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.maxTaskFailures = iprot.readI32();
              struct.setMaxTaskFailuresIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 18: // PRODUCTION
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.production = iprot.readBool();
              struct.setProductionIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 30: // TIER
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.tier = iprot.readString();
              struct.setTierIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 32: // RESOURCES
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set34 = iprot.readSetBegin();
                struct.resources = new HashSet<Resource>(2*_set34.size);
                Resource _elem35;
                for (int _i36 = 0; _i36 < _set34.size; ++_i36)
                {
                  _elem35 = new Resource();
                  _elem35.read(iprot);
                  struct.resources.add(_elem35);
                }
                iprot.readSetEnd();
              }
              struct.setResourcesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 20: // CONSTRAINTS
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set37 = iprot.readSetBegin();
                struct.constraints = new HashSet<Constraint>(2*_set37.size);
                Constraint _elem38;
                for (int _i39 = 0; _i39 < _set37.size; ++_i39)
                {
                  _elem38 = new Constraint();
                  _elem38.read(iprot);
                  struct.constraints.add(_elem38);
                }
                iprot.readSetEnd();
              }
              struct.setConstraintsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 21: // REQUESTED_PORTS
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set40 = iprot.readSetBegin();
                struct.requestedPorts = new HashSet<String>(2*_set40.size);
                String _elem41;
                for (int _i42 = 0; _i42 < _set40.size; ++_i42)
                {
                  _elem41 = iprot.readString();
                  struct.requestedPorts.add(_elem41);
                }
                iprot.readSetEnd();
              }
              struct.setRequestedPortsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 33: // MESOS_FETCHER_URIS
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set43 = iprot.readSetBegin();
                struct.mesosFetcherUris = new HashSet<MesosFetcherURI>(2*_set43.size);
                MesosFetcherURI _elem44;
                for (int _i45 = 0; _i45 < _set43.size; ++_i45)
                {
                  _elem44 = new MesosFetcherURI();
                  _elem44.read(iprot);
                  struct.mesosFetcherUris.add(_elem44);
                }
                iprot.readSetEnd();
              }
              struct.setMesosFetcherUrisIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 22: // TASK_LINKS
            if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map46 = iprot.readMapBegin();
                struct.taskLinks = new HashMap<String,String>(2*_map46.size);
                String _key47;
                String _val48;
                for (int _i49 = 0; _i49 < _map46.size; ++_i49)
                {
                  _key47 = iprot.readString();
                  _val48 = iprot.readString();
                  struct.taskLinks.put(_key47, _val48);
                }
                iprot.readMapEnd();
              }
              struct.setTaskLinksIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 23: // CONTACT_EMAIL
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.contactEmail = iprot.readString();
              struct.setContactEmailIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 25: // EXECUTOR_CONFIG
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.executorConfig = new ExecutorConfig();
              struct.executorConfig.read(iprot);
              struct.setExecutorConfigIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 27: // METADATA
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set50 = iprot.readSetBegin();
                struct.metadata = new HashSet<Metadata>(2*_set50.size);
                Metadata _elem51;
                for (int _i52 = 0; _i52 < _set50.size; ++_i52)
                {
                  _elem51 = new Metadata();
                  _elem51.read(iprot);
                  struct.metadata.add(_elem51);
                }
                iprot.readSetEnd();
              }
              struct.setMetadataIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 29: // CONTAINER
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.container = new Container();
              struct.container.read(iprot);
              struct.setContainerIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, TaskConfig struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldBegin(IS_SERVICE_FIELD_DESC);
      oprot.writeBool(struct.isService);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(NUM_CPUS_FIELD_DESC);
      oprot.writeDouble(struct.numCpus);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(RAM_MB_FIELD_DESC);
      oprot.writeI64(struct.ramMb);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(DISK_MB_FIELD_DESC);
      oprot.writeI64(struct.diskMb);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(PRIORITY_FIELD_DESC);
      oprot.writeI32(struct.priority);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(MAX_TASK_FAILURES_FIELD_DESC);
      oprot.writeI32(struct.maxTaskFailures);
      oprot.writeFieldEnd();
      if (struct.owner != null) {
        oprot.writeFieldBegin(OWNER_FIELD_DESC);
        struct.owner.write(oprot);
        oprot.writeFieldEnd();
      }
      if (struct.isSetProduction()) {
        oprot.writeFieldBegin(PRODUCTION_FIELD_DESC);
        oprot.writeBool(struct.production);
        oprot.writeFieldEnd();
      }
      if (struct.constraints != null) {
        oprot.writeFieldBegin(CONSTRAINTS_FIELD_DESC);
        {
          oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, struct.constraints.size()));
          for (Constraint _iter53 : struct.constraints)
          {
            _iter53.write(oprot);
          }
          oprot.writeSetEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.requestedPorts != null) {
        oprot.writeFieldBegin(REQUESTED_PORTS_FIELD_DESC);
        {
          oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, struct.requestedPorts.size()));
          for (String _iter54 : struct.requestedPorts)
          {
            oprot.writeString(_iter54);
          }
          oprot.writeSetEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.taskLinks != null) {
        if (struct.isSetTaskLinks()) {
          oprot.writeFieldBegin(TASK_LINKS_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.taskLinks.size()));
            for (Map.Entry<String, String> _iter55 : struct.taskLinks.entrySet())
            {
              oprot.writeString(_iter55.getKey());
              oprot.writeString(_iter55.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.contactEmail != null) {
        if (struct.isSetContactEmail()) {
          oprot.writeFieldBegin(CONTACT_EMAIL_FIELD_DESC);
          oprot.writeString(struct.contactEmail);
          oprot.writeFieldEnd();
        }
      }
      if (struct.executorConfig != null) {
        if (struct.isSetExecutorConfig()) {
          oprot.writeFieldBegin(EXECUTOR_CONFIG_FIELD_DESC);
          struct.executorConfig.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      if (struct.metadata != null) {
        if (struct.isSetMetadata()) {
          oprot.writeFieldBegin(METADATA_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, struct.metadata.size()));
            for (Metadata _iter56 : struct.metadata)
            {
              _iter56.write(oprot);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.job != null) {
        oprot.writeFieldBegin(JOB_FIELD_DESC);
        struct.job.write(oprot);
        oprot.writeFieldEnd();
      }
      if (struct.container != null) {
        oprot.writeFieldBegin(CONTAINER_FIELD_DESC);
        struct.container.write(oprot);
        oprot.writeFieldEnd();
      }
      if (struct.tier != null) {
        if (struct.isSetTier()) {
          oprot.writeFieldBegin(TIER_FIELD_DESC);
          oprot.writeString(struct.tier);
          oprot.writeFieldEnd();
        }
      }
      if (struct.resources != null) {
        oprot.writeFieldBegin(RESOURCES_FIELD_DESC);
        {
          oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, struct.resources.size()));
          for (Resource _iter57 : struct.resources)
          {
            _iter57.write(oprot);
          }
          oprot.writeSetEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.mesosFetcherUris != null) {
        if (struct.isSetMesosFetcherUris()) {
          oprot.writeFieldBegin(MESOS_FETCHER_URIS_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, struct.mesosFetcherUris.size()));
            for (MesosFetcherURI _iter58 : struct.mesosFetcherUris)
            {
              _iter58.write(oprot);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class TaskConfigTupleSchemeFactory implements SchemeFactory {
    public TaskConfigTupleScheme getScheme() {
      return new TaskConfigTupleScheme();
    }
  }

  private static class TaskConfigTupleScheme extends TupleScheme<TaskConfig> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, TaskConfig struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      BitSet optionals = new BitSet();
      if (struct.isSetJob()) {
        optionals.set(0);
      }
      if (struct.isSetOwner()) {
        optionals.set(1);
      }
      if (struct.isSetIsService()) {
        optionals.set(2);
      }
      if (struct.isSetNumCpus()) {
        optionals.set(3);
      }
      if (struct.isSetRamMb()) {
        optionals.set(4);
      }
      if (struct.isSetDiskMb()) {
        optionals.set(5);
      }
      if (struct.isSetPriority()) {
        optionals.set(6);
      }
      if (struct.isSetMaxTaskFailures()) {
        optionals.set(7);
      }
      if (struct.isSetProduction()) {
        optionals.set(8);
      }
      if (struct.isSetTier()) {
        optionals.set(9);
      }
      if (struct.isSetResources()) {
        optionals.set(10);
      }
      if (struct.isSetConstraints()) {
        optionals.set(11);
      }
      if (struct.isSetRequestedPorts()) {
        optionals.set(12);
      }
      if (struct.isSetMesosFetcherUris()) {
        optionals.set(13);
      }
      if (struct.isSetTaskLinks()) {
        optionals.set(14);
      }
      if (struct.isSetContactEmail()) {
        optionals.set(15);
      }
      if (struct.isSetExecutorConfig()) {
        optionals.set(16);
      }
      if (struct.isSetMetadata()) {
        optionals.set(17);
      }
      if (struct.isSetContainer()) {
        optionals.set(18);
      }
      oprot.writeBitSet(optionals, 19);
      if (struct.isSetJob()) {
        struct.job.write(oprot);
      }
      if (struct.isSetOwner()) {
        struct.owner.write(oprot);
      }
      if (struct.isSetIsService()) {
        oprot.writeBool(struct.isService);
      }
      if (struct.isSetNumCpus()) {
        oprot.writeDouble(struct.numCpus);
      }
      if (struct.isSetRamMb()) {
        oprot.writeI64(struct.ramMb);
      }
      if (struct.isSetDiskMb()) {
        oprot.writeI64(struct.diskMb);
      }
      if (struct.isSetPriority()) {
        oprot.writeI32(struct.priority);
      }
      if (struct.isSetMaxTaskFailures()) {
        oprot.writeI32(struct.maxTaskFailures);
      }
      if (struct.isSetProduction()) {
        oprot.writeBool(struct.production);
      }
      if (struct.isSetTier()) {
        oprot.writeString(struct.tier);
      }
      if (struct.isSetResources()) {
        {
          oprot.writeI32(struct.resources.size());
          for (Resource _iter59 : struct.resources)
          {
            _iter59.write(oprot);
          }
        }
      }
      if (struct.isSetConstraints()) {
        {
          oprot.writeI32(struct.constraints.size());
          for (Constraint _iter60 : struct.constraints)
          {
            _iter60.write(oprot);
          }
        }
      }
      if (struct.isSetRequestedPorts()) {
        {
          oprot.writeI32(struct.requestedPorts.size());
          for (String _iter61 : struct.requestedPorts)
          {
            oprot.writeString(_iter61);
          }
        }
      }
      if (struct.isSetMesosFetcherUris()) {
        {
          oprot.writeI32(struct.mesosFetcherUris.size());
          for (MesosFetcherURI _iter62 : struct.mesosFetcherUris)
          {
            _iter62.write(oprot);
          }
        }
      }
      if (struct.isSetTaskLinks()) {
        {
          oprot.writeI32(struct.taskLinks.size());
          for (Map.Entry<String, String> _iter63 : struct.taskLinks.entrySet())
          {
            oprot.writeString(_iter63.getKey());
            oprot.writeString(_iter63.getValue());
          }
        }
      }
      if (struct.isSetContactEmail()) {
        oprot.writeString(struct.contactEmail);
      }
      if (struct.isSetExecutorConfig()) {
        struct.executorConfig.write(oprot);
      }
      if (struct.isSetMetadata()) {
        {
          oprot.writeI32(struct.metadata.size());
          for (Metadata _iter64 : struct.metadata)
          {
            _iter64.write(oprot);
          }
        }
      }
      if (struct.isSetContainer()) {
        struct.container.write(oprot);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, TaskConfig struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      BitSet incoming = iprot.readBitSet(19);
      if (incoming.get(0)) {
        struct.job = new JobKey();
        struct.job.read(iprot);
        struct.setJobIsSet(true);
      }
      if (incoming.get(1)) {
        struct.owner = new Identity();
        struct.owner.read(iprot);
        struct.setOwnerIsSet(true);
      }
      if (incoming.get(2)) {
        struct.isService = iprot.readBool();
        struct.setIsServiceIsSet(true);
      }
      if (incoming.get(3)) {
        struct.numCpus = iprot.readDouble();
        struct.setNumCpusIsSet(true);
      }
      if (incoming.get(4)) {
        struct.ramMb = iprot.readI64();
        struct.setRamMbIsSet(true);
      }
      if (incoming.get(5)) {
        struct.diskMb = iprot.readI64();
        struct.setDiskMbIsSet(true);
      }
      if (incoming.get(6)) {
        struct.priority = iprot.readI32();
        struct.setPriorityIsSet(true);
      }
      if (incoming.get(7)) {
        struct.maxTaskFailures = iprot.readI32();
        struct.setMaxTaskFailuresIsSet(true);
      }
      if (incoming.get(8)) {
        struct.production = iprot.readBool();
        struct.setProductionIsSet(true);
      }
      if (incoming.get(9)) {
        struct.tier = iprot.readString();
        struct.setTierIsSet(true);
      }
      if (incoming.get(10)) {
        {
          org.apache.thrift.protocol.TSet _set65 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.resources = new HashSet<Resource>(2*_set65.size);
          Resource _elem66;
          for (int _i67 = 0; _i67 < _set65.size; ++_i67)
          {
            _elem66 = new Resource();
            _elem66.read(iprot);
            struct.resources.add(_elem66);
          }
        }
        struct.setResourcesIsSet(true);
      }
      if (incoming.get(11)) {
        {
          org.apache.thrift.protocol.TSet _set68 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.constraints = new HashSet<Constraint>(2*_set68.size);
          Constraint _elem69;
          for (int _i70 = 0; _i70 < _set68.size; ++_i70)
          {
            _elem69 = new Constraint();
            _elem69.read(iprot);
            struct.constraints.add(_elem69);
          }
        }
        struct.setConstraintsIsSet(true);
      }
      if (incoming.get(12)) {
        {
          org.apache.thrift.protocol.TSet _set71 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.requestedPorts = new HashSet<String>(2*_set71.size);
          String _elem72;
          for (int _i73 = 0; _i73 < _set71.size; ++_i73)
          {
            _elem72 = iprot.readString();
            struct.requestedPorts.add(_elem72);
          }
        }
        struct.setRequestedPortsIsSet(true);
      }
      if (incoming.get(13)) {
        {
          org.apache.thrift.protocol.TSet _set74 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.mesosFetcherUris = new HashSet<MesosFetcherURI>(2*_set74.size);
          MesosFetcherURI _elem75;
          for (int _i76 = 0; _i76 < _set74.size; ++_i76)
          {
            _elem75 = new MesosFetcherURI();
            _elem75.read(iprot);
            struct.mesosFetcherUris.add(_elem75);
          }
        }
        struct.setMesosFetcherUrisIsSet(true);
      }
      if (incoming.get(14)) {
        {
          org.apache.thrift.protocol.TMap _map77 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.taskLinks = new HashMap<String,String>(2*_map77.size);
          String _key78;
          String _val79;
          for (int _i80 = 0; _i80 < _map77.size; ++_i80)
          {
            _key78 = iprot.readString();
            _val79 = iprot.readString();
            struct.taskLinks.put(_key78, _val79);
          }
        }
        struct.setTaskLinksIsSet(true);
      }
      if (incoming.get(15)) {
        struct.contactEmail = iprot.readString();
        struct.setContactEmailIsSet(true);
      }
      if (incoming.get(16)) {
        struct.executorConfig = new ExecutorConfig();
        struct.executorConfig.read(iprot);
        struct.setExecutorConfigIsSet(true);
      }
      if (incoming.get(17)) {
        {
          org.apache.thrift.protocol.TSet _set81 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.metadata = new HashSet<Metadata>(2*_set81.size);
          Metadata _elem82;
          for (int _i83 = 0; _i83 < _set81.size; ++_i83)
          {
            _elem82 = new Metadata();
            _elem82.read(iprot);
            struct.metadata.add(_elem82);
          }
        }
        struct.setMetadataIsSet(true);
      }
      if (incoming.get(18)) {
        struct.container = new Container();
        struct.container.read(iprot);
        struct.setContainerIsSet(true);
      }
    }
  }

}

