/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.dbevent;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.dbevent.CrudType;
import org.apache.airavata.model.dbevent.EntityType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class DBEventPublisherContext
implements TBase<DBEventPublisherContext, _Fields>,
Serializable,
Cloneable,
Comparable<DBEventPublisherContext> {
    private static final TStruct STRUCT_DESC = new TStruct("DBEventPublisherContext");
    private static final TField CRUD_TYPE_FIELD_DESC = new TField("crudType", 8, 1);
    private static final TField ENTITY_TYPE_FIELD_DESC = new TField("entityType", 8, 2);
    private static final TField ENTITY_DATA_MODEL_FIELD_DESC = new TField("entityDataModel", 11, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private CrudType crudType;
    private EntityType entityType;
    private ByteBuffer entityDataModel;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DBEventPublisherContext() {
    }

    public DBEventPublisherContext(CrudType crudType, EntityType entityType, ByteBuffer entityDataModel) {
        this();
        this.crudType = crudType;
        this.entityType = entityType;
        this.entityDataModel = TBaseHelper.copyBinary((ByteBuffer)entityDataModel);
    }

    public DBEventPublisherContext(DBEventPublisherContext other) {
        if (other.isSetCrudType()) {
            this.crudType = other.crudType;
        }
        if (other.isSetEntityType()) {
            this.entityType = other.entityType;
        }
        if (other.isSetEntityDataModel()) {
            this.entityDataModel = TBaseHelper.copyBinary((ByteBuffer)other.entityDataModel);
        }
    }

    public DBEventPublisherContext deepCopy() {
        return new DBEventPublisherContext(this);
    }

    public void clear() {
        this.crudType = null;
        this.entityType = null;
        this.entityDataModel = null;
    }

    public CrudType getCrudType() {
        return this.crudType;
    }

    public void setCrudType(CrudType crudType) {
        this.crudType = crudType;
    }

    public void unsetCrudType() {
        this.crudType = null;
    }

    public boolean isSetCrudType() {
        return this.crudType != null;
    }

    public void setCrudTypeIsSet(boolean value) {
        if (!value) {
            this.crudType = null;
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void unsetEntityType() {
        this.entityType = null;
    }

    public boolean isSetEntityType() {
        return this.entityType != null;
    }

    public void setEntityTypeIsSet(boolean value) {
        if (!value) {
            this.entityType = null;
        }
    }

    public byte[] getEntityDataModel() {
        this.setEntityDataModel(TBaseHelper.rightSize((ByteBuffer)this.entityDataModel));
        return this.entityDataModel == null ? null : this.entityDataModel.array();
    }

    public ByteBuffer bufferForEntityDataModel() {
        return TBaseHelper.copyBinary((ByteBuffer)this.entityDataModel);
    }

    public void setEntityDataModel(byte[] entityDataModel) {
        this.entityDataModel = entityDataModel == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(entityDataModel, entityDataModel.length));
    }

    public void setEntityDataModel(ByteBuffer entityDataModel) {
        this.entityDataModel = TBaseHelper.copyBinary((ByteBuffer)entityDataModel);
    }

    public void unsetEntityDataModel() {
        this.entityDataModel = null;
    }

    public boolean isSetEntityDataModel() {
        return this.entityDataModel != null;
    }

    public void setEntityDataModelIsSet(boolean value) {
        if (!value) {
            this.entityDataModel = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case CRUD_TYPE: {
                if (value == null) {
                    this.unsetCrudType();
                    break;
                }
                this.setCrudType((CrudType)((Object)value));
                break;
            }
            case ENTITY_TYPE: {
                if (value == null) {
                    this.unsetEntityType();
                    break;
                }
                this.setEntityType((EntityType)((Object)value));
                break;
            }
            case ENTITY_DATA_MODEL: {
                if (value == null) {
                    this.unsetEntityDataModel();
                    break;
                }
                this.setEntityDataModel((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CRUD_TYPE: {
                return this.getCrudType();
            }
            case ENTITY_TYPE: {
                return this.getEntityType();
            }
            case ENTITY_DATA_MODEL: {
                return this.getEntityDataModel();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CRUD_TYPE: {
                return this.isSetCrudType();
            }
            case ENTITY_TYPE: {
                return this.isSetEntityType();
            }
            case ENTITY_DATA_MODEL: {
                return this.isSetEntityDataModel();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof DBEventPublisherContext) {
            return this.equals((DBEventPublisherContext)that);
        }
        return false;
    }

    public boolean equals(DBEventPublisherContext that) {
        if (that == null) {
            return false;
        }
        boolean this_present_crudType = this.isSetCrudType();
        boolean that_present_crudType = that.isSetCrudType();
        if (this_present_crudType || that_present_crudType) {
            if (!this_present_crudType || !that_present_crudType) {
                return false;
            }
            if (!this.crudType.equals((Object)that.crudType)) {
                return false;
            }
        }
        boolean this_present_entityType = this.isSetEntityType();
        boolean that_present_entityType = that.isSetEntityType();
        if (this_present_entityType || that_present_entityType) {
            if (!this_present_entityType || !that_present_entityType) {
                return false;
            }
            if (!this.entityType.equals((Object)that.entityType)) {
                return false;
            }
        }
        boolean this_present_entityDataModel = this.isSetEntityDataModel();
        boolean that_present_entityDataModel = that.isSetEntityDataModel();
        if (this_present_entityDataModel || that_present_entityDataModel) {
            if (!this_present_entityDataModel || !that_present_entityDataModel) {
                return false;
            }
            if (!this.entityDataModel.equals(that.entityDataModel)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_crudType = this.isSetCrudType();
        list.add(Boolean.valueOf(present_crudType));
        if (present_crudType) {
            list.add(Integer.valueOf(this.crudType.getValue()));
        }
        boolean present_entityType = this.isSetEntityType();
        list.add(Boolean.valueOf(present_entityType));
        if (present_entityType) {
            list.add(Integer.valueOf(this.entityType.getValue()));
        }
        boolean present_entityDataModel = this.isSetEntityDataModel();
        list.add(Boolean.valueOf(present_entityDataModel));
        if (present_entityDataModel) {
            list.add(this.entityDataModel);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(DBEventPublisherContext other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCrudType()).compareTo(other.isSetCrudType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCrudType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.crudType), (Comparable)((Object)other.crudType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEntityType()).compareTo(other.isSetEntityType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEntityType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.entityType), (Comparable)((Object)other.entityType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEntityDataModel()).compareTo(other.isSetEntityDataModel());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEntityDataModel() && (lastComparison = TBaseHelper.compareTo((Comparable)this.entityDataModel, (Comparable)other.entityDataModel)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DBEventPublisherContext(");
        boolean first = true;
        sb.append("crudType:");
        if (this.crudType == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.crudType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("entityType:");
        if (this.entityType == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.entityType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("entityDataModel:");
        if (this.entityDataModel == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.entityDataModel, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetCrudType()) {
            throw new TProtocolException("Required field 'crudType' is unset! Struct:" + this.toString());
        }
        if (!this.isSetEntityType()) {
            throw new TProtocolException("Required field 'entityType' is unset! Struct:" + this.toString());
        }
        if (!this.isSetEntityDataModel()) {
            throw new TProtocolException("Required field 'entityDataModel' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new DBEventPublisherContextStandardSchemeFactory());
        schemes.put(TupleScheme.class, new DBEventPublisherContextTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CRUD_TYPE, new FieldMetaData("crudType", 1, (FieldValueMetaData)new EnumMetaData(16, CrudType.class)));
        tmpMap.put(_Fields.ENTITY_TYPE, new FieldMetaData("entityType", 1, (FieldValueMetaData)new EnumMetaData(16, EntityType.class)));
        tmpMap.put(_Fields.ENTITY_DATA_MODEL, new FieldMetaData("entityDataModel", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DBEventPublisherContext.class, metaDataMap);
    }

    private static class DBEventPublisherContextTupleScheme
    extends TupleScheme<DBEventPublisherContext> {
        private DBEventPublisherContextTupleScheme() {
        }

        public void write(TProtocol prot, DBEventPublisherContext struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.crudType.getValue());
            oprot.writeI32(struct.entityType.getValue());
            oprot.writeBinary(struct.entityDataModel);
        }

        public void read(TProtocol prot, DBEventPublisherContext struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.crudType = CrudType.findByValue(iprot.readI32());
            struct.setCrudTypeIsSet(true);
            struct.entityType = EntityType.findByValue(iprot.readI32());
            struct.setEntityTypeIsSet(true);
            struct.entityDataModel = iprot.readBinary();
            struct.setEntityDataModelIsSet(true);
        }
    }

    private static class DBEventPublisherContextTupleSchemeFactory
    implements SchemeFactory {
        private DBEventPublisherContextTupleSchemeFactory() {
        }

        public DBEventPublisherContextTupleScheme getScheme() {
            return new DBEventPublisherContextTupleScheme();
        }
    }

    private static class DBEventPublisherContextStandardScheme
    extends StandardScheme<DBEventPublisherContext> {
        private DBEventPublisherContextStandardScheme() {
        }

        public void read(TProtocol iprot, DBEventPublisherContext struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.crudType = CrudType.findByValue(iprot.readI32());
                            struct.setCrudTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.entityType = EntityType.findByValue(iprot.readI32());
                            struct.setEntityTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.entityDataModel = iprot.readBinary();
                            struct.setEntityDataModelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, DBEventPublisherContext struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.crudType != null) {
                oprot.writeFieldBegin(CRUD_TYPE_FIELD_DESC);
                oprot.writeI32(struct.crudType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.entityType != null) {
                oprot.writeFieldBegin(ENTITY_TYPE_FIELD_DESC);
                oprot.writeI32(struct.entityType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.entityDataModel != null) {
                oprot.writeFieldBegin(ENTITY_DATA_MODEL_FIELD_DESC);
                oprot.writeBinary(struct.entityDataModel);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class DBEventPublisherContextStandardSchemeFactory
    implements SchemeFactory {
        private DBEventPublisherContextStandardSchemeFactory() {
        }

        public DBEventPublisherContextStandardScheme getScheme() {
            return new DBEventPublisherContextStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CRUD_TYPE(1, "crudType"),
        ENTITY_TYPE(2, "entityType"),
        ENTITY_DATA_MODEL(3, "entityDataModel");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CRUD_TYPE;
                }
                case 2: {
                    return ENTITY_TYPE;
                }
                case 3: {
                    return ENTITY_DATA_MODEL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

