/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.CloseStatusFilter;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ExecutionTimeFilter;
import com.amazonaws.services.simpleworkflow.model.TagFilter;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionFilter;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CountClosedWorkflowExecutionsRequestMarshaller
implements Marshaller<Request<CountClosedWorkflowExecutionsRequest>, CountClosedWorkflowExecutionsRequest> {
    public Request<CountClosedWorkflowExecutionsRequest> marshall(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) {
        if (countClosedWorkflowExecutionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)countClosedWorkflowExecutionsRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.CountClosedWorkflowExecutions";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            CloseStatusFilter closeStatusFilter;
            TagFilter tagFilter;
            WorkflowTypeFilter typeFilter;
            WorkflowExecutionFilter executionFilter;
            ExecutionTimeFilter closeTimeFilter;
            ExecutionTimeFilter startTimeFilter;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (countClosedWorkflowExecutionsRequest.getDomain() != null) {
                jsonWriter.key("domain").value((Object)countClosedWorkflowExecutionsRequest.getDomain());
            }
            if ((startTimeFilter = countClosedWorkflowExecutionsRequest.getStartTimeFilter()) != null) {
                jsonWriter.key("startTimeFilter");
                jsonWriter.object();
                if (startTimeFilter.getOldestDate() != null) {
                    jsonWriter.key("oldestDate").value(startTimeFilter.getOldestDate());
                }
                if (startTimeFilter.getLatestDate() != null) {
                    jsonWriter.key("latestDate").value(startTimeFilter.getLatestDate());
                }
                jsonWriter.endObject();
            }
            if ((closeTimeFilter = countClosedWorkflowExecutionsRequest.getCloseTimeFilter()) != null) {
                jsonWriter.key("closeTimeFilter");
                jsonWriter.object();
                if (closeTimeFilter.getOldestDate() != null) {
                    jsonWriter.key("oldestDate").value(closeTimeFilter.getOldestDate());
                }
                if (closeTimeFilter.getLatestDate() != null) {
                    jsonWriter.key("latestDate").value(closeTimeFilter.getLatestDate());
                }
                jsonWriter.endObject();
            }
            if ((executionFilter = countClosedWorkflowExecutionsRequest.getExecutionFilter()) != null) {
                jsonWriter.key("executionFilter");
                jsonWriter.object();
                if (executionFilter.getWorkflowId() != null) {
                    jsonWriter.key("workflowId").value((Object)executionFilter.getWorkflowId());
                }
                jsonWriter.endObject();
            }
            if ((typeFilter = countClosedWorkflowExecutionsRequest.getTypeFilter()) != null) {
                jsonWriter.key("typeFilter");
                jsonWriter.object();
                if (typeFilter.getName() != null) {
                    jsonWriter.key("name").value((Object)typeFilter.getName());
                }
                if (typeFilter.getVersion() != null) {
                    jsonWriter.key("version").value((Object)typeFilter.getVersion());
                }
                jsonWriter.endObject();
            }
            if ((tagFilter = countClosedWorkflowExecutionsRequest.getTagFilter()) != null) {
                jsonWriter.key("tagFilter");
                jsonWriter.object();
                if (tagFilter.getTag() != null) {
                    jsonWriter.key("tag").value((Object)tagFilter.getTag());
                }
                jsonWriter.endObject();
            }
            if ((closeStatusFilter = countClosedWorkflowExecutionsRequest.getCloseStatusFilter()) != null) {
                jsonWriter.key("closeStatusFilter");
                jsonWriter.object();
                if (closeStatusFilter.getStatus() != null) {
                    jsonWriter.key("status").value((Object)closeStatusFilter.getStatus());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

