/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.model.appcatalog.computeresource.BatchQueue;
import org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.FileSystems;
import org.apache.airavata.model.appcatalog.computeresource.GlobusJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.JobManagerCommand;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.data.movement.DMType;
import org.apache.airavata.model.data.movement.DataMovementInterface;
import org.apache.airavata.model.data.movement.GridFTPDataMovement;
import org.apache.airavata.model.data.movement.LOCALDataMovement;
import org.apache.airavata.model.data.movement.SCPDataMovement;
import org.apache.airavata.model.data.movement.UnicoreDataMovement;
import org.apache.airavata.model.parallelism.ApplicationParallelismType;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.BatchQueueResource;
import org.apache.airavata.registry.core.app.catalog.resources.CloudSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceFileSystemResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.DataMovementInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpEndpointResource;
import org.apache.airavata.registry.core.app.catalog.resources.HostAliasAppResource;
import org.apache.airavata.registry.core.app.catalog.resources.HostIPAddressResource;
import org.apache.airavata.registry.core.app.catalog.resources.JobManagerCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.JobSubmissionInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.ParallelismPrefixCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.ResourceJobManagerResource;
import org.apache.airavata.registry.core.app.catalog.resources.ScpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.SshJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogThriftConversion;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogUtils;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ComputeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeResourceImpl
implements ComputeResource {
    private static final Logger logger = LoggerFactory.getLogger(ComputeResourceImpl.class);

    public String addComputeResource(ComputeResourceDescription description) throws AppCatalogException {
        try {
            if (description.getComputeResourceId().equals("") || description.getComputeResourceId().equals("DO_NOT_SET_AT_CLIENTS")) {
                description.setComputeResourceId(AppCatalogUtils.getID(description.getHostName()));
            }
            return this.saveComputeResourceDescriptorData(description);
        }
        catch (Exception e) {
            logger.error("Error while saving compute resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    protected String saveComputeResourceDescriptorData(ComputeResourceDescription description) throws AppCatalogException {
        ComputeResourceResource computeHostResource = this.saveComputeResource(description);
        this.saveHostAliases(description, computeHostResource);
        this.saveIpAddresses(description, computeHostResource);
        this.saveBatchQueues(description, computeHostResource);
        this.saveFileSystems(description, computeHostResource);
        this.saveJobSubmissionInterfaces(description, computeHostResource);
        this.saveDataMovementInterfaces(description, computeHostResource);
        return computeHostResource.getResourceId();
    }

    protected ComputeResourceResource saveComputeResource(ComputeResourceDescription description) throws AppCatalogException {
        ComputeResourceResource computeHostResource = AppCatalogThriftConversion.getComputeHostResource(description);
        computeHostResource.save();
        return computeHostResource;
    }

    protected void saveDataMovementInterfaces(ComputeResourceDescription description, ComputeResourceResource computeHostResource) throws AppCatalogException {
        List dataMovemenetInterfaces = description.getDataMovementInterfaces();
        if (dataMovemenetInterfaces != null && !dataMovemenetInterfaces.isEmpty()) {
            for (DataMovementInterface dataMovementInterface : dataMovemenetInterfaces) {
                DataMovementInterfaceResource dmir = AppCatalogThriftConversion.getDataMovementInterfaceResource(dataMovementInterface);
                dmir.setComputeHostResource(computeHostResource);
                dmir.setComputeResourceId(computeHostResource.getResourceId());
                dmir.save();
            }
        }
    }

    protected void saveJobSubmissionInterfaces(ComputeResourceDescription description, ComputeResourceResource computeHostResource) throws AppCatalogException {
        List jobSubmissionInterfaces = description.getJobSubmissionInterfaces();
        if (jobSubmissionInterfaces != null && !jobSubmissionInterfaces.isEmpty()) {
            for (JobSubmissionInterface jobSubmissionInterface : jobSubmissionInterfaces) {
                JobSubmissionInterfaceResource jsir = AppCatalogThriftConversion.getJobSubmissionInterface(jobSubmissionInterface);
                jsir.setComputeHostResource(computeHostResource);
                jsir.setComputeResourceId(computeHostResource.getResourceId());
                jsir.save();
            }
        }
    }

    protected void saveFileSystems(ComputeResourceDescription description, ComputeResourceResource computeHostResource) throws AppCatalogException {
        Map fileSystems = description.getFileSystems();
        if (fileSystems != null && !fileSystems.isEmpty()) {
            for (FileSystems key : fileSystems.keySet()) {
                ComputeResourceFileSystemResource computeResourceFileSystemResource = new ComputeResourceFileSystemResource();
                computeResourceFileSystemResource.setComputeHostResource(computeHostResource);
                computeResourceFileSystemResource.setComputeResourceId(computeHostResource.getResourceId());
                computeResourceFileSystemResource.setFileSystem(key.toString());
                computeResourceFileSystemResource.setPath((String)fileSystems.get(key));
                computeResourceFileSystemResource.save();
            }
        }
    }

    protected void saveBatchQueues(ComputeResourceDescription description, ComputeResourceResource computeHostResource) throws AppCatalogException {
        List batchQueueList = description.getBatchQueues();
        if (batchQueueList != null && !batchQueueList.isEmpty()) {
            for (BatchQueue batchQueue : batchQueueList) {
                BatchQueueResource bq = AppCatalogThriftConversion.getBatchQueue(batchQueue);
                bq.setComputeResourceId(computeHostResource.getResourceId());
                bq.setComputeHostResource(computeHostResource);
                bq.save();
            }
        }
    }

    protected void saveIpAddresses(ComputeResourceDescription description, ComputeResourceResource computeHostResource) throws AppCatalogException {
        List ipAddresses = description.getIpAddresses();
        HostIPAddressResource resource = new HostIPAddressResource();
        resource.remove(description.getComputeResourceId());
        if (ipAddresses != null && !ipAddresses.isEmpty()) {
            for (String ipAddress : ipAddresses) {
                HostIPAddressResource ipAddressResource = new HostIPAddressResource();
                ipAddressResource.setComputeHostResource(computeHostResource);
                ipAddressResource.setResourceID(computeHostResource.getResourceId());
                ipAddressResource.setIpaddress(ipAddress);
                ipAddressResource.save();
            }
        }
    }

    protected void saveHostAliases(ComputeResourceDescription description, ComputeResourceResource computeHostResource) throws AppCatalogException {
        List hostAliases = description.getHostAliases();
        HostAliasAppResource resource = new HostAliasAppResource();
        resource.remove(description.getComputeResourceId());
        if (hostAliases != null && !hostAliases.isEmpty()) {
            for (String alias : hostAliases) {
                HostAliasAppResource aliasResource = new HostAliasAppResource();
                aliasResource.setComputeHostResource(computeHostResource);
                aliasResource.setResourceID(computeHostResource.getResourceId());
                aliasResource.setAlias(alias);
                aliasResource.save();
            }
        }
    }

    public void updateComputeResource(String computeResourceId, ComputeResourceDescription updatedComputeResource) throws AppCatalogException {
        try {
            this.saveComputeResourceDescriptorData(updatedComputeResource);
        }
        catch (Exception e) {
            logger.error("Error while updating compute resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addSSHJobSubmission(SSHJobSubmission sshJobSubmission) throws AppCatalogException {
        try {
            String submissionId = AppCatalogUtils.getID("SSH");
            sshJobSubmission.setJobSubmissionInterfaceId(submissionId);
            String resourceJobManagerId = this.addResourceJobManager(sshJobSubmission.getResourceJobManager());
            SshJobSubmissionResource resource = AppCatalogThriftConversion.getSSHJobSubmission(sshJobSubmission);
            resource.setResourceJobManagerId(resourceJobManagerId);
            resource.getResourceJobManagerResource().setResourceJobManagerId(resourceJobManagerId);
            if (sshJobSubmission.getMonitorMode() != null) {
                resource.setMonitorMode(sshJobSubmission.getMonitorMode().toString());
            }
            resource.save();
            return submissionId;
        }
        catch (Exception e) {
            logger.error("Error while saving SSH Job Submission...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addCloudJobSubmission(CloudJobSubmission cloudJobSubmission) throws AppCatalogException {
        try {
            cloudJobSubmission.setJobSubmissionInterfaceId(AppCatalogUtils.getID("Cloud"));
            CloudSubmissionResource resource = AppCatalogThriftConversion.getCloudJobSubmission(cloudJobSubmission);
            resource.save();
            return resource.getJobSubmissionInterfaceId();
        }
        catch (Exception e) {
            logger.error("Error while saving SSH Job Submission...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addUNICOREJobSubmission(UnicoreJobSubmission unicoreJobSubmission) throws AppCatalogException {
        try {
            unicoreJobSubmission.setJobSubmissionInterfaceId(AppCatalogUtils.getID("UNICORE"));
            UnicoreJobSubmissionResource resource = AppCatalogThriftConversion.getUnicoreJobSubmission(unicoreJobSubmission);
            resource.setUnicoreEndpointUrl(unicoreJobSubmission.getUnicoreEndPointURL());
            if (unicoreJobSubmission.getSecurityProtocol() != null) {
                resource.setSecurityProtocol(unicoreJobSubmission.getSecurityProtocol().toString());
            }
            resource.save();
            return resource.getjobSubmissionInterfaceId();
        }
        catch (Exception e) {
            logger.error("Error while retrieving SSH Job Submission...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addJobSubmissionProtocol(String computeResourceId, JobSubmissionInterface jobSubmissionInterface) throws AppCatalogException {
        try {
            JobSubmissionInterfaceResource jsi = AppCatalogThriftConversion.getJobSubmissionInterface(jobSubmissionInterface);
            jsi.setComputeResourceId(computeResourceId);
            ComputeResourceResource computeResourceResource = new ComputeResourceResource();
            computeResourceResource = (ComputeResourceResource)computeResourceResource.get(computeResourceId);
            jsi.setComputeHostResource(computeResourceResource);
            jsi.save();
            return jsi.getJobSubmissionInterfaceId();
        }
        catch (Exception e) {
            logger.error("Error while saving " + jobSubmissionInterface.getJobSubmissionProtocol().toString() + " Job Submission Protocol...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addGlobusJobSubmission(GlobusJobSubmission globusJobSubmission) throws AppCatalogException {
        return null;
    }

    public String addScpDataMovement(SCPDataMovement scpDataMovement) throws AppCatalogException {
        try {
            scpDataMovement.setDataMovementInterfaceId(AppCatalogUtils.getID("SCP"));
            ScpDataMovementResource resource = AppCatalogThriftConversion.getSCPDataMovementDescription(scpDataMovement);
            resource.save();
            return resource.getDataMovementInterfaceId();
        }
        catch (Exception e) {
            logger.error("Error while saving SCP Data Movement...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addUnicoreDataMovement(UnicoreDataMovement unicoreDataMovement) throws AppCatalogException {
        try {
            unicoreDataMovement.setDataMovementInterfaceId(AppCatalogUtils.getID("UNICORE"));
            UnicoreDataMovementResource resource = AppCatalogThriftConversion.getUnicoreDMResource(unicoreDataMovement);
            resource.save();
            return resource.getDataMovementId();
        }
        catch (Exception e) {
            logger.error("Error while saving UNICORE Data Movement...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addDataMovementProtocol(String resourceId, DMType dmType, DataMovementInterface dataMovementInterface) throws AppCatalogException {
        try {
            String dmId = null;
            if (dmType.equals((Object)DMType.COMPUTE_RESOURCE)) {
                DataMovementInterfaceResource dmi = AppCatalogThriftConversion.getDataMovementInterfaceResource(dataMovementInterface);
                dmi.setComputeResourceId(resourceId);
                ComputeResourceResource computeResourceResource = new ComputeResourceResource();
                computeResourceResource = (ComputeResourceResource)computeResourceResource.get(resourceId);
                dmi.setComputeHostResource(computeResourceResource);
                dmi.save();
                dmId = dmi.getDataMovementInterfaceId();
            } else if (dmType.equals((Object)DMType.STORAGE_RESOURCE)) {
                StorageInterfaceResource storageInterface = AppCatalogThriftConversion.getStorageInterface(dataMovementInterface);
                storageInterface.setStorageResourceId(resourceId);
                StorageResourceResource storageResourceResource = new StorageResourceResource();
                storageResourceResource = (StorageResourceResource)storageResourceResource.get(resourceId);
                storageInterface.setStorageResourceResource(storageResourceResource);
                storageInterface.save();
                dmId = storageInterface.getDataMovementInterfaceId();
            }
            return dmId;
        }
        catch (Exception e) {
            logger.error("Error while saving " + dataMovementInterface.getDataMovementProtocol().toString() + " data movement Protocol...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addGridFTPDataMovement(GridFTPDataMovement gridFTPDataMovement) throws AppCatalogException {
        try {
            gridFTPDataMovement.setDataMovementInterfaceId(AppCatalogUtils.getID("GRIDFTP"));
            GridftpDataMovementResource resource = AppCatalogThriftConversion.getGridFTPDataMovementDescription(gridFTPDataMovement);
            resource.save();
            List gridFTPEndPoint = gridFTPDataMovement.getGridFTPEndPoints();
            if (gridFTPEndPoint != null && !gridFTPEndPoint.isEmpty()) {
                for (String endpoint : gridFTPEndPoint) {
                    GridftpEndpointResource endpointResource = new GridftpEndpointResource();
                    endpointResource.setDataMovementInterfaceId(resource.getDataMovementInterfaceId());
                    endpointResource.setEndpoint(endpoint);
                    endpointResource.setGridftpDataMovementResource(resource);
                    endpointResource.save();
                }
            }
            return resource.getDataMovementInterfaceId();
        }
        catch (Exception e) {
            logger.error("Error while saving GridFTP Data Movement...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public ComputeResourceDescription getComputeResource(String resourceId) throws AppCatalogException {
        try {
            ComputeResourceResource resource = new ComputeResourceResource();
            ComputeResourceResource computeResource = (ComputeResourceResource)resource.get(resourceId);
            return AppCatalogThriftConversion.getComputeHostDescription(computeResource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<ComputeResourceDescription> getComputeResourceList(Map<String, String> filters) throws AppCatalogException {
        List<ComputeResourceDescription> computeResourceDescriptions = new ArrayList<ComputeResourceDescription>();
        try {
            ComputeResourceResource resource = new ComputeResourceResource();
            for (String fieldName : filters.keySet()) {
                if (fieldName.equals("hostName")) {
                    List<AppCatalogResource> resources = resource.get("hostName", filters.get(fieldName));
                    if (resources == null || resources.isEmpty()) continue;
                    computeResourceDescriptions = AppCatalogThriftConversion.getComputeDescriptionList(resources);
                    continue;
                }
                logger.error("Unsupported field name for compute resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for compute resource.");
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return computeResourceDescriptions;
    }

    public List<ComputeResourceDescription> getAllComputeResourceList() throws AppCatalogException {
        List<ComputeResourceDescription> computeResourceDescriptions = new ArrayList<ComputeResourceDescription>();
        try {
            ComputeResourceResource resource = new ComputeResourceResource();
            List<AppCatalogResource> resources = resource.getAll();
            if (resources != null && !resources.isEmpty()) {
                computeResourceDescriptions = AppCatalogThriftConversion.getComputeDescriptionList(resources);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return computeResourceDescriptions;
    }

    public Map<String, String> getAllComputeResourceIdList() throws AppCatalogException {
        try {
            HashMap<String, String> computeResourceMap = new HashMap<String, String>();
            ComputeResourceResource resource = new ComputeResourceResource();
            List<AppCatalogResource> allComputeResources = resource.getAll();
            if (allComputeResources != null && !allComputeResources.isEmpty()) {
                for (AppCatalogResource cm : allComputeResources) {
                    ComputeResourceResource cmr = (ComputeResourceResource)cm;
                    computeResourceMap.put(cmr.getResourceId(), cmr.getHostName());
                }
            }
            return computeResourceMap;
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public Map<String, String> getAvailableComputeResourceIdList() throws AppCatalogException {
        try {
            HashMap<String, String> computeResourceMap = new HashMap<String, String>();
            ComputeResourceResource resource = new ComputeResourceResource();
            List<AppCatalogResource> allComputeResources = resource.getAll();
            if (allComputeResources != null && !allComputeResources.isEmpty()) {
                for (AppCatalogResource cm : allComputeResources) {
                    ComputeResourceResource cmr = (ComputeResourceResource)cm;
                    if (!cmr.isEnabled()) continue;
                    computeResourceMap.put(cmr.getResourceId(), cmr.getHostName());
                }
            }
            return computeResourceMap;
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public SSHJobSubmission getSSHJobSubmission(String submissionId) throws AppCatalogException {
        try {
            SshJobSubmissionResource resource = new SshJobSubmissionResource();
            resource = (SshJobSubmissionResource)resource.get(submissionId);
            return AppCatalogThriftConversion.getSSHJobSubmissionDescription(resource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving SSH Job Submission...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public UnicoreJobSubmission getUNICOREJobSubmission(String submissionId) throws AppCatalogException {
        try {
            UnicoreJobSubmissionResource resource = new UnicoreJobSubmissionResource();
            resource = (UnicoreJobSubmissionResource)resource.get(submissionId);
            return AppCatalogThriftConversion.getUnicoreJobSubmissionDescription(resource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving UNICORE Job Submission model instance...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public UnicoreDataMovement getUNICOREDataMovement(String dataMovementId) throws AppCatalogException {
        try {
            UnicoreDataMovementResource resource = new UnicoreDataMovementResource();
            resource = (UnicoreDataMovementResource)resource.get(dataMovementId);
            return AppCatalogThriftConversion.getUnicoreDMDescription(resource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving UNICORE data movement...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public CloudJobSubmission getCloudJobSubmission(String submissionId) throws AppCatalogException {
        try {
            CloudSubmissionResource resource = new CloudSubmissionResource();
            resource = (CloudSubmissionResource)resource.get(submissionId);
            return AppCatalogThriftConversion.getCloudJobSubmissionDescription(resource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving SSH Job Submission...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public SCPDataMovement getSCPDataMovement(String dataMoveId) throws AppCatalogException {
        try {
            ScpDataMovementResource resource = new ScpDataMovementResource();
            ScpDataMovementResource dataMovementResource = (ScpDataMovementResource)resource.get(dataMoveId);
            return AppCatalogThriftConversion.getSCPDataMovementDescription(dataMovementResource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving SCP Data Movement...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public GridFTPDataMovement getGridFTPDataMovement(String dataMoveId) throws AppCatalogException {
        try {
            GridftpDataMovementResource resource = new GridftpDataMovementResource();
            GridftpDataMovementResource dataMovementResource = (GridftpDataMovementResource)resource.get(dataMoveId);
            return AppCatalogThriftConversion.getGridFTPDataMovementDescription(dataMovementResource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving Grid FTP Data Movement...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean isComputeResourceExists(String resourceId) throws AppCatalogException {
        try {
            ComputeResourceResource resource = new ComputeResourceResource();
            return resource.isExists(resourceId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void removeComputeResource(String resourceId) throws AppCatalogException {
        try {
            ComputeResourceResource resource = new ComputeResourceResource();
            resource.remove(resourceId);
        }
        catch (Exception e) {
            logger.error("Error while removing compute resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void removeJobSubmissionInterface(String computeResourceId, String jobSubmissionInterfaceId) throws AppCatalogException {
        try {
            JobSubmissionInterfaceResource resource = new JobSubmissionInterfaceResource();
            HashMap<String, String> ids = new HashMap<String, String>();
            ids.put("computeResourceId", computeResourceId);
            ids.put("jobSubmissionInterfaceId", jobSubmissionInterfaceId);
            resource.remove(ids);
        }
        catch (Exception e) {
            logger.error("Error while removing job submission interface..", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void removeDataMovementInterface(String computeResourceId, String dataMovementInterfaceId) throws AppCatalogException {
        try {
            DataMovementInterfaceResource resource = new DataMovementInterfaceResource();
            HashMap<String, String> ids = new HashMap<String, String>();
            ids.put("computeResourceId", computeResourceId);
            ids.put("dataMovementInterfaceId", dataMovementInterfaceId);
            resource.remove(ids);
        }
        catch (Exception e) {
            logger.error("Error while removing data movement interface..", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void removeBatchQueue(String computeResourceId, String queueName) throws AppCatalogException {
        try {
            BatchQueueResource resource = new BatchQueueResource();
            HashMap<String, String> ids = new HashMap<String, String>();
            ids.put("computeResourceId", computeResourceId);
            ids.put("queueName", queueName);
            resource.remove(ids);
        }
        catch (Exception e) {
            logger.error("Error while removing batch queue..", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addResourceJobManager(ResourceJobManager resourceJobManager) throws AppCatalogException {
        Map parallelismPrefix;
        resourceJobManager.setResourceJobManagerId(AppCatalogUtils.getID("RJM"));
        ResourceJobManagerResource resource = AppCatalogThriftConversion.getResourceJobManager(resourceJobManager);
        resource.save();
        Map jobManagerCommands = resourceJobManager.getJobManagerCommands();
        if (jobManagerCommands != null && jobManagerCommands.size() != 0) {
            for (JobManagerCommand commandType : jobManagerCommands.keySet()) {
                if (jobManagerCommands.get(commandType) == null || ((String)jobManagerCommands.get(commandType)).isEmpty()) continue;
                JobManagerCommandResource r = new JobManagerCommandResource();
                r.setCommandType(commandType.toString());
                r.setCommand((String)jobManagerCommands.get(commandType));
                r.setResourceJobManagerId(resource.getResourceJobManagerId());
                r.save();
            }
        }
        if ((parallelismPrefix = resourceJobManager.getParallelismPrefix()) != null && parallelismPrefix.size() != 0) {
            for (ApplicationParallelismType commandType : parallelismPrefix.keySet()) {
                if (parallelismPrefix.get(commandType) == null || ((String)parallelismPrefix.get(commandType)).isEmpty()) continue;
                ParallelismPrefixCommandResource r = new ParallelismPrefixCommandResource();
                r.setCommandType(commandType.toString());
                r.setCommand((String)parallelismPrefix.get(commandType));
                r.setResourceJobManagerId(resource.getResourceJobManagerId());
                r.save();
            }
        }
        return resource.getResourceJobManagerId();
    }

    public void updateResourceJobManager(String resourceJobManagerId, ResourceJobManager updatedResourceJobManager) throws AppCatalogException {
        try {
            Map parallelismPrefix;
            ResourceJobManagerResource resource = AppCatalogThriftConversion.getResourceJobManager(updatedResourceJobManager);
            resource.setResourceJobManagerId(resourceJobManagerId);
            resource.save();
            Map jobManagerCommands = updatedResourceJobManager.getJobManagerCommands();
            if (jobManagerCommands != null && jobManagerCommands.size() != 0) {
                for (JobManagerCommand commandType : jobManagerCommands.keySet()) {
                    JobManagerCommandResource r = new JobManagerCommandResource();
                    HashMap<String, String> ids = new HashMap<String, String>();
                    ids.put("resourceJobManagerId", resourceJobManagerId);
                    ids.put("commandType", commandType.toString());
                    JobManagerCommandResource existingCommand = r.isExists(ids) ? (JobManagerCommandResource)r.get(ids) : new JobManagerCommandResource();
                    if (jobManagerCommands.get(commandType) == null || ((String)jobManagerCommands.get(commandType)).isEmpty()) continue;
                    existingCommand.setCommandType(commandType.toString());
                    existingCommand.setCommand((String)jobManagerCommands.get(commandType));
                    existingCommand.setResourceJobManagerId(resource.getResourceJobManagerId());
                    existingCommand.save();
                }
            }
            if ((parallelismPrefix = updatedResourceJobManager.getParallelismPrefix()) != null && parallelismPrefix.size() != 0) {
                for (ApplicationParallelismType commandType : parallelismPrefix.keySet()) {
                    ParallelismPrefixCommandResource r = new ParallelismPrefixCommandResource();
                    HashMap<String, String> ids = new HashMap<String, String>();
                    ids.put("resourceJobManagerId", resourceJobManagerId);
                    ids.put("commandType", commandType.toString());
                    ParallelismPrefixCommandResource existingCommand = r.isExists(ids) ? (ParallelismPrefixCommandResource)r.get(ids) : new ParallelismPrefixCommandResource();
                    if (parallelismPrefix.get(commandType) == null || ((String)parallelismPrefix.get(commandType)).isEmpty()) continue;
                    existingCommand.setCommandType(commandType.toString());
                    existingCommand.setCommand((String)parallelismPrefix.get(commandType));
                    existingCommand.setResourceJobManagerId(resource.getResourceJobManagerId());
                    existingCommand.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating resource job manager..", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public ResourceJobManager getResourceJobManager(String resourceJobManagerId) throws AppCatalogException {
        try {
            ResourceJobManagerResource resource = new ResourceJobManagerResource();
            ResourceJobManagerResource jobManagerResource = (ResourceJobManagerResource)resource.get(resourceJobManagerId);
            return AppCatalogThriftConversion.getResourceJobManager(jobManagerResource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving resource job manager..", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void deleteResourceJobManager(String resourceJobManagerId) throws AppCatalogException {
        try {
            ResourceJobManagerResource resource = new ResourceJobManagerResource();
            resource.remove(resourceJobManagerId);
        }
        catch (Exception e) {
            logger.error("Error while deleting resource job manager..", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addLocalJobSubmission(LOCALSubmission localSubmission) throws AppCatalogException {
        localSubmission.setJobSubmissionInterfaceId(AppCatalogUtils.getID("LOCAL"));
        String resourceJobManagerId = this.addResourceJobManager(localSubmission.getResourceJobManager());
        LocalSubmissionResource localJobSubmission = AppCatalogThriftConversion.getLocalJobSubmission(localSubmission);
        localJobSubmission.setResourceJobManagerId(resourceJobManagerId);
        localJobSubmission.getResourceJobManagerResource().setResourceJobManagerId(resourceJobManagerId);
        localJobSubmission.setSecurityProtocol(localSubmission.getSecurityProtocol().toString());
        localJobSubmission.save();
        return localJobSubmission.getJobSubmissionInterfaceId();
    }

    public String addLocalDataMovement(LOCALDataMovement localDataMovement) throws AppCatalogException {
        localDataMovement.setDataMovementInterfaceId(AppCatalogUtils.getID("LOCAL"));
        LocalDataMovementResource ldm = AppCatalogThriftConversion.getLocalDataMovement(localDataMovement);
        ldm.save();
        return ldm.getDataMovementInterfaceId();
    }

    public LOCALSubmission getLocalJobSubmission(String submissionId) throws AppCatalogException {
        LocalSubmissionResource localSubmissionResource = new LocalSubmissionResource();
        localSubmissionResource = (LocalSubmissionResource)localSubmissionResource.get(submissionId);
        return AppCatalogThriftConversion.getLocalJobSubmission(localSubmissionResource);
    }

    public LOCALDataMovement getLocalDataMovement(String datamovementId) throws AppCatalogException {
        LocalDataMovementResource localDataMovementResource = new LocalDataMovementResource();
        localDataMovementResource = (LocalDataMovementResource)localDataMovementResource.get(datamovementId);
        return AppCatalogThriftConversion.getLocalDataMovement(localDataMovementResource);
    }
}

