/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.utils;

import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazonaws.services.dynamodbv2.document.utils.FluentHashMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueMap
extends FluentHashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public ValueMap withString(String key, String val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withNumber(String key, BigDecimal val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withNumber(String key, Number val) {
        super.put(key, InternalUtils.toBigDecimal(val));
        return this;
    }

    public ValueMap withInt(String key, int val) {
        return this.withNumber(key, val);
    }

    public ValueMap withLong(String key, long val) {
        return this.withNumber(key, val);
    }

    public ValueMap withBinary(String key, byte[] val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withStringSet(String key, Set<String> val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withStringSet(String key, String ... val) {
        super.put(key, new HashSet<String>(Arrays.asList(val)));
        return this;
    }

    public ValueMap withNumberSet(String key, Set<BigDecimal> val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withNumberSet(String key, BigDecimal ... val) {
        super.put(key, new HashSet<BigDecimal>(Arrays.asList(val)));
        return this;
    }

    public ValueMap withNumberSet(String key, Number ... val) {
        super.put(key, InternalUtils.toBigDecimalSet(val));
        return this;
    }

    public ValueMap withBinarySet(String key, Set<byte[]> val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withBinarySet(String key, byte[] ... val) {
        super.put(key, new HashSet(Arrays.asList(val)));
        return this;
    }

    public ValueMap withList(String key, List<?> val) {
        super.put(key, val == null ? null : new ArrayList(val));
        return this;
    }

    public ValueMap withList(String key, Object ... vals) {
        super.put(key, vals == null ? null : new ArrayList<Object>(Arrays.asList(vals)));
        return this;
    }

    public ValueMap withMap(String key, Map<String, ?> val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withBoolean(String key, boolean val) {
        super.put(key, val);
        return this;
    }

    public ValueMap withNull(String key) {
        super.put(key, null);
        return this;
    }

    public ValueMap with(String key, Object val) {
        if (val == this) {
            throw new IllegalArgumentException("Self reference is not allowed");
        }
        super.put(key, val);
        return this;
    }
}

