/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.TimerTask;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.authentication.AuthenticationInfo;
import org.apache.airavata.gfac.core.cluster.CommandInfo;
import org.apache.airavata.gfac.core.cluster.RawCommandInfo;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.gfac.impl.SSHUtils;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.task.DataStagingTaskModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamData
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(StreamData.class);
    private static final int DEFAULT_SSH_PORT = 22;
    private String publicKeyPath;
    private String passPhrase;
    private String privateKeyPath;
    private String userName;
    private String hostName;
    private String inputPath;
    private TaskContext taskContext;
    private DataStagingTaskModel subTaskModel;

    public StreamData(String userName, String hostName, String inputPath, TaskContext taskContext, DataStagingTaskModel subTaskModel) {
        this.userName = userName;
        this.hostName = hostName;
        this.inputPath = inputPath;
        this.taskContext = taskContext;
        this.subTaskModel = subTaskModel;
    }

    @Override
    public void run() {
        try {
            JobStatus jobStatus = (JobStatus)this.taskContext.getParentProcessContext().getJobModel().getJobStatuses().get(0);
            if (jobStatus != null && jobStatus.getJobState().equals((Object)JobState.ACTIVE)) {
                this.runOutputStaging();
            }
            if (jobStatus != null && jobStatus.getJobState().equals((Object)JobState.COMPLETE) || jobStatus.getJobState().equals((Object)JobState.CANCELED) || jobStatus.getJobState().equals((Object)JobState.FAILED)) {
                this.cancel();
            }
        }
        catch (URISyntaxException e) {
            log.error("expId: {}, processId:{}, taskId: {}:- Couldn't stage file {} , Erroneous path specified", new Object[]{this.taskContext.getExperimentId(), this.taskContext.getProcessId(), this.taskContext.getTaskId(), this.taskContext.getProcessOutput().getName()});
        }
        catch (JSchException | IOException | IllegalAccessException | InstantiationException | AiravataException e) {
            log.error("expId: {}, processId:{}, taskId: {}:- Couldn't stage file {} , Error occurred while streaming data", new Object[]{this.taskContext.getExperimentId(), this.taskContext.getProcessId(), this.taskContext.getTaskId(), this.taskContext.getProcessOutput().getName()});
        }
        catch (CredentialStoreException e) {
            log.error("expId: {}, processId:{}, taskId: {}:- Couldn't stage file {} , Error occurred while connecting with credential store", new Object[]{this.taskContext.getExperimentId(), this.taskContext.getProcessId(), this.taskContext.getTaskId(), this.taskContext.getProcessOutput().getName()});
        }
    }

    public void runOutputStaging() throws URISyntaxException, IllegalAccessException, InstantiationException, CredentialStoreException, AiravataException, IOException, JSchException {
        try {
            URI sourceURI = new URI(this.subTaskModel.getSource());
            String fileName = sourceURI.getPath().substring(sourceURI.getPath().lastIndexOf(File.separator) + 1, sourceURI.getPath().length());
            URI destinationURI = null;
            if (this.subTaskModel.getDestination().startsWith("dummy")) {
                destinationURI = this.getDestinationURI(this.taskContext, fileName);
                this.subTaskModel.setDestination(destinationURI.toString());
            } else {
                destinationURI = new URI(this.subTaskModel.getDestination());
            }
            if (sourceURI.getHost().equalsIgnoreCase(destinationURI.getHost()) && sourceURI.getUserInfo().equalsIgnoreCase(destinationURI.getUserInfo())) {
                this.localDataCopy(this.taskContext, sourceURI, destinationURI);
            }
            Session srcSession = Factory.getSSHSession((AuthenticationInfo)Factory.getComputerResourceSSHKeyAuthentication(this.taskContext.getParentProcessContext()), this.taskContext.getParentProcessContext().getComputeResourceServerInfo());
            Session destSession = Factory.getSSHSession((AuthenticationInfo)Factory.getStorageSSHKeyAuthentication(this.taskContext.getParentProcessContext()), this.taskContext.getParentProcessContext().getStorageResourceServerInfo());
            String targetPath = destinationURI.getPath().substring(0, destinationURI.getPath().lastIndexOf(47));
            SSHUtils.makeDirectory(targetPath, destSession);
            this.outputDataStaging(this.taskContext, srcSession, sourceURI, destSession, destinationURI);
        }
        catch (GFacException e) {
            log.error("expId: {}, processId:{}, taskId: {}:- Couldn't stage file {} , Error while output staging", new Object[]{this.taskContext.getExperimentId(), this.taskContext.getProcessId(), this.taskContext.getTaskId(), this.taskContext.getProcessOutput().getName()});
            throw new AiravataException("Error while output staging", (Throwable)e);
        }
    }

    private void localDataCopy(TaskContext taskContext, URI sourceURI, URI destinationURI) throws GFacException {
        StringBuilder sb = new StringBuilder("rsync -cr ");
        sb.append(sourceURI.getPath()).append(" ").append(destinationURI.getPath());
        RawCommandInfo commandInfo = new RawCommandInfo(sb.toString());
        taskContext.getParentProcessContext().getDataMovementRemoteCluster().execute((CommandInfo)commandInfo);
    }

    public URI getDestinationURI(TaskContext taskContext, String fileName) throws URISyntaxException {
        String filePath = (this.inputPath.endsWith(File.separator) ? this.inputPath : this.inputPath + File.separator) + taskContext.getParentProcessContext().getProcessId() + File.separator + fileName;
        return new URI("SCP", this.hostName, filePath, null);
    }

    private void outputDataStaging(TaskContext taskContext, Session srcSession, URI sourceURI, Session destSession, URI destinationURI) throws AiravataException, IOException, JSchException, GFacException {
        taskContext.getParentProcessContext().getDataMovementRemoteCluster().scpThirdParty(sourceURI.getPath(), srcSession, destinationURI.getPath(), destSession, RemoteCluster.DIRECTION.TO, true);
        GFacUtils.saveExperimentOutput((ProcessContext)taskContext.getParentProcessContext(), (String)taskContext.getProcessOutput().getName(), (String)destinationURI.getPath());
        GFacUtils.saveProcessOutput((ProcessContext)taskContext.getParentProcessContext(), (String)taskContext.getProcessOutput().getName(), (String)destinationURI.getPath());
    }
}

