/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.AiravataStartupException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.logging.MDCUtil;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.common.utils.listener.AbstractActivityListener;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.cpi.GfacService;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.gfac.impl.GFacWorker;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.Subscriber;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.messaging.event.ProcessIdentifier;
import org.apache.airavata.model.messaging.event.ProcessStatusChangeEvent;
import org.apache.airavata.model.messaging.event.ProcessSubmitEvent;
import org.apache.airavata.model.messaging.event.TaskSubmitEvent;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.utils.ZKPaths;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class GfacServerHandler
implements GfacService.Iface {
    private static final Logger log = LoggerFactory.getLogger(GfacServerHandler.class);
    private Subscriber processLaunchSubscriber;
    private static int requestCount = 0;
    private ExperimentCatalog experimentCatalog;
    private AppCatalog appCatalog;
    private String airavataUserName;
    private CuratorFramework curatorClient;
    private Publisher statusPublisher;
    private String airavataServerHostPort;
    private BlockingQueue<TaskSubmitEvent> taskSubmitEvents;
    private static List<AbstractActivityListener> activityListeners = new ArrayList<AbstractActivityListener>();
    private ExecutorService executorService;

    public GfacServerHandler() throws AiravataStartupException {
        try {
            Factory.loadConfiguration();
            this.startCuratorClient();
            this.initZkDataStructure();
            this.initAMQPClient();
            this.executorService = Executors.newFixedThreadPool(ServerSettings.getGFacThreadPoolSize());
        }
        catch (Exception e) {
            throw new AiravataStartupException("Gfac Server Initialization error ", (Throwable)e);
        }
    }

    private void initAMQPClient() throws AiravataException {
        Factory.initPrcessLaunchSubscriber((MessageHandler)new ProcessLaunchMessageHandler());
        this.processLaunchSubscriber = Factory.getProcessLaunchSubscriber();
        this.statusPublisher = Factory.getStatusPublisher();
    }

    private void startCuratorClient() throws ApplicationSettingsException {
        this.curatorClient = Factory.getCuratorClient();
        this.curatorClient.start();
    }

    private void initZkDataStructure() throws Exception {
        this.airavataServerHostPort = ServerSettings.getGfacServerHost() + ":" + ServerSettings.getGFacServerPort();
        ZKPaths.mkdirs((ZooKeeper)this.curatorClient.getZookeeperClient().getZooKeeper(), (String)GFacUtils.getZKGfacServersParentPath());
        ZKPaths.mkdirs((ZooKeeper)this.curatorClient.getZookeeperClient().getZooKeeper(), (String)"/experiments");
        String gfacName = ServerSettings.getGFacServerName();
        if (this.curatorClient.checkExists().forPath(ZKPaths.makePath((String)GFacUtils.getZKGfacServersParentPath(), (String)gfacName)) == null) {
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.curatorClient.create().withMode(CreateMode.EPHEMERAL)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(ZKPaths.makePath((String)GFacUtils.getZKGfacServersParentPath(), (String)gfacName));
        }
        ((BackgroundPathAndBytesable)this.curatorClient.setData().withVersion(-1)).forPath(ZKPaths.makePath((String)GFacUtils.getZKGfacServersParentPath(), (String)gfacName), this.airavataServerHostPort.getBytes());
    }

    public String getGFACServiceVersion() throws TException {
        return "0.16.0";
    }

    public boolean submitProcess(String processId, String gatewayId, String tokenId) throws TException {
        MDC.put((String)"process_id", (String)processId);
        MDC.put((String)"gateway_id", (String)gatewayId);
        MDC.put((String)"token_id", (String)tokenId);
        try {
            this.executorService.execute(MDCUtil.wrapWithMDC((Runnable)new GFacWorker(processId, gatewayId, tokenId)));
        }
        catch (GFacException e) {
            log.error("Failed to submit process", (Throwable)e);
            throw new TException("Failed to submit process", (Throwable)e);
        }
        catch (CredentialStoreException e) {
            log.error("Failed to submit process due to credential issue, make sure you are passing a valid credentials");
            throw new TException("Failed to submit process due to credential issue, make sure you are passing a valid credential token", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Unknown error while submitting the process", (Throwable)e);
            throw new TException("Unknown error while submitting the process", (Throwable)e);
        }
        return true;
    }

    public boolean cancelProcess(String processId, String gatewayId, String tokenId) throws TException {
        return false;
    }

    private void submissionErrorHandling(ProcessStatus status, ProcessSubmitEvent event, TException e) throws RegistryException, AiravataException {
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        ErrorModel errorModel = new ErrorModel();
        errorModel.setUserFriendlyMessage("Process execution failed");
        errorModel.setActualErrorMessage(errors.toString());
        errorModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
        errorModel.setErrorId(AiravataUtils.getId((String)"PROCESS_ERROR"));
        Factory.getDefaultExpCatalog().add(ExpCatChildDataType.PROCESS_ERROR, (Object)errorModel, (Object)event.getProcessId());
        errorModel.setErrorId(AiravataUtils.getId((String)"EXP_ERROR"));
        Factory.getDefaultExpCatalog().add(ExpCatChildDataType.EXPERIMENT_ERROR, (Object)errorModel, (Object)event.getExperimentId());
        status.setState(ProcessState.FAILED);
        status.setReason("Process execution failed");
        status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        Factory.getDefaultExpCatalog().update(ExperimentCatalogModelType.PROCESS_STATUS, (Object)status, (Object)event.getProcessId());
        this.publishProcessStatus(event, status);
    }

    private void setCancelData(String experimentId, String processId) throws Exception {
        String processCancelNodePath = ZKPaths.makePath((String)ZKPaths.makePath((String)ZKPaths.makePath((String)"/experiments", (String)experimentId), (String)processId), (String)"/cancelListener");
        log.info("expId: {}, processId: {}, set process cancel data to zookeeper node {}", new Object[]{experimentId, processId, processCancelNodePath});
        ((BackgroundPathAndBytesable)this.curatorClient.setData().withVersion(-1)).forPath(processCancelNodePath, "CANCEL_REQUEST".getBytes());
    }

    private boolean setCancelWatcher(CuratorFramework curatorClient, String experimentId, String processId) throws Exception {
        String experimentNodePath = GFacUtils.getExperimentNodePath((String)experimentId);
        String experimentCancelNode = ZKPaths.makePath((String)experimentNodePath, (String)"/cancelListener");
        byte[] bytes = (byte[])curatorClient.getData().forPath(experimentCancelNode);
        if (bytes != null && new String(bytes).equalsIgnoreCase("CANCEL_REQUEST")) {
            return true;
        }
        bytes = (byte[])((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)Factory.getCancelRequestWatcher((String)experimentId, (String)processId))).forPath(experimentCancelNode);
        return bytes != null && new String(bytes).equalsIgnoreCase("CANCEL_REQUEST");
    }

    private void publishProcessStatus(ProcessSubmitEvent event, ProcessStatus status) throws AiravataException {
        ProcessIdentifier identifier = new ProcessIdentifier(event.getProcessId(), event.getExperimentId(), event.getGatewayId());
        ProcessStatusChangeEvent processStatusChangeEvent = new ProcessStatusChangeEvent(status.getState(), identifier);
        MessageContext msgCtx = new MessageContext((TBase)processStatusChangeEvent, MessageType.PROCESS, AiravataUtils.getId((String)MessageType.PROCESS.name()), event.getGatewayId());
        msgCtx.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
        this.statusPublisher.publish(msgCtx);
    }

    private void createProcessZKNode(CuratorFramework curatorClient, String gfacServerName, ProcessSubmitEvent event, MessageContext messageContext) throws Exception {
        String processId = event.getProcessId();
        String token = event.getTokenId();
        String experimentId = event.getExperimentId();
        long deliveryTag = messageContext.getDeliveryTag();
        String experimentNodePath = GFacUtils.getExperimentNodePath((String)experimentId);
        String zkProcessNodePath = ZKPaths.makePath((String)experimentNodePath, (String)processId);
        ZKPaths.mkdirs((ZooKeeper)curatorClient.getZookeeperClient().getZooKeeper(), (String)zkProcessNodePath);
        ((BackgroundPathAndBytesable)curatorClient.setData().withVersion(-1)).forPath(zkProcessNodePath, gfacServerName.getBytes());
        ((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)Factory.getRedeliveryReqeustWatcher((String)experimentId, (String)processId))).forPath(zkProcessNodePath);
        String zkProcessCancelPath = ZKPaths.makePath((String)zkProcessNodePath, (String)"/cancelListener");
        ZKPaths.mkdirs((ZooKeeper)curatorClient.getZookeeperClient().getZooKeeper(), (String)zkProcessCancelPath);
        String deliveryTagPath = ZKPaths.makePath((String)zkProcessNodePath, (String)"/deliveryTag");
        ZKPaths.mkdirs((ZooKeeper)curatorClient.getZookeeperClient().getZooKeeper(), (String)deliveryTagPath);
        ((BackgroundPathAndBytesable)curatorClient.setData().withVersion(-1)).forPath(deliveryTagPath, GFacUtils.longToBytes((long)deliveryTag));
        String tokenNodePath = ZKPaths.makePath((String)zkProcessNodePath, (String)"/token");
        ZKPaths.mkdirs((ZooKeeper)curatorClient.getZookeeperClient().getZooKeeper(), (String)tokenNodePath);
        ((BackgroundPathAndBytesable)curatorClient.setData().withVersion(-1)).forPath(tokenNodePath, token.getBytes());
    }

    private void updateDeliveryTag(CuratorFramework curatorClient, String gfacServerName, ProcessSubmitEvent event, MessageContext messageContext) throws Exception {
        String experimentId = event.getExperimentId();
        String processId = event.getProcessId();
        long deliveryTag = messageContext.getDeliveryTag();
        String processNodePath = ZKPaths.makePath((String)GFacUtils.getExperimentNodePath((String)experimentId), (String)processId);
        Stat stat = (Stat)curatorClient.checkExists().forPath(processNodePath);
        if (stat != null) {
            String deliveryTagPath = ZKPaths.makePath((String)processNodePath, (String)"/deliveryTag");
            ((BackgroundPathAndBytesable)curatorClient.setData().withVersion(-1)).forPath(deliveryTagPath, GFacUtils.longToBytes((long)deliveryTag));
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ CuratorFramework access$100(GfacServerHandler x0) {
        return x0.curatorClient;
    }

    static /* synthetic */ void access$200(GfacServerHandler x0, CuratorFramework x1, String x2, ProcessSubmitEvent x3, MessageContext x4) throws Exception {
        x0.updateDeliveryTag(x1, x2, x3, x4);
    }

    static /* synthetic */ Subscriber access$300(GfacServerHandler x0) {
        return x0.processLaunchSubscriber;
    }

    static /* synthetic */ void access$400(GfacServerHandler x0, ProcessSubmitEvent x1, ProcessStatus x2) throws AiravataException {
        x0.publishProcessStatus(x1, x2);
    }

    static /* synthetic */ void access$500(GfacServerHandler x0, CuratorFramework x1, String x2, ProcessSubmitEvent x3, MessageContext x4) throws Exception {
        x0.createProcessZKNode(x1, x2, x3, x4);
    }

    static /* synthetic */ boolean access$600(GfacServerHandler x0, CuratorFramework x1, String x2, String x3) throws Exception {
        return x0.setCancelWatcher(x1, x2, x3);
    }

    static /* synthetic */ void access$700(GfacServerHandler x0, String x1, String x2) throws Exception {
        x0.setCancelData(x1, x2);
    }

    static /* synthetic */ void access$800(GfacServerHandler x0, ProcessStatus x1, ProcessSubmitEvent x2, TException x3) throws RegistryException, AiravataException {
        x0.submissionErrorHandling(x1, x2, x3);
    }

    private class ProcessLaunchMessageHandler
    implements MessageHandler {
        private String experimentNode = "/experiments";
        private String gfacServerName = ServerSettings.getGFacServerName();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onMessage(MessageContext messageContext) {
            block20: {
                MDC.put((String)"gateway_id", (String)messageContext.getGatewayId());
                GfacServerHandler.access$000().info(" Message Received with message id {} and with message type: {}" + messageContext.getMessageId(), (Object)messageContext.getType());
                if (messageContext.getType().equals((Object)MessageType.LAUNCHPROCESS) == false) return;
                status = new ProcessStatus();
                status.setState(ProcessState.STARTED);
                try {
                    block21: {
                        event = new ProcessSubmitEvent();
                        messageEvent = messageContext.getEvent();
                        bytes = ThriftUtils.serializeThriftObject((TBase)messageEvent);
                        ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)event);
                        if (!messageContext.isRedeliver()) ** GOTO lbl19
                        if (Factory.getGfacContext().getProcess(event.getProcessId()) == null) break block21;
                        try {
                            GfacServerHandler.access$200(GfacServerHandler.this, GfacServerHandler.access$100(GfacServerHandler.this), this.gfacServerName, event, messageContext);
                            return;
                        }
                        catch (Exception e) {
                            GfacServerHandler.access$000().error("Error while updating delivery tag for redelivery message , messageId : " + messageContext.getMessageId(), (Throwable)e);
                            GfacServerHandler.access$300(GfacServerHandler.this).sendAck(messageContext.getDeliveryTag());
lbl19:
                            // 3 sources

                            while (true) {
                                status.setTimeOfStateChange(Calendar.getInstance().getTimeInMillis());
                                Factory.getDefaultExpCatalog().update(ExperimentCatalogModelType.PROCESS_STATUS, (Object)status, (Object)event.getProcessId());
                                GfacServerHandler.access$400(GfacServerHandler.this, event, status);
                                MDC.put((String)"experiment_id", (String)event.getExperimentId());
                                try {
                                    GfacServerHandler.access$500(GfacServerHandler.this, GfacServerHandler.access$100(GfacServerHandler.this), this.gfacServerName, event, messageContext);
                                    isCancel = GfacServerHandler.access$600(GfacServerHandler.this, GfacServerHandler.access$100(GfacServerHandler.this), event.getExperimentId(), event.getProcessId());
                                    if (!isCancel) ** GOTO lbl49
                                    if (status.getState() == ProcessState.STARTED) {
                                        status.setState(ProcessState.CANCELLING);
                                        status.setReason("Process Cancel is triggered");
                                        status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                                        Factory.getDefaultExpCatalog().update(ExperimentCatalogModelType.PROCESS_STATUS, (Object)status, (Object)event.getProcessId());
                                        GfacServerHandler.access$400(GfacServerHandler.this, event, status);
                                        status.setState(ProcessState.CANCELED);
                                        status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                                        Factory.getDefaultExpCatalog().update(ExperimentCatalogModelType.PROCESS_STATUS, (Object)status, (Object)event.getProcessId());
                                        GfacServerHandler.access$400(GfacServerHandler.this, event, status);
                                        GfacServerHandler.access$300(GfacServerHandler.this).sendAck(messageContext.getDeliveryTag());
                                        return;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Exception e) {
                                    GfacServerHandler.access$000().error(e.getMessage(), (Throwable)e);
                                    GfacServerHandler.access$300(GfacServerHandler.this).sendAck(messageContext.getDeliveryTag());
                                    return;
                                }
                                break;
                            }
                        }
                    }
                    processStatus = (ProcessStatus)Factory.getDefaultExpCatalog().get(ExperimentCatalogModelType.PROCESS_STATUS, (Object)event.getProcessId());
                    break block20;
lbl-1000:
                    // 1 sources

                    {
                        GfacServerHandler.access$700(GfacServerHandler.this, event.getExperimentId(), event.getProcessId());
lbl49:
                        // 2 sources

                        try {
                            GfacServerHandler.this.submitProcess(event.getProcessId(), event.getGatewayId(), event.getTokenId());
                            return;
                        }
                        catch (TException e) {
                            GfacServerHandler.access$800(GfacServerHandler.this, status, event, e);
                            GfacServerHandler.access$300(GfacServerHandler.this).sendAck(messageContext.getDeliveryTag());
                            return;
                        }
                    }
                }
                catch (TException e) {
                    GfacServerHandler.access$000().error(e.getMessage(), (Throwable)e);
                    return;
                }
                catch (RegistryException e) {
                    GfacServerHandler.access$000().error("Error while updating experiment status", (Throwable)e);
                    return;
                }
                catch (AiravataException e) {
                    GfacServerHandler.access$000().error("Error while publishing process status", (Throwable)e);
                    return;
                }
            }
            status.setState(processStatus.getState());
            ** while (true)
            finally {
                MDC.clear();
            }
        }
    }
}

